/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdMapper;
import com.teamscale.index.testimpact.MethodSet;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.testimpact.TestsToMethodsMapIndexUpdate;
import com.teamscale.index.testimpact.TestsToMethodsMappingUpdateStrategyBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

class SingleParentUpdateStrategy
extends TestsToMethodsMappingUpdateStrategyBase {
    private final CoverageUnitToMethodsMapIndex parentTestsToMethodsMapIndex;
    private final MethodIdMapper methodIdUpdateMaps;
    private final Set<PartitionAndPath> updatedCoverageUnits;

    SingleParentUpdateStrategy(KeyDelta methodInfoIndexDelta, CoverageUnitToMethodsMapIndex parentTestsToMethodsMapIndex, MethodIdMapper methodIdUpdateMaps, Set<PartitionAndPath> updatedCoverageUnits) {
        super(methodInfoIndexDelta);
        this.parentTestsToMethodsMapIndex = parentTestsToMethodsMapIndex;
        this.methodIdUpdateMaps = methodIdUpdateMaps;
        this.updatedCoverageUnits = updatedCoverageUnits;
    }

    @Override
    public Set<PartitionAndPath> calculateUpdateAndStore(CoverageUnitToMethodsMapIndex coverageUnitToMethodsMapIndex) throws StorageException {
        List<MethodId> affectedParentMethodIds = this.methodIdUpdateMaps.getUpdatedAndDeletedParentMethodIds(0);
        Map<MethodId, PartitionedTestSet> testsCoveringAffectedMethods = this.parentTestsToMethodsMapIndex.getTestsCoveringMethods(affectedParentMethodIds);
        List affectedTests = testsCoveringAffectedMethods.values().stream().flatMap(PartitionedTestSet::stream).filter(Predicate.not(this.updatedCoverageUnits::contains)).distinct().collect(Collectors.toList());
        List affectedTestsPartitions = Lists.partition(affectedTests, (int)MAX_TEST_CHUNKS);
        HashSet<PartitionAndPath> updatedTests = new HashSet<PartitionAndPath>();
        for (List affectedTestsPartition : affectedTestsPartitions) {
            Map<PartitionAndPath, MethodSet> updatedTestToMethods = this.getUpdatedTestToMethodsMapping(this.methodIdUpdateMaps, affectedTestsPartition);
            Map<MethodId, PartitionedTestSet> updatedMethodsToTests = SingleParentUpdateStrategy.getUpdatedMethodToTestsMapping(testsCoveringAffectedMethods, this.methodIdUpdateMaps);
            TestsToMethodsMapIndexUpdate update = new TestsToMethodsMapIndexUpdate(updatedMethodsToTests, true, this.methodIdUpdateMaps.getDeletedMethodIds(0), updatedTestToMethods);
            coverageUnitToMethodsMapIndex.storeTestsToMethodsMapIndexUpdate(update);
            updatedTests.addAll(updatedTestToMethods.keySet());
        }
        coverageUnitToMethodsMapIndex.removeMethodLocations(affectedParentMethodIds);
        return updatedTests;
    }

    private Map<PartitionAndPath, MethodSet> getUpdatedTestToMethodsMapping(MethodIdMapper methodLocationMapper, List<PartitionAndPath> affectedTestsPartition) throws StorageException {
        HashMap<PartitionAndPath, MethodSet> updatedTestToMethods = new HashMap<PartitionAndPath, MethodSet>();
        List<MethodSet> affectedMethodsCoveredByTests = this.parentTestsToMethodsMapIndex.getMethodSetsCoveredBy(affectedTestsPartition);
        CollectionUtils.forEachWithException(affectedTestsPartition, affectedMethodsCoveredByTests, (test, coveredMethods) -> SingleParentUpdateStrategy.updateTestToMethods(methodLocationMapper, updatedTestToMethods, test, coveredMethods));
        return updatedTestToMethods;
    }

    private static void updateTestToMethods(MethodIdMapper methodLocationMapper, Map<PartitionAndPath, MethodSet> updatedTestToMethods, PartitionAndPath test, MethodSet coveredMethods) throws StorageException {
        if (coveredMethods == null) {
            return;
        }
        boolean hadChanges = coveredMethods.transform(m -> methodLocationMapper.translateToNewMethodId(0, (MethodId)m));
        if (hadChanges) {
            updatedTestToMethods.put(test, coveredMethods);
        }
    }

    private static Map<MethodId, PartitionedTestSet> getUpdatedMethodToTestsMapping(Map<MethodId, PartitionedTestSet> testsCoveringAffectedMethods, MethodIdMapper methodLocationKeysToMove) throws StorageException {
        HashMap<MethodId, PartitionedTestSet> updatedMethodsToTests = new HashMap<MethodId, PartitionedTestSet>();
        for (Map.Entry<MethodId, PartitionedTestSet> methodToCoveringTests : testsCoveringAffectedMethods.entrySet()) {
            MethodId affectedParentMethod = methodToCoveringTests.getKey();
            Optional<MethodId> newMethodId = methodLocationKeysToMove.translateToNewMethodId(0, affectedParentMethod);
            if (!newMethodId.isPresent() || affectedParentMethod.equals((Object)newMethodId.get())) continue;
            PartitionedTestSet testList = updatedMethodsToTests.computeIfAbsent(newMethodId.get(), key -> new PartitionedTestSet());
            testList.addAll(methodToCoveringTests.getValue());
        }
        return updatedMethodsToTests;
    }
}

