/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class FindingDeltaUtils {
    private static final Pattern ILLEGAL_MESSAGE_PART = Pattern.compile("[^a-zA-Z]+");

    public static String getNormalizedFindingMessage(IndexFinding finding) {
        String message = finding.getMessage();
        if (message == null) {
            return "";
        }
        if (FindingDeltaUtils.shouldSkipMessageNormalization(finding)) {
            return message;
        }
        if (FindingDeltaUtils.shouldNormalizeNonCodeMessagePart(finding)) {
            return FindingDeltaUtils.normalizeNonCodeMessagePart(finding.getMessage());
        }
        return FindingDeltaUtils.normalizeMessagePart(message);
    }

    private static String normalizeMessagePart(String messagePart) {
        return StringUtils.replaceAll((String)messagePart, (Pattern)ILLEGAL_MESSAGE_PART, (String)"").toLowerCase();
    }

    private static boolean shouldNormalizeNonCodeMessagePart(IndexFinding finding) {
        return FindingDeltaUtils.isSimulinkFinding(finding) && !FindingDeltaUtils.isFromExternalUpload(finding);
    }

    @VisibleForTesting
    static String normalizeNonCodeMessagePart(String message) {
        int nextBacktickIndex;
        StringBuilder builder = new StringBuilder();
        int currentIndex = 0;
        while ((nextBacktickIndex = message.indexOf(96, currentIndex)) != -1) {
            builder.append(FindingDeltaUtils.normalizeMessagePart(message.substring(currentIndex, nextBacktickIndex)));
            int numberOfOpeningBackticks = FindingDeltaUtils.countConsecutiveCharsFrom(message, nextBacktickIndex, '`');
            int indexOfClosingSequence = message.indexOf(StringUtils.fillString((int)numberOfOpeningBackticks, (char)'`'), nextBacktickIndex + numberOfOpeningBackticks);
            if (indexOfClosingSequence == -1) {
                return message;
            }
            int indexAfterBacktickClosing = indexOfClosingSequence + numberOfOpeningBackticks;
            builder.append(message, nextBacktickIndex, indexAfterBacktickClosing);
            currentIndex = indexAfterBacktickClosing;
        }
        builder.append(FindingDeltaUtils.normalizeMessagePart(message.substring(currentIndex)));
        return builder.toString();
    }

    private static int countConsecutiveCharsFrom(String input, int from, char matchingChar) {
        if (from >= input.length()) {
            return 0;
        }
        for (int i = from; i < input.length(); ++i) {
            if (input.charAt(i) == matchingChar) continue;
            return i - from;
        }
        return input.length() - from;
    }

    private static boolean shouldSkipMessageNormalization(IndexFinding finding) {
        if (FindingDeltaUtils.isArchitectureFinding(finding) || FindingDeltaUtils.isReviewFinding(finding)) {
            return true;
        }
        return !FindingDeltaUtils.isSimulinkFinding(finding) && FindingDeltaUtils.isFromExternalUpload(finding) && FindingDeltaUtils.hasFileLevelLocation(finding);
    }

    private static boolean isArchitectureFinding(IndexFinding finding) {
        return finding.getGroupName().equals("Architecture Conformance");
    }

    private static boolean isReviewFinding(IndexFinding finding) {
        return finding.getGroupName().equals("Code review");
    }

    private static boolean isSimulinkFinding(IndexFinding finding) {
        return finding.getLocation() instanceof QualifiedNameLocation;
    }

    private static boolean isFromExternalUpload(IndexFinding finding) {
        return !finding.isRealTime();
    }

    private static boolean hasFileLevelLocation(IndexFinding finding) {
        ElementLocation location = finding.getLocation();
        return location.getClass().equals(ElementLocation.class);
    }
}

