/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.optional;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public class OptionalWithException<T> {
    private final @NonNull Optional<T> inner;

    private OptionalWithException(@NonNull Optional<T> inner) {
        this.inner = inner;
    }

    public static <T> @NonNull OptionalWithException<T> ofNullable(@Nullable T inner) {
        return OptionalWithException.wrap(Optional.ofNullable(inner));
    }

    public static <T> @NonNull OptionalWithException<T> wrap(@NonNull Optional<T> optional) {
        return new OptionalWithException<T>(optional);
    }

    public Optional<T> getOptional() {
        return this.inner;
    }

    public <E extends Exception, R> OptionalWithException<R> map(@NonNull FunctionWithException<@NonNull T, @Nullable R, E> mapper) throws E {
        if (this.inner.isEmpty()) {
            return OptionalWithException.wrap(Optional.empty());
        }
        return OptionalWithException.wrap(Optional.ofNullable(mapper.apply(this.inner.get())));
    }

    public <E extends Exception> T orElseGet(@NonNull SupplierWithException<? extends T, ? extends E> supplier) throws E {
        if (this.inner.isPresent()) {
            return this.inner.get();
        }
        return (T)supplier.get();
    }

    public T orElse(T defaultValue) {
        return this.inner.orElse(defaultValue);
    }
}

