/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public final class TeamscaleInstallationUtils {
    private static final String TEAMSCALE_HOME_ENV_VAR = "TEAMSCALE_HOME";
    private static final String TEAMSCALE_CONFIG_ENV_VAR = "TEAMSCALE_CONFIG";
    private static final String CONFIG_DIR_NAME = "config";
    private static final Path WORKING_DIRECTORY = TeamscaleInstallationUtils.detectWorkingDirectory();
    private static final @Nullable Path INSTALLATION_DIRECTORY = TeamscaleInstallationUtils.detectInstallationDirectory();
    private static final ImmutableList<Path> ROOT_DIRECTORIES = TeamscaleInstallationUtils.detectRootDirectories(WORKING_DIRECTORY, INSTALLATION_DIRECTORY);
    private static final ImmutableList<Path> CONFIG_DIRECTORIES = TeamscaleInstallationUtils.detectConfigDirectories(ROOT_DIRECTORIES);
    private static final Logger LOGGER = LogManager.getLogger();

    private TeamscaleInstallationUtils() {
    }

    private static Path detectWorkingDirectory() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    private static Path detectInstallationDirectory() {
        String teamscaleHome = System.getenv(TEAMSCALE_HOME_ENV_VAR);
        if (!StringUtils.isEmpty((String)teamscaleHome)) {
            return Paths.get(teamscaleHome, new String[0]);
        }
        return null;
    }

    private static ImmutableList<Path> detectRootDirectories(Path workingDirectory, Path installationDirectory) {
        ArrayList<Path> rootDirs = new ArrayList<Path>();
        rootDirs.add(workingDirectory);
        if (installationDirectory != null) {
            rootDirs.add(installationDirectory);
        }
        return ImmutableList.copyOf(rootDirs);
    }

    private static ImmutableList<Path> detectConfigDirectories(ImmutableList<Path> rootDirectories) {
        ArrayList<Path> configDirs = new ArrayList<Path>();
        String customConfigDir = System.getenv(TEAMSCALE_CONFIG_ENV_VAR);
        if (!StringUtils.isEmpty((String)customConfigDir)) {
            configDirs.add(Paths.get(customConfigDir, new String[0]));
        }
        rootDirectories.forEach(dir -> configDirs.add(dir.resolve(CONFIG_DIR_NAME)));
        return (ImmutableList)configDirs.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::normalize).distinct().collect(ImmutableList.toImmutableList());
    }

    public static Optional<Path> getInstallationDirectory() {
        return Optional.ofNullable(INSTALLATION_DIRECTORY);
    }

    public static Optional<Path> locateRootPath(String name) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(Paths.get(name, new String[0])), ROOT_DIRECTORIES.stream().map(dir -> dir.resolve(name))}).filter(Files::isReadable).findFirst();
    }

    public static Path getRootPath(String name) {
        return TeamscaleInstallationUtils.locateRootPath(name).orElse(Paths.get(name, new String[0]));
    }

    public static UnmodifiableSet<Path> getRepositoryDirectories(final String name) {
        final HashSet<Path> result = new HashSet<Path>();
        Path rootPath = Paths.get(name, new String[0]).toAbsolutePath();
        if (Files.isDirectory(rootPath, new LinkOption[0])) {
            result.add(rootPath.toAbsolutePath());
        }
        final Path serverPath = TeamscaleInstallationUtils.getTeamscaleRepositoryRootPath(rootPath).resolve("server");
        CCSMAssert.isTrue((boolean)Files.isDirectory(serverPath, new LinkOption[0]), () -> String.format("Expected to find a \"server\" directory within the teamscale repository: %s", serverPath.getParent().toAbsolutePath()));
        try {
            Files.walkFileTree(serverPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (dir.equals(serverPath) || dir.getParent().equals(serverPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (dir.endsWith(name)) {
                        result.add(dir.toAbsolutePath());
                        return FileVisitResult.SKIP_SIBLINGS;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Unable to detect all check-descriptions paths", (Throwable)e);
        }
        return CollectionUtils.asUnmodifiable(result);
    }

    private static Path getTeamscaleRepositoryRootPath(Path rootPath) {
        Path currentPath;
        CCSMAssert.isTrue((boolean)EFeatureToggle.ENABLE_DEV_MODE.isEnabled(), () -> String.format("Expected feature toggle \"%s\" to be enabled", new Object[]{EFeatureToggle.ENABLE_DEV_MODE}));
        for (currentPath = rootPath; currentPath != null && !Files.exists(currentPath.resolve("gradlew.bat"), new LinkOption[0]); currentPath = currentPath.getParent()) {
        }
        return Objects.requireNonNull(currentPath, () -> String.format("Could not find \"teamscale\" repository root directory within: %s", rootPath));
    }

    public static Optional<File> locateConfigFile(String filename) {
        return CONFIG_DIRECTORIES.stream().map(configDir -> configDir.resolve(filename).toFile()).filter(File::canRead).findFirst();
    }

    public static List<Path> getConfigDirectories() {
        return CONFIG_DIRECTORIES;
    }

    public static Stream<File> listConfigFiles() {
        return CONFIG_DIRECTORIES.stream().flatMap(TeamscaleInstallationUtils::listReadableFiles).map(Path::toFile);
    }

    private static Stream<Path> listReadableFiles(Path directory) {
        try {
            return Files.list(directory).filter(Files::isReadable).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }
}

