/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.teamscale.commons.lang.ToStringHelpers;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class NullableFieldValidator {
    public static <T> T ensureAllFieldsNonNull(T parsedObject, String queryContent) throws JsonSerializationException {
        if (StringUtils.isEmpty((String)queryContent)) {
            return parsedObject;
        }
        try {
            return NullableFieldValidator.ensureAllFieldsNonNull(parsedObject);
        }
        catch (JsonSerializationException e) {
            throw new JsonSerializationException(e.getMessage() + "\nQuery: " + queryContent, (Throwable)((Object)e));
        }
    }

    public static <T> T ensureAllFieldsNonNull(T parsedObject) throws JsonSerializationException {
        if (parsedObject == null) {
            throw NullableFieldValidator.createNullObjectException(null, "whole object");
        }
        ArrayDeque<Object> objectsToCheck = new ArrayDeque<Object>();
        if (ReflectionUtils.isIterable(parsedObject)) {
            objectsToCheck.addAll(NullableFieldValidator.checkTopLevelIterableAndGetContainedFields(parsedObject));
        } else {
            objectsToCheck.push(parsedObject);
        }
        IdentityHashSet visitedObjects = new IdentityHashSet();
        while (!objectsToCheck.isEmpty()) {
            Object objectToCheck = objectsToCheck.pop();
            if (!visitedObjects.add(objectToCheck)) continue;
            objectsToCheck.addAll(NullableFieldValidator.checkObjectAndGetReferencedFields(objectToCheck));
        }
        return parsedObject;
    }

    private static <T> JsonSerializationException createNullObjectException(T object, String checkedPart) {
        return new JsonSerializationException("The query contained input that would have been deserialized to null (" + checkedPart + ").\nResulting object: " + StringEscapeUtils.escapeJava((String)ToStringHelpers.toReflectiveStringHelper(object).toString()) + " - Missing @Nullable annotation?");
    }

    private static List<Object> checkObjectAndGetReferencedFields(Object objectToCheck) throws JsonSerializationException {
        if (objectToCheck instanceof Map.Entry) {
            Map.Entry entryObjectToCheck = (Map.Entry)objectToCheck;
            return List.of(entryObjectToCheck.getKey(), entryObjectToCheck.getValue());
        }
        ArrayList<Object> referencedObjects = new ArrayList<Object>();
        for (Field field : ReflectionUtils.getAllFields(objectToCheck.getClass())) {
            if (JsonUtils.isNotSerialized(field) || NullableFieldValidator.fieldMaySkipNullCheck(field)) continue;
            field.setAccessible(true);
            try {
                Object referencedObject = field.get(objectToCheck);
                if (referencedObject == null) {
                    throw NullableFieldValidator.createNullObjectException(objectToCheck, "at field " + field.getName());
                }
                if (referencedObject instanceof CollectionMap) {
                    referencedObjects.add(NullableFieldValidator.checkKeysAndValuesOfCollectionMap((CollectionMap)referencedObject));
                } else {
                    if (ReflectionUtils.isIterable((Object)referencedObject)) {
                        boolean reportNullObjects = !NullableFieldValidator.isElementTypeNullable(field);
                        referencedObjects.addAll(NullableFieldValidator.checkIterableAndGetContainedFields(referencedObject, field.getName(), reportNullObjects));
                        continue;
                    }
                    if (referencedObject instanceof Map) {
                        referencedObjects.addAll(NullableFieldValidator.checkKeyAndValueOfMap(field, (Map)referencedObject));
                        continue;
                    }
                }
                if (field.getType().getPackage() == null || !StringUtils.containsOneOf((String)field.getType().getPackage().getName(), (String[])new String[]{"teamscale", "conqat"})) continue;
                referencedObjects.add(referencedObject);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new JsonSerializationException("Could not access field", e);
            }
        }
        return referencedObjects;
    }

    private static List<Object> checkKeyAndValueOfMap(Field field, Map<?, ?> referencedObject) throws JsonSerializationException {
        boolean reportNullObjects = !NullableFieldValidator.isMapKeyTypeNullable(field);
        ArrayList<Object> mapEntryObjects = new ArrayList<Object>();
        mapEntryObjects.addAll(NullableFieldValidator.checkIterableAndGetContainedFields(referencedObject.keySet(), field.getName(), reportNullObjects));
        reportNullObjects = !NullableFieldValidator.isMapValueTypeNullable(field);
        mapEntryObjects.addAll(NullableFieldValidator.checkIterableAndGetContainedFields(referencedObject.values(), field.getName(), reportNullObjects));
        return mapEntryObjects;
    }

    private static boolean isMapKeyTypeNullable(Field field) {
        AnnotatedType annotatedType = field.getAnnotatedType();
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedType annotatedActualTypeArgument = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()[0];
            return annotatedActualTypeArgument.isAnnotationPresent(Nullable.class);
        }
        return false;
    }

    private static boolean isMapValueTypeNullable(Field field) {
        AnnotatedType annotatedType = field.getAnnotatedType();
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedType annotatedActualTypeArgument = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()[1];
            return annotatedActualTypeArgument.isAnnotationPresent(Nullable.class);
        }
        return false;
    }

    private static boolean isElementTypeNullable(Field field) {
        AnnotatedType annotatedType = field.getAnnotatedType();
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedType annotatedActualTypeArgument = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments()[0];
            return annotatedActualTypeArgument.isAnnotationPresent(Nullable.class);
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedType annotatedComponentType = ((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType();
            return annotatedComponentType.isAnnotationPresent(Nullable.class);
        }
        return false;
    }

    private static List<Object> checkTopLevelIterableAndGetContainedFields(Object arrayOrIterable) {
        ArrayList<Object> containedObjects = new ArrayList<Object>();
        for (Object containedObject : ReflectionUtils.asIterable((Object)arrayOrIterable)) {
            if (containedObject == null) continue;
            if (ReflectionUtils.isIterable(containedObject)) {
                containedObjects.addAll(NullableFieldValidator.checkTopLevelIterableAndGetContainedFields(containedObject));
                continue;
            }
            containedObjects.add(containedObject);
        }
        return containedObjects;
    }

    private static List<Object> checkKeysAndValuesOfCollectionMap(CollectionMap<?, ?, ?> collectionMapReference) {
        ArrayList<Object> containedObjects = new ArrayList<Object>((Collection<Object>)collectionMapReference.getKeys());
        containedObjects.addAll(collectionMapReference.getValues());
        return containedObjects;
    }

    private static List<Object> checkIterableAndGetContainedFields(Object arrayOrIterable, String checkedField, boolean reportNullObjects) throws JsonSerializationException {
        ArrayList<Object> containedObjects = new ArrayList<Object>();
        for (Object containedObject : ReflectionUtils.asIterable((Object)arrayOrIterable)) {
            if (containedObject == null) {
                if (!reportNullObjects) continue;
                throw NullableFieldValidator.createNullObjectException(arrayOrIterable, "at field " + checkedField);
            }
            containedObjects.add(containedObject);
        }
        return containedObjects;
    }

    private static boolean fieldMaySkipNullCheck(Field field) {
        return field.getType().isPrimitive() || field.getAnnotatedType().isAnnotationPresent(Nullable.class) || field.getName().contains("$");
    }
}

