/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import java.util.regex.Pattern;

public class GitRefUtils {
    public static final String HEAD_REF_NAME = "HEAD";
    public static final String BRANCH_HEAD_REF_PREFIX = "refs/heads/";
    public static final String REFERENCE_REMOTES_PREFIX = "refs/remotes/origin/";
    public static final String MASTER_BRANCH = "master";
    private static final Pattern COMMIT_HASH_PATTERN = Pattern.compile("^[\\da-f]{40}$");
    private static final String ANONYMOUS_BRANCH_NAME = "_anonymous_";

    public static boolean isCommitHashOrHeadRef(String revision) {
        return revision.equals(HEAD_REF_NAME) || COMMIT_HASH_PATTERN.matcher(revision).matches();
    }

    public static boolean isAnonymousBranchName(String branchName) {
        return branchName != null && branchName.startsWith(ANONYMOUS_BRANCH_NAME);
    }

    public static String createBranchHeadRefName(String branchName) {
        return BRANCH_HEAD_REF_PREFIX + branchName;
    }

    public static String createAnonymousBranchName(String commitHash) {
        return ANONYMOUS_BRANCH_NAME + commitHash;
    }
}

