/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.dotnet;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;

public class LookupBasedCoverageCreator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, LineCoverageInfo> sourceFileIdToCoverage = new HashMap<Integer, LineCoverageInfo>();
    private final Map<Integer, String> sourceFileIdToSourceFilePath = new HashMap<Integer, String>();
    private final CoverageInfoRetriever retriever;

    public LookupBasedCoverageCreator(CoverageInfoRetriever retriever) {
        this.retriever = retriever;
    }

    public void storeFileMapping(int id, String path) {
        this.sourceFileIdToSourceFilePath.put(id, path);
    }

    public void addLineCoverage(int sourceFileID, int lineStart, int lineEnd, ELineCoverage coverage) {
        this.addLineCoverage(sourceFileID, lineStart, lineEnd, coverage, false);
    }

    public void setLineCoverage(int sourceFileID, int lineStart, int lineEnd, ELineCoverage coverage) {
        this.addLineCoverage(sourceFileID, lineStart, lineEnd, coverage, true);
    }

    private void addLineCoverage(int sourceFileID, int lineStart, int lineEnd, ELineCoverage coverage, boolean removeExistingCoverageForLine) {
        if (!this.sourceFileIdToCoverage.containsKey(sourceFileID)) {
            this.sourceFileIdToCoverage.put(sourceFileID, new LineCoverageInfo(false));
        }
        LineCoverageInfo lineCoverageInfo = this.sourceFileIdToCoverage.get(sourceFileID);
        for (int line = lineStart; line <= lineEnd; ++line) {
            if (removeExistingCoverageForLine) {
                lineCoverageInfo.removeLineCoverageInfo(line);
            }
            lineCoverageInfo.addLineCoverage(line, coverage);
        }
    }

    public void storeCoverageInfo() {
        for (Map.Entry<Integer, LineCoverageInfo> fileIdAndCoverage : this.sourceFileIdToCoverage.entrySet()) {
            String sourceFilePath = this.sourceFileIdToSourceFilePath.get(fileIdAndCoverage.getKey());
            if (sourceFilePath == null) {
                LOGGER.error("No source file with the ID '" + String.valueOf(fileIdAndCoverage) + "' found");
                continue;
            }
            this.retriever.getOrCreateLineCoverageInfo(sourceFilePath).addAll(fileIdAndCoverage.getValue());
        }
        this.sourceFileIdToCoverage.clear();
        this.sourceFileIdToSourceFilePath.clear();
    }
}

