/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.FieldIndex;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.TwoColumnTable;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;

public final class LinksTable
extends TwoColumnTable {
    private final FieldIndex allLinksIndex;

    public LinksTable(@NotNull PersistentStoreTransaction txn, @NotNull String name, @NotNull StoreConfig config) {
        super(txn, name, config);
        this.allLinksIndex = FieldIndex.fieldIndex(txn, name);
    }

    public boolean put(@NotNull Transaction txn, long localId, @NotNull ByteIterable value, boolean noOldValue, int linkId) {
        PropertyKey linkKey = new PropertyKey(localId, linkId);
        boolean success = super.put(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(linkKey), value);
        if (noOldValue) {
            success |= this.allLinksIndex.put(txn, linkId, localId);
        }
        return success;
    }

    public boolean delete(@NotNull Transaction txn, long localId, @NotNull ByteIterable value, boolean noNewValue, int linkId) {
        PropertyKey linkKey = new PropertyKey(localId, linkId);
        boolean success = super.delete(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(linkKey), value);
        if (noNewValue) {
            success |= this.deleteAllIndex(txn, linkId, localId);
        }
        return success;
    }

    public boolean deleteAllIndex(@NotNull Transaction txn, int linkId, long localId) {
        return this.allLinksIndex.remove(txn, linkId, localId);
    }

    public FieldIndex getAllLinksIndex() {
        return this.allLinksIndex;
    }

    @Override
    public boolean canBeCached() {
        return super.canBeCached() && !this.allLinksIndex.getStore().getConfig().temporaryEmpty;
    }
}

