/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.client.internal.LfsRequest;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.common.data.CreateLockReq;
import ru.bozaro.gitlfs.common.data.CreateLockRes;
import ru.bozaro.gitlfs.common.data.Lock;
import ru.bozaro.gitlfs.common.data.LockConflictRes;
import ru.bozaro.gitlfs.common.data.Ref;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lru/bozaro/gitlfs/client/internal/LockCreate;", "Lru/bozaro/gitlfs/client/internal/Request;", "Lru/bozaro/gitlfs/client/internal/LockCreate$Res;", "path", "", "ref", "Lru/bozaro/gitlfs/common/data/Ref;", "(Ljava/lang/String;Lru/bozaro/gitlfs/common/data/Ref;)V", "createRequest", "Lru/bozaro/gitlfs/client/internal/LfsRequest;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "url", "processResponse", "response", "Lorg/apache/http/HttpResponse;", "statusCodes", "", "Res", "gitlfs-client"})
public final class LockCreate
implements Request<Res> {
    @NotNull
    private final String path;
    @Nullable
    private final Ref ref;

    public LockCreate(@NotNull String path, @Nullable Ref ref) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.ref = ref;
    }

    @Override
    @NotNull
    public LfsRequest createRequest(@NotNull ObjectMapper mapper, @NotNull String url) throws JsonProcessingException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpPost req = new HttpPost(url);
        req.addHeader("Accept", "application/vnd.git-lfs+json");
        CreateLockReq createLockReq = new CreateLockReq(this.path, this.ref);
        AbstractHttpEntity entity = (AbstractHttpEntity)new ByteArrayEntity(mapper.writeValueAsBytes((Object)createLockReq));
        entity.setContentType("application/vnd.git-lfs+json");
        req.setEntity((HttpEntity)entity);
        return new LfsRequest((HttpUriRequest)req, entity);
    }

    @Override
    @NotNull
    public Res processResponse(@NotNull ObjectMapper mapper, @NotNull HttpResponse response) throws IOException {
        Res res;
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        switch (response.getStatusLine().getStatusCode()) {
            case 201: {
                res = new Res(true, ((CreateLockRes)mapper.readValue(response.getEntity().getContent(), CreateLockRes.class)).getLock(), null);
                break;
            }
            case 409: {
                LockConflictRes res2 = (LockConflictRes)mapper.readValue(response.getEntity().getContent(), LockConflictRes.class);
                res = new Res(false, res2.getLock(), res2.getMessage());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return res;
    }

    @Override
    @NotNull
    public int[] statusCodes() {
        int[] nArray = new int[]{201, 409};
        return nArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lru/bozaro/gitlfs/client/internal/LockCreate$Res;", "", "isSuccess", "", "lock", "Lru/bozaro/gitlfs/common/data/Lock;", "message", "", "(ZLru/bozaro/gitlfs/common/data/Lock;Ljava/lang/String;)V", "()Z", "getLock", "()Lru/bozaro/gitlfs/common/data/Lock;", "getMessage", "()Ljava/lang/String;", "gitlfs-client"})
    public static final class Res {
        private final boolean isSuccess;
        @NotNull
        private final Lock lock;
        @Nullable
        private final String message;

        public Res(boolean isSuccess, @NotNull Lock lock, @Nullable String message) {
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            this.isSuccess = isSuccess;
            this.lock = lock;
            this.message = message;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        @NotNull
        public final Lock getLock() {
            return this.lock;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }
    }
}

