/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class OpenSqlWriteStatement {
    protected List<IToken> tokens;
    protected ShallowEntity entity;
    protected ITypeResolution typeResolution;
    private static final EnumSet<ETokenType> MEMBER_ARROWS = EnumSet.of(ETokenType.ARROW, ETokenType.EQGT);

    private OpenSqlWriteStatement(ShallowEntity entity, List<IToken> tokens, ITypeResolution typeResolution) {
        this.entity = entity;
        this.tokens = CollectionUtils.asUnmodifiable(tokens);
        this.typeResolution = typeResolution;
    }

    protected int getTableTokenIndex() {
        return 1;
    }

    protected abstract boolean hasSureITabSyntax();

    public boolean targetsInternalTable() {
        if (this.hasSureITabSyntax()) {
            return true;
        }
        int nameStartIndex = this.getTableTokenIndex();
        if (this.isFieldSymbolStart(nameStartIndex) || this.isClassMemberStart(nameStartIndex)) {
            return true;
        }
        String tableName = this.tokens.get(nameStartIndex).getText();
        if (tableName.length() > 16 || tableName.startsWith("(")) {
            return true;
        }
        return AbapCheckUtils.isVariable(tableName, this.entity, this.typeResolution);
    }

    public IToken getStatementStartToken() {
        return this.tokens.getFirst();
    }

    public String getTableName() {
        return this.getTableNameToken().getText().toUpperCase();
    }

    public IToken getTableNameToken() {
        return this.tokens.get(this.getTableTokenIndex());
    }

    private boolean isFieldSymbolStart(int index) {
        if (this.tokens.size() <= index + 2) {
            return false;
        }
        return this.tokens.get(index).getType() == ETokenType.LT && this.tokens.get(index + 2).getType() == ETokenType.GT;
    }

    private boolean isClassMemberStart(int index) {
        if (this.tokens.size() <= index + 2) {
            return false;
        }
        return MEMBER_ARROWS.contains(this.tokens.get(index + 1).getType());
    }

    public boolean targetsStandardDatabaseTable() {
        if (this.targetsInternalTable()) {
            return false;
        }
        String currentTableName = LanguageFeatureParser.ABAP.normalizeVariable(this.getTableName());
        if (StringUtils.startsWithOneOf((String)currentTableName, (String[])new String[]{"/", "y", "z"})) {
            return false;
        }
        return !currentTableName.equals("extract") && !currentTableName.equals("total");
    }

    public static OpenSqlWriteStatement create(ShallowEntity entity, List<IToken> tokens, ITypeResolution typeResolution) {
        ETokenType type = tokens.get(0).getType();
        if (tokens.size() < 2 || !EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD).contains(tokens.get(1).getType().getTokenClass())) {
            return null;
        }
        return switch (type) {
            case ETokenType.INSERT -> {
                if (TokenStreamUtils.startsWith(tokens, ETokenType.INSERT, ETokenType.REPORT) || TokenStreamUtils.startsWith(tokens, ETokenType.INSERT, ETokenType.LPAREN) || TokenStreamUtils.startsWith(tokens, ETokenType.INSERT, ETokenType.TEXTPOOL)) {
                    yield null;
                }
                yield OpenSqlWriteStatement.filterInternal(new TableInsert(entity, tokens, typeResolution));
            }
            case ETokenType.MODIFY -> {
                if (TokenStreamUtils.startsWith(tokens, ETokenType.MODIFY, ETokenType.SCREEN) || TokenStreamUtils.startsWith(tokens, ETokenType.MODIFY, ETokenType.LINE) || TokenStreamUtils.startsWith(tokens, ETokenType.MODIFY, ETokenType.AUGMENTING, ETokenType.ENTITIES) || TokenStreamUtils.startsWith(tokens, ETokenType.MODIFY, ETokenType.ENTITIES) || TokenStreamUtils.startsWith(tokens, ETokenType.MODIFY, ETokenType.ENTITY)) {
                    yield null;
                }
                yield OpenSqlWriteStatement.filterInternal(new TableModify(entity, tokens, typeResolution));
            }
            case ETokenType.UPDATE -> OpenSqlWriteStatement.filterInternal(new TableUpdate(entity, tokens, typeResolution));
            case ETokenType.DELETE -> {
                if (TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.DATASET) || TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.DYNPRO) || TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.REPORT) || TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.TEXTPOOL) || TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.FROM, ETokenType.SHARED, ETokenType.BUFFER) || TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.FROM, ETokenType.SHARED, ETokenType.MEMORY) || TokenStreamUtils.startsWith(tokens, ETokenType.DELETE, ETokenType.FROM, ETokenType.MEMORY)) {
                    yield null;
                }
                yield OpenSqlWriteStatement.filterInternal(new TableDelete(entity, tokens, typeResolution));
            }
            default -> throw new IllegalArgumentException("Unsupported statement type " + String.valueOf(type));
        };
    }

    private static OpenSqlWriteStatement filterInternal(OpenSqlWriteStatement statement) {
        if (statement.targetsInternalTable()) {
            return null;
        }
        return statement;
    }

    private static class TableInsert
    extends OpenSqlWriteStatement {
        public TableInsert(ShallowEntity entity, List<IToken> tokens, ITypeResolution typeResolution) {
            super(entity, tokens, typeResolution);
        }

        @Override
        protected int getTableTokenIndex() {
            if (TokenStreamUtils.startsWith(this.tokens, ETokenType.INSERT, ETokenType.INTO)) {
                return 2;
            }
            return 1;
        }

        @Override
        public boolean hasSureITabSyntax() {
            boolean hasInsertIntoConsecutive = TokenStreamUtils.startsWith(this.tokens, ETokenType.INSERT, ETokenType.INTO);
            boolean hasInsertIntoAnywhere = TokenStreamUtils.containsAll((List<IToken>)this.tokens, 0, this.tokens.size() - 1, ETokenType.INSERT, ETokenType.INTO);
            return hasInsertIntoAnywhere && !hasInsertIntoConsecutive || TokenStreamUtils.containsAny((List<IToken>)this.tokens, ETokenType.INDEX);
        }
    }

    private static class TableModify
    extends OpenSqlWriteStatement {
        protected TableModify(ShallowEntity entity, List<IToken> tokens, ITypeResolution typeResolution) {
            super(entity, tokens, typeResolution);
        }

        @Override
        public boolean hasSureITabSyntax() {
            return TokenStreamUtils.startsWith(this.tokens, ETokenType.MODIFY, ETokenType.TABLE) || TokenStreamUtils.containsAny((List<IToken>)this.tokens, ETokenType.INDEX, ETokenType.TRANSPORTING, ETokenType.ASSIGNING, ETokenType.WHERE) || TokenStreamUtils.containsSequence((List<IToken>)this.tokens, 0, this.tokens.size() - 1, ETokenType.REFERENCE, ETokenType.INTO) || TokenStreamUtils.containsSequence((List<IToken>)this.tokens, 0, this.tokens.size() - 1, ETokenType.USING, ETokenType.KEY);
        }
    }

    private static class TableUpdate
    extends OpenSqlWriteStatement {
        protected TableUpdate(ShallowEntity entity, List<IToken> tokens, ITypeResolution typeResolution) {
            super(entity, tokens, typeResolution);
        }

        @Override
        public boolean hasSureITabSyntax() {
            return false;
        }
    }

    private static class TableDelete
    extends OpenSqlWriteStatement {
        public TableDelete(ShallowEntity entity, List<IToken> tokens, ITypeResolution typeResolution) {
            super(entity, tokens, typeResolution);
        }

        @Override
        protected int getTableTokenIndex() {
            if (TokenStreamUtils.startsWith(this.tokens, ETokenType.DELETE, ETokenType.FROM)) {
                return 2;
            }
            return 1;
        }

        @Override
        public boolean hasSureITabSyntax() {
            if (TokenStreamUtils.startsWith(this.tokens, ETokenType.DELETE, ETokenType.TABLE) || TokenStreamUtils.startsWith(this.tokens, ETokenType.DELETE, ETokenType.ADJACENT, ETokenType.DUPLICATES) || TokenStreamUtils.containsAny((List<IToken>)this.tokens, ETokenType.INDEX) || TokenStreamUtils.containsSequence((List<IToken>)this.tokens, 0, this.tokens.size() - 1, ETokenType.USING, ETokenType.KEY)) {
                return true;
            }
            int indexOfFrom = TokenStreamUtils.firstTokenMatching(this.tokens, (ITokenMatcher)ETokenType.FROM);
            if (indexOfFrom != -1) {
                String text = ((IToken)this.tokens.get(indexOfFrom + 1)).getText();
                return text.chars().allMatch(Character::isDigit);
            }
            return false;
        }
    }
}

