/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.util;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class CheckUtils {
    public static final UnmodifiableSet<ETokenType> BOOLEAN_OPERATOR_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR, ETokenType.AND, ETokenType.OR, ETokenType.XOR));
    public static final UnmodifiableSet<ETokenType> STRING_LITERALS = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.CHARACTER_LITERAL, ETokenType.STRING_LITERAL));
    private static final String SEPARATOR = "#:#";

    public static String buildIdentifier(String categoryName, String groupName, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(categoryName);
        builder.append(SEPARATOR);
        builder.append(groupName);
        builder.append(SEPARATOR);
        builder.append(name);
        return builder.toString();
    }

    public static String getUnquotedTextForCharacterLiteral(IToken token) {
        if (!STRING_LITERALS.contains((Object)token.getType())) {
            return null;
        }
        String unquotedTokenText = StringUtils.strip((String)token.getText(), (String)"'");
        unquotedTokenText = StringUtils.strip((String)unquotedTokenText, (String)"`");
        unquotedTokenText = StringUtils.strip((String)unquotedTokenText, (String)"|");
        return unquotedTokenText;
    }

    public static Pattern compilePatternFromCheckOptionRegex(String regex, String checkName, String optionName) throws CheckException {
        if (StringUtils.isEmpty((String)(regex = regex.trim()))) {
            return null;
        }
        try {
            return Pattern.compile(regex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new CheckException("Syntax error in regular expression '" + regex + "' for option '" + optionName + "' of check '" + checkName + "'", e);
        }
    }
}

