/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.objc;

import eu.cqse.check.framework.preprocessor.c.PreprocessorConditionalTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorIncludeTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ObjectiveCPreprocessingUtils {
    public static List<PreprocessorTokenReplacement> generateNewAtTokensInReplacements(List<IToken> fileTokens, List<PreprocessorTokenReplacement> replacements) {
        for (int i = 0; i < replacements.size(); ++i) {
            Optional<PreprocessorTokenReplacement> newReplacement;
            PreprocessorTokenReplacement currentReplacement = replacements.get(i);
            if (currentReplacement.getReplacementTokens().isEmpty() || currentReplacement instanceof PreprocessorIncludeTokenReplacement || currentReplacement instanceof PreprocessorConditionalTokenReplacement) continue;
            if (ObjectiveCPreprocessingUtils.isAtToken(fileTokens, currentReplacement.originalTokensStartIndex - 1) && (newReplacement = ObjectiveCPreprocessingUtils.mergeReplacementWithPreviousAtInOriginalCode(fileTokens, currentReplacement)).isPresent()) {
                replacements.set(i, newReplacement.get());
                currentReplacement = newReplacement.get();
            }
            if (ObjectiveCPreprocessingUtils.isAtToken((IToken)CollectionUtils.getLast(currentReplacement.getReplacementTokens())) && i < replacements.size() - 1 && currentReplacement.originalTokensEndIndex == replacements.get((int)(i + 1)).originalTokensStartIndex && !replacements.get(i + 1).getReplacementTokens().isEmpty()) {
                newReplacement = ObjectiveCPreprocessingUtils.mergeWithNextReplacementAndMergeAtToken(replacements, i, currentReplacement);
                if (newReplacement.isPresent()) {
                    replacements.set(i, newReplacement.get());
                    replacements.remove(i + 1);
                    currentReplacement = newReplacement.get();
                }
            } else if (ObjectiveCPreprocessingUtils.isAtToken((IToken)CollectionUtils.getLast(currentReplacement.getReplacementTokens())) && (newReplacement = ObjectiveCPreprocessingUtils.mergeReplacementWithSucceedingOriginalToken(fileTokens, currentReplacement)).isPresent()) {
                replacements.set(i, newReplacement.get());
                currentReplacement = newReplacement.get();
            }
            newReplacement = ObjectiveCPreprocessingUtils.combineAtTokensInsideReplacement(currentReplacement);
            if (!newReplacement.isPresent()) continue;
            replacements.set(i, newReplacement.get());
        }
        return replacements;
    }

    private static @NonNull Optional<PreprocessorTokenReplacement> mergeReplacementWithPreviousAtInOriginalCode(List<IToken> fileTokens, PreprocessorTokenReplacement currentReplacement) {
        CCSMAssert.isTrue((boolean)ObjectiveCPreprocessingUtils.isAtToken(fileTokens, currentReplacement.originalTokensStartIndex - 1), (String)"the original code did not have an @ directly before the start of this replacement");
        Optional<PreprocessorTokenReplacement> newReplacement = Optional.empty();
        Optional<IToken> combinedToken = ObjectiveCPreprocessingUtils.combineAtSyntax(fileTokens.get(currentReplacement.originalTokensStartIndex - 1), (IToken)currentReplacement.getReplacementTokens().get(0));
        if (combinedToken.isPresent()) {
            ArrayList<IToken> newReplacementTokens = new ArrayList<IToken>((Collection<IToken>)currentReplacement.getReplacementTokens());
            newReplacementTokens.set(0, combinedToken.get());
            newReplacement = Optional.of(new PreprocessorTokenReplacement(newReplacementTokens, currentReplacement.originalTokensStartIndex - 1, currentReplacement.originalTokensEndIndex, currentReplacement.preprocessorUsageInformation));
        }
        return newReplacement;
    }

    private static @NonNull Optional<PreprocessorTokenReplacement> mergeWithNextReplacementAndMergeAtToken(List<PreprocessorTokenReplacement> replacements, int i, PreprocessorTokenReplacement currentReplacement) {
        Optional<PreprocessorTokenReplacement> newReplacement = Optional.empty();
        IToken nextReplacementStartToken = (IToken)replacements.get(i + 1).getReplacementTokens().get(0);
        Optional<IToken> combinedToken = ObjectiveCPreprocessingUtils.combineAtSyntax((IToken)CollectionUtils.getLast(currentReplacement.getReplacementTokens()), nextReplacementStartToken);
        if (combinedToken.isPresent()) {
            PreprocessorTokenReplacement nextReplacement = replacements.get(i + 1);
            ArrayList<IToken> newReplacementTokens = new ArrayList<IToken>((Collection<IToken>)currentReplacement.getReplacementTokens());
            newReplacementTokens.set(newReplacementTokens.size() - 1, combinedToken.get());
            newReplacementTokens.addAll((Collection<IToken>)nextReplacement.getReplacementTokens().subList(1, nextReplacement.getReplacementTokens().size()));
            newReplacement = Optional.of(new PreprocessorTokenReplacement(newReplacementTokens, currentReplacement.originalTokensStartIndex, nextReplacement.originalTokensEndIndex, currentReplacement.preprocessorUsageInformation));
        }
        return newReplacement;
    }

    private static @NonNull Optional<PreprocessorTokenReplacement> mergeReplacementWithSucceedingOriginalToken(List<IToken> fileTokens, PreprocessorTokenReplacement currentReplacement) {
        Optional<PreprocessorTokenReplacement> newReplacement = Optional.empty();
        IToken nextToken = fileTokens.get(currentReplacement.originalTokensEndIndex);
        Optional<IToken> combinedToken = ObjectiveCPreprocessingUtils.combineAtSyntax((IToken)CollectionUtils.getLast(currentReplacement.getReplacementTokens()), nextToken);
        if (combinedToken.isPresent()) {
            ArrayList<IToken> newReplacementTokens = new ArrayList<IToken>((Collection<IToken>)currentReplacement.getReplacementTokens());
            newReplacementTokens.set(newReplacementTokens.size() - 1, combinedToken.get());
            newReplacement = Optional.of(new PreprocessorTokenReplacement(newReplacementTokens, currentReplacement.originalTokensStartIndex, currentReplacement.originalTokensEndIndex + 1, currentReplacement.preprocessorUsageInformation));
        }
        return newReplacement;
    }

    private static @NonNull Optional<PreprocessorTokenReplacement> combineAtTokensInsideReplacement(PreprocessorTokenReplacement currentReplacement) {
        UnmodifiableList<IToken> currentReplacementTokens = currentReplacement.getReplacementTokens();
        ArrayList<IToken> newReplacementList = new ArrayList<IToken>(currentReplacementTokens.size());
        boolean didChange = false;
        for (int i = 0; i < currentReplacementTokens.size(); ++i) {
            if (ObjectiveCPreprocessingUtils.isAtToken(currentReplacementTokens, i) && i < currentReplacementTokens.size() - 1) {
                Optional<IToken> combined = ObjectiveCPreprocessingUtils.combineAtSyntax((IToken)currentReplacementTokens.get(i), (IToken)currentReplacementTokens.get(i + 1));
                if (!combined.isPresent()) continue;
                newReplacementList.add(combined.get());
                ++i;
                didChange = true;
                continue;
            }
            newReplacementList.add((IToken)currentReplacementTokens.get(i));
        }
        Optional<PreprocessorTokenReplacement> newReplacement = Optional.empty();
        if (didChange) {
            newReplacement = Optional.of(new PreprocessorTokenReplacement(newReplacementList, currentReplacement.originalTokensStartIndex, currentReplacement.originalTokensEndIndex, currentReplacement.preprocessorUsageInformation));
        }
        return newReplacement;
    }

    private static boolean isAtToken(List<IToken> tokens, int position) {
        if (position >= 0 && position < tokens.size()) {
            return ObjectiveCPreprocessingUtils.isAtToken(tokens.get(position));
        }
        return false;
    }

    private static boolean isAtToken(IToken token) {
        return token.getType() == ETokenType.AT_OPERATOR || token.getType() == ETokenType.AT;
    }

    private static Optional<IToken> combineAtSyntax(IToken atToken, IToken nextToken) {
        List<IToken> combined = ScannerUtils.getTokens(atToken.getText() + nextToken.getText(), atToken.getLanguage(), atToken.getOriginId());
        if (combined.size() != 1) {
            return Optional.empty();
        }
        IToken combinedToken = combined.get(0);
        return Optional.of(combinedToken.newToken(combinedToken.getType(), atToken.getOffset(), atToken.getLineNumber(), combinedToken.getText(), "##macro##"));
    }
}

