/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ILenientScanner;
import eu.cqse.check.framework.scanner.IScanner;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerException;
import eu.cqse.check.framework.scanner.ScannerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScannerUtils {
    public static void readTokens(IScanner scanner, List<IToken> tokens, List<ScannerException> exceptions) throws IOException {
        IToken token = null;
        do {
            try {
                token = scanner.getNextToken();
                if (token.getType() == ETokenType.EOF) continue;
                tokens.add(token);
            }
            catch (ScannerException e) {
                exceptions.add(e);
            }
        } while (token != null && token.getType() != ETokenType.EOF);
    }

    public static List<IToken> readTokens(ILenientScanner scanner) throws IOException {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        IToken token = null;
        while ((token = scanner.getNextToken()).getType() != ETokenType.EOF) {
            tokens.add(token);
        }
        return tokens;
    }

    @Deprecated
    public static List<IToken> getTokens(String content, ELanguage language) {
        return ScannerUtils.getTokens(content, language, "##default test origin##");
    }

    public static List<IToken> getTokens(String content, ELanguage language, String origin) {
        ILenientScanner scanner = ScannerFactory.newLenientScanner(language, content, origin);
        try {
            return ScannerUtils.readTokens(scanner);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"can not happen as the scanner is lenient and we are working from memory");
        }
    }
}

