/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cobol;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.cobol.ConditionalClause;
import eu.cqse.check.framework.shallowparser.languages.cobol.ECobolParserState;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class BoundedByOppositeClausesRecognizer
extends RecognizerBase<ECobolParserState> {
    private static final EnumSet<ETokenType> VERBS_WITH_ON_EXCEPTION_CLAUSE = EnumSet.of(ETokenType.CALL, new ETokenType[]{ETokenType.DISPLAY, ETokenType.START, ETokenType.ACCEPT, ETokenType.WAIT, ETokenType.XML});
    private static final EnumSet<ETokenType> VERBS_WITH_ON_ESCAPE_CLAUSE = EnumSet.of(ETokenType.ACCEPT);
    private static final EnumSet<ETokenType> VERBS_WITH_AT_END_CLAUSE = EnumSet.of(ETokenType.READ, ETokenType.RETURN);
    private static final EnumSet<ETokenType> VERBS_WITH_AT_ENDOFPAGE_CLAUSE = EnumSet.of(ETokenType.WRITE);
    private static final EnumSet<ETokenType> VERBS_WITH_AT_EOP_CLAUSE = EnumSet.of(ETokenType.WRITE);
    private static final EnumSet<ETokenType> VERBS_WITH_INVALID_KEY_CLAUSE = EnumSet.of(ETokenType.READ, ETokenType.WRITE, ETokenType.START, ETokenType.DELETE, ETokenType.REWRITE);
    private static final EnumSet<ETokenType> VERBS_WITH_ON_OVERFLOW_CLAUSE = EnumSet.of(ETokenType.STRING, ETokenType.UNSTRING, ETokenType.CALL);
    private static final EnumSet<ETokenType> VERBS_WITH_ON_SIZE_ERROR_CLAUSE = EnumSet.of(ETokenType.COMPUTE, ETokenType.ADD, ETokenType.SUBTRACT, ETokenType.MULTIPLY, ETokenType.DIVIDE);

    private static List<ConditionalClause> getConditionalClauses(ETokenType verb) {
        ArrayList<ConditionalClause> conditionalClauses = new ArrayList<ConditionalClause>();
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_ON_EXCEPTION_CLAUSE, verb, List.of(ETokenType.EXCEPTION), ETokenType.ON, true);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_ON_ESCAPE_CLAUSE, verb, List.of(ETokenType.ESCAPE), ETokenType.ON, true);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_AT_END_CLAUSE, verb, List.of(ETokenType.END), ETokenType.AT, true);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_AT_ENDOFPAGE_CLAUSE, verb, List.of(ETokenType.END_OF_PAGE), ETokenType.AT, true);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_AT_EOP_CLAUSE, verb, List.of(ETokenType.EOP), ETokenType.AT, true);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_INVALID_KEY_CLAUSE, verb, List.of(ETokenType.INVALID), ETokenType.KEY, false);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_ON_OVERFLOW_CLAUSE, verb, List.of(ETokenType.OVERFLOW), ETokenType.ON, true);
        BoundedByOppositeClausesRecognizer.updateConditionalClauses(conditionalClauses, VERBS_WITH_ON_SIZE_ERROR_CLAUSE, verb, List.of(ETokenType.SIZE, ETokenType.ERROR), ETokenType.ON, true);
        return conditionalClauses;
    }

    private static void updateConditionalClauses(List<ConditionalClause> clauses, EnumSet<ETokenType> clauseVerbs, ETokenType verb, List<ETokenType> mandatoryTokens, ETokenType optionalToken, boolean optionalTokenStartsClause) {
        if (clauseVerbs.contains(verb)) {
            clauses.add(new ConditionalClause(mandatoryTokens, optionalToken, optionalTokenStartsClause));
        }
    }

    private static boolean boundedByDifferentClauses(List<IToken> tokens, int verbIndex, int startOffset) {
        List<ConditionalClause> clauses = BoundedByOppositeClausesRecognizer.getConditionalClauses(tokens.get(verbIndex).getType());
        for (ConditionalClause clause : clauses) {
            ETokenType[] negatedClauseWithoutOptionalToken;
            ETokenType[] clauseWithOptionalToken = clause.getClauseTokens(true);
            ETokenType[] clauseWithoutOptionalToken = clause.getClauseTokens(false);
            ETokenType[] negatedClauseWithOptionalToken = clause.getNegatedClauseTokens(true);
            if (BoundedByOppositeClausesRecognizer.boundedByClauses(clauseWithOptionalToken, negatedClauseWithOptionalToken, negatedClauseWithoutOptionalToken = clause.getNegatedClauseTokens(false), tokens, verbIndex, startOffset) && tokens.get(verbIndex - clauseWithOptionalToken.length - 1).getType() != ETokenType.NOT) {
                return true;
            }
            if (BoundedByOppositeClausesRecognizer.boundedByClauses(clauseWithoutOptionalToken, negatedClauseWithOptionalToken, negatedClauseWithoutOptionalToken, tokens, verbIndex, startOffset) && tokens.get(verbIndex - clauseWithoutOptionalToken.length - 1).getType() != ETokenType.ON && tokens.get(verbIndex - clauseWithoutOptionalToken.length - 1).getType() != ETokenType.NOT) {
                return true;
            }
            if (BoundedByOppositeClausesRecognizer.boundedByClauses(negatedClauseWithOptionalToken, clauseWithOptionalToken, clauseWithoutOptionalToken, tokens, verbIndex, startOffset)) {
                return true;
            }
            if (!BoundedByOppositeClausesRecognizer.boundedByClauses(negatedClauseWithoutOptionalToken, clauseWithOptionalToken, clauseWithoutOptionalToken, tokens, verbIndex, startOffset)) continue;
            return true;
        }
        return false;
    }

    private static boolean boundedByClauses(ETokenType[] startClauseTokens, ETokenType[] firstEndClauseTokens, ETokenType[] secondEndClauseTokens, List<IToken> tokens, int verbIndex, int startOffset) {
        if (!TokenStreamUtils.containsSequence(tokens, verbIndex - startClauseTokens.length, verbIndex, startClauseTokens)) {
            return false;
        }
        return TokenStreamUtils.containsSequence(tokens, startOffset, startOffset + firstEndClauseTokens.length, firstEndClauseTokens) || TokenStreamUtils.containsSequence(tokens, startOffset, startOffset + secondEndClauseTokens.length, secondEndClauseTokens);
    }

    @Override
    protected int matchesLocally(ParserState<ECobolParserState> parserState, List<IToken> tokens, int startOffset) {
        int referencePosition = parserState.getCurrentReferencePosition();
        if (referencePosition - 3 < 0 || startOffset + 2 > tokens.size() - 1 || startOffset == tokens.size()) {
            return -1;
        }
        if (BoundedByOppositeClausesRecognizer.boundedByDifferentClauses(tokens, referencePosition, startOffset)) {
            return -1;
        }
        return super.matchesLocally(parserState, tokens, startOffset);
    }
}

