/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.cs;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.PropertyAccessNameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.cs.CsSubExpressionRecognizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CsShallowParser
extends CStyleShallowParserBase {
    public static final ITokenMatcher VALID_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ADD, ETokenType.ALIAS, ETokenType.ASCENDING, ETokenType.ASYNC, ETokenType.AWAIT, ETokenType.DESCENDING, ETokenType.DYNAMIC, ETokenType.FROM, ETokenType.GET, ETokenType.GLOBAL, ETokenType.GROUP, ETokenType.INTO, ETokenType.JOIN, ETokenType.LET, ETokenType.ORDERBY, ETokenType.PARTIAL, ETokenType.REMOVE, ETokenType.SELECT, ETokenType.SET, ETokenType.VALUE, ETokenType.VAR, ETokenType.WHERE, ETokenType.YIELD, ETokenType.RECORD, ETokenType.INIT, ETokenType.FILE});
    private static final ITokenMatcher PRIMITIVE_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VOID, ETokenType.BYTE, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.CHAR, ETokenType.BOOL, ETokenType.STRING, ETokenType.OBJECT, ETokenType.DECIMAL, ETokenType.SBYTE, ETokenType.USHORT, ETokenType.UINT, ETokenType.ULONG, ETokenType.NINT, ETokenType.NUINT});
    private static final ITokenMatcher EVENT_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.INTERNAL, ETokenType.STATIC, ETokenType.VIRTUAL, ETokenType.SEALED, ETokenType.ABSTRACT});

    public CsShallowParser() {
        super(EnumSet.of(EGenericParserStates.TOP_LEVEL));
    }

    @Override
    public List<ShallowEntity> parseTopLevelWithErrors(List<IToken> tokens) throws ShallowParserException {
        ArrayList<IToken> modifiedTokens = new ArrayList<IToken>(tokens);
        if (!tokens.isEmpty()) {
            modifiedTokens.add(TokenStreamUtils.createToken(tokens.getLast(), "", ETokenType.EOF));
        }
        return super.parseTopLevelWithErrors(modifiedTokens);
    }

    @Override
    protected void createMetaRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE}).markStart().optional(new ITokenMatcher[]{ETokenType.GLOBAL}).sequence(new ITokenMatcher[]{ETokenType.USING}).optional(new ITokenMatcher[]{ETokenType.STATIC}).markStart().optional(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.EQ}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}))).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "using", INameResolver.ofRange(0, -2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE, EGenericParserStates.IN_MODULE, EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).createNode(EShallowEntityType.META, "attribute annotation", INameResolver.secondMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACK, ETokenType.LBRACK, ETokenType.RBRACK).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PREPROCESSOR_DIRECTIVE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        super.createMetaRules();
    }

    @Override
    protected void createTypeRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE}).sequence(new ITokenMatcher[]{ETokenType.NAMESPACE, this.getIdentifierMatcher()}).repeated(new ITokenMatcher[]{ETokenType.DOT, this.getIdentifierMatcher()}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.MODULE, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).parseUntil(EGenericParserStates.IN_MODULE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.NAMESPACE, this.getIdentifierMatcher()}).repeated(new ITokenMatcher[]{ETokenType.DOT, this.getIdentifierMatcher()}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.MODULE, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).parseUntil(EGenericParserStates.IN_MODULE).sequenceBefore(new ITokenMatcher[]{ETokenType.EOF}).endNode();
        super.createTypeRules();
        RecognizerBase recordStartRecognizer = this.inAnyState().repeated(this.getTypeModifier()).markStart().sequence(new ITokenMatcher[]{ETokenType.RECORD, this.getIdentifierMatcher()}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON})).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText());
        recordStartRecognizer.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        recordStartRecognizer.sequence(new ITokenMatcher[0]).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    @Override
    public ITokenMatcher getTypeKeywordsMatcher() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.INTERFACE, ETokenType.ENUM, ETokenType.STRUCT});
    }

    @Override
    protected ITokenMatcher getTypeModifier() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.ABSTRACT, ETokenType.SEALED, ETokenType.INTERNAL, ETokenType.PARTIAL, ETokenType.STATIC, ETokenType.FILE});
    }

    private ITokenMatcher getTypeAndMemberModifiers() {
        return this.getTypeModifier().or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROTECTED, ETokenType.VIRTUAL, ETokenType.ASYNC, ETokenType.CONST, ETokenType.EVENT, ETokenType.EXTERN, ETokenType.OVERRIDE, ETokenType.READONLY, ETokenType.UNSAFE, ETokenType.VOLATILE, ETokenType.NEW, ETokenType.REQUIRED})});
    }

    @Override
    protected void createClassElementsRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.EQ, ETokenType.RBRACE})).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.RBRACE})).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        this.typePattern(this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE}).optional(this.getTypeAndMemberModifiers()).markStart().sequence(new ITokenMatcher[]{ETokenType.DELEGATE})).sequence(new ITokenMatcher[]{this.getIdentifierMatcher(), ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.ofIndex(-2)).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createMethodRules();
        this.createEventsRules();
        this.createPropertyRules();
        this.typePatternInState(EGenericParserStates.IN_TYPE).sequence(this.getIdentifierMatcher()).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, ETokenType.LBRACE, ETokenType.RBRACE, this.getSubExpressionRecognizer()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET, ETokenType.INIT}), ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, INameResolver.concat(INameResolver.ofString("empty"), INameResolver.firstMatchedTokenText()), (INameResolver)PropertyAccessNameResolver.propertyName()).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET, ETokenType.INIT}), ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), (INameResolver)PropertyAccessNameResolver.propertyName()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET, ETokenType.INIT}), ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), (INameResolver)PropertyAccessNameResolver.propertyName()).parseOnce(EGenericParserStates.IN_METHOD).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.ADD, ETokenType.REMOVE}), ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ADD, ETokenType.REMOVE}), ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText()).parseOnce(EGenericParserStates.IN_METHOD).endNode();
    }

    private void createEventsRules() {
        RecognizerBase<EGenericParserStates> eventRecognizer = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL, EGenericParserStates.IN_MODULE, EGenericParserStates.IN_TYPE}).repeated(EVENT_MODIFIERS).markStart().sequence(new ITokenMatcher[]{ETokenType.EVENT}).sequence(this.getIdentifierMatcher()).skipNested(ETokenType.LT, ETokenType.GT).repeatedSubRecognizer(this.createExplicitInterfaceQualifierRecognizer()).sequence(this.getIdentifierMatcher()).createNode(EShallowEntityType.ATTRIBUTE, "event", INameResolver.previousTokenText());
        eventRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        eventRecognizer.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createPropertyRules() {
        RecognizerBase<EGenericParserStates> alternatives = this.typePatternInState(EGenericParserStates.IN_TYPE).markStart().repeatedSubRecognizer(this.createExplicitInterfaceQualifierRecognizer()).sequence(this.getIdentifierMatcher());
        alternatives.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.ofRange(0, -2)).parseOnce(EGenericParserStates.IN_METHOD).endNode();
        RecognizerBase<EGenericParserStates> braceAlternatives = alternatives.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "property", INameResolver.ofRange(0, -2)).parseUntil(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        braceAlternatives.sequence(new ITokenMatcher[]{ETokenType.EQ, ETokenType.LBRACE}).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.RBRACE}), ETokenType.LBRACE, ETokenType.RBRACE).sequence(new ITokenMatcher[]{ETokenType.COMMA}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.RBRACE).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        braceAlternatives.sequence(new ITokenMatcher[]{ETokenType.EQ}).parseOnce(EGenericParserStates.IN_METHOD).endNode();
        braceAlternatives.endNode();
    }

    private void createMethodRules() {
        CsShallowParser.completeMethod("indexer", EShallowEntityType.ATTRIBUTE, EGenericParserStates.IN_TYPE, this.typePatternInState(EGenericParserStates.IN_TYPE).repeatedSubRecognizer(this.createExplicitInterfaceQualifierRecognizer()).markStart().sequence(new ITokenMatcher[]{ETokenType.THIS, ETokenType.LBRACK}).skipAfterWithNesting((ITokenMatcher)ETokenType.RBRACK, ETokenType.LBRACK, ETokenType.RBRACK));
        this.createOperatorOverloadingRules();
        this.createMemberMethodRules();
        this.finishConstructorLike(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.INTERNAL})).markStart(), "constructor");
        this.finishConstructorLike(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.STATIC}).markStart(), "static constructor");
        this.finishConstructorLike(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.INTERNAL})).sequence(new ITokenMatcher[]{ETokenType.COMP}).markStart(), "destructor");
    }

    private void createMemberMethodRules() {
        CsShallowParser.completeMethod("method", EShallowEntityType.METHOD, EGenericParserStates.IN_METHOD, this.typePatternInState(EGenericParserStates.IN_TYPE).repeatedSubRecognizer(this.createExplicitInterfaceQualifierRecognizer()).markStart().sequence(this.getIdentifierMatcher()).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
    }

    private RecognizerBase<EGenericParserStates> createTypeSuffixRecognizer() {
        RecognizerBase recognizer = this.createRecognizer(start -> start.optional(new ITokenMatcher[]{ETokenType.QUESTION}).optional(new ITokenMatcher[]{ETokenType.MULT}).skipNested(ETokenType.LBRACK, ETokenType.RBRACK));
        return this.createRecognizer(start -> start.skipNested(ETokenType.LT, ETokenType.GT).repeatedSubRecognizer(recognizer));
    }

    private void createOperatorOverloadingRules() {
        ITokenMatcher primitiveOrIdentifier = PRIMITIVE_TYPES.or(new ITokenMatcher[]{ETokenType.IDENTIFIER});
        RecognizerBase operatorBaseRecognizer = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_TYPE}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.INTERNAL, ETokenType.STATIC})).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IMPLICIT, ETokenType.EXPLICIT}), ETokenType.OPERATOR}).markStart();
        CsShallowParser.completeOperator(operatorBaseRecognizer.sequence(primitiveOrIdentifier));
        CsShallowParser.completeOperator(operatorBaseRecognizer.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.QUESTION}));
        ITokenMatcher methodNameMatcher = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.KEYWORD}).or(new ITokenMatcher[]{ETokenType.BOOLEAN_LITERAL});
        CsShallowParser.completeMethod("operator", EShallowEntityType.METHOD, EGenericParserStates.IN_METHOD, this.typePatternInState(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).markStart().sequence(new ITokenMatcher[]{methodNameMatcher, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
        this.createOperatorOverloadingRuleForSequence("<<", new ITokenMatcher[]{ETokenType.LT, ETokenType.LT});
        this.createOperatorOverloadingRuleForSequence(">>", new ITokenMatcher[]{ETokenType.GT, ETokenType.GT});
    }

    private static void completeOperator(RecognizerBase<EGenericParserStates> baseRecognizer) {
        CsShallowParser.completeMethod("operator", EShallowEntityType.METHOD, EGenericParserStates.IN_METHOD, baseRecognizer.skipAfterWithNesting((ITokenMatcher)ETokenType.LPAREN, ETokenType.LT, ETokenType.GT).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
    }

    private void createOperatorOverloadingRuleForSequence(String name, ITokenMatcher ... matchTerms) {
        CsShallowParser.completeMethod("operator", EShallowEntityType.METHOD, INameResolver.ofString(name), EGenericParserStates.IN_METHOD, this.typePatternInState(EGenericParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.OPERATOR}).markStart().sequence(matchTerms).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
    }

    private void finishConstructorLike(RecognizerBase<EGenericParserStates> recognizer, String subtype) {
        RecognizerBase<EGenericParserStates> alternative = recognizer.sequence(new ITokenMatcher[]{this.getIdentifierMatcher(), ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.DOUBLE_ARROW}), ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EGenericParserStates> lambdaAlternative = alternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText());
        lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        lambdaAlternative.parseOnce(EGenericParserStates.IN_METHOD).endNode();
        alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private RecognizerBase<EGenericParserStates> createExplicitInterfaceQualifierRecognizer() {
        return this.createRecognizer(start -> start.sequence(this.getIdentifierMatcher()).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.DOT}));
    }

    private static void completeMethod(String subtype, EShallowEntityType nodeType, INameResolver name, EGenericParserStates subParseState, RecognizerBase<EGenericParserStates> start) {
        RecognizerBase<EGenericParserStates> alternative = start.skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.DOUBLE_ARROW}));
        RecognizerBase<EGenericParserStates> lambdaAlternative = alternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(nodeType, subtype, name);
        lambdaAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        lambdaAlternative.parseOnce(EGenericParserStates.IN_METHOD).endNode();
        alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(nodeType, subtype, name).parseUntil(subParseState).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        alternative.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(nodeType, "abstract " + subtype, name).endNode();
    }

    private static void completeMethod(String subtype, EShallowEntityType nodeType, EGenericParserStates subParseState, RecognizerBase<EGenericParserStates> start) {
        CsShallowParser.completeMethod(subtype, nodeType, INameResolver.firstMatchedTokenText(), subParseState, start);
    }

    @Override
    protected void createStatementRules() {
        this.createLocalFunctionRules();
        super.createStatementRules();
    }

    private void createLocalFunctionRules() {
        ITokenMatcher typeStart = PRIMITIVE_TYPES.or(new ITokenMatcher[]{this.getIdentifierMatcher()});
        this.completeLocalFunction(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).notPreCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.AWAIT}))).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASYNC, ETokenType.UNSAFE, ETokenType.STATIC})).sequence(typeStart).repeated(new ITokenMatcher[]{ETokenType.DOT, typeStart}).optionalSubRecognizer(this.createTypeSuffixRecognizer()));
        this.completeLocalFunction(this.typePattern(this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ASYNC, ETokenType.UNSAFE})).sequence(new ITokenMatcher[]{ETokenType.LPAREN})).sequence(new ITokenMatcher[]{ETokenType.COMMA}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN));
    }

    @Override
    protected void createCaseRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).markStart().sequence(new ITokenMatcher[]{ETokenType.CASE}).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).skipAfterWithNesting(this.getCaseStatementEndTokens(), ETokenType.QUESTION, ETokenType.COLON, this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.QUESTION, ETokenType.LBRACK}))).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT, this.getCaseStatementEndTokens()}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
    }

    private void completeLocalFunction(RecognizerBase<EGenericParserStates> baseRecognozer) {
        RecognizerBase<EGenericParserStates> alternative = baseRecognozer.markStart().sequence(new ITokenMatcher[]{this.getIdentifierMatcher(), ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EGenericParserStates> arrowAlternative = alternative.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.METHOD, "local function", INameResolver.firstMatchedTokenText());
        arrowAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        arrowAlternative.parseOnce(EGenericParserStates.IN_METHOD).endNode();
        alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "local function", INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    @Override
    public ITokenMatcher getIdentifierMatcher() {
        return VALID_IDENTIFIERS;
    }

    @Override
    protected ITokenMatcher getSimpleBlockKeywordsWithParentheses() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.SWITCH, ETokenType.LOCK, ETokenType.USING, ETokenType.FIXED, ETokenType.FOREACH});
    }

    @Override
    protected ITokenMatcher getSimpleBlockKeywordsWithoutParentheses() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.FINALLY, ETokenType.CHECKED, ETokenType.UNCHECKED, ETokenType.UNSAFE});
    }

    @Override
    public ITokenMatcher getStatementStartTokens() {
        return ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.RETURN, ETokenType.ASSERT, ETokenType.CONST, ETokenType.GOTO, ETokenType.BASE, ETokenType.THROW, ETokenType.THIS, ETokenType.CHECKED, ETokenType.SIZEOF, ETokenType.STACKALLOC, ETokenType.TYPEOF, ETokenType.VALUE, ETokenType.YIELD, ETokenType.LPAREN, ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.NOT, ETokenType.PLUS, ETokenType.MINUS, ETokenType.COMP, ETokenType.TRUE, ETokenType.FALSE, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.MULT, ETokenType.DEFAULT, ETokenType.LBRACK, ETokenType.FILE});
    }

    @Override
    public RecognizerBase<EGenericParserStates> typePattern(RecognizerBase<EGenericParserStates> currentState) {
        ITokenMatcher typeStart = PRIMITIVE_TYPES.or(new ITokenMatcher[]{this.getIdentifierMatcher()});
        RecognizerBase simpleTypeRecognizer = this.createRecognizer(start -> start.sequence(typeStart).repeated(new ITokenMatcher[]{ETokenType.DOT, typeStart}).skipNested(ETokenType.LT, ETokenType.GT).optionalSubRecognizer(this.createTypeSuffixRecognizer()));
        RecognizerBase tupleTypeRecognizer = this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).optionalSubRecognizer(this.createTypeSuffixRecognizer()));
        RecognizerBase typeRecognizer = this.createRecognizer(start -> start.subRecognizer(simpleTypeRecognizer));
        typeRecognizer.subRecognizer(tupleTypeRecognizer);
        return currentState.repeated(this.getTypeAndMemberModifiers()).subRecognizer(typeRecognizer);
    }

    @Override
    protected RecognizerBase<EGenericParserStates> getBlockRuleStart() {
        return super.getBlockRuleStart().optional(new ITokenMatcher[]{ETokenType.AWAIT}).markStart();
    }

    @Override
    protected void createSubExpressionRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION, EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DELEGATE, ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "anonymous method").skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "switch expression", INameResolver.ofRange(0, 0)).parseUntil(EGenericParserStates.IN_SWITCH_EXPRESSION).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_SWITCH_EXPRESSION}).preCondition(this.createRecognizer(start -> start.sequence(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}))).parseOnce(EGenericParserStates.IN_EXPRESSION).optional(new ITokenMatcher[]{ETokenType.COMMA});
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_SWITCH_EXPRESSION}).skipBefore(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.META, "case", INameResolver.ofRange(0, -1)).endNode();
        this.createLambdaWithArrowRules(ETokenType.DOUBLE_ARROW);
    }

    @Override
    public RecognizerBase<EGenericParserStates> getSubExpressionRecognizer() {
        return new CsSubExpressionRecognizer();
    }

    @Override
    protected boolean isFilteredToken(IToken token, IToken previousToken) {
        return super.isFilteredToken(token, previousToken) || CsShallowParser.isPragmaWarning(token);
    }

    private static boolean isPragmaWarning(IToken token) {
        return token.getType() == ETokenType.PREPROCESSOR_DIRECTIVE && token.getText().startsWith("#pragma warning");
    }
}

