/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.gosu;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.gosu.GosuSimpleStatementRecognizer;
import java.util.Arrays;
import java.util.List;

public class GosuShallowParser
extends ShallowParserBase<EGosuParserStates> {
    static final ITokenMatcher MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.INTERNAL, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.STATIC, ETokenType.ABSTRACT, ETokenType.OVERRIDE, ETokenType.FINAL, ETokenType.TRANSIENT});
    private static final ITokenMatcher MEMBER_TERMINATOR_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RBRACE, ETokenType.FUNCTION, ETokenType.PROPERTY, ETokenType.VAR, ETokenType.CLASS, ETokenType.INTERFACE, ETokenType.ENUM, ETokenType.ENHANCEMENT, ETokenType.STRUCTURE, ETokenType.CONSTRUCT, ETokenType.AT, ETokenType.PRIVATE, ETokenType.INTERNAL, ETokenType.PROTECTED, ETokenType.PUBLIC, ETokenType.STATIC, ETokenType.ABSTRACT, ETokenType.OVERRIDE, ETokenType.FINAL, ETokenType.TRANSIENT});
    private static final List<ETokenType> ALL_OPEN_PAREN = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LT, ETokenType.LBRACK);
    private static final List<ETokenType> ALL_CLOSE_PAREN = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.GT, ETokenType.RBRACK);
    private static final ITokenMatcher LITERALS_AND_IDENTIFIERS = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.IDENTIFIER});

    public GosuShallowParser() {
        super(EGosuParserStates.class, EGosuParserStates.TOP_LEVEL);
        this.createMetaRules();
        this.createModuleRules();
        this.createEnumRules();
        this.createTypeMemberWithBodyRules();
        this.createAbstractTypeMemberRules();
        this.createVariableRules();
        this.createSubExpressionRules();
        this.createGlobalFunctionRules();
        this.createStatementRules();
        this.createAnonymousBlockRule();
    }

    private void createAnonymousBlockRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createGlobalFunctionRules() {
        this.createFunctionRule("global function", EGosuParserStates.TOP_LEVEL);
    }

    private void createMetaRules() {
        this.inState(new EGosuParserStates[]{EGosuParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PACKAGE, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "package", INameResolver.ofRange(1, -1)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EGosuParserStates[]{EGosuParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.USES, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "uses", INameResolver.ofRange(1, -1)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createModuleRules() {
        this.inStateSkipModifiers(EGosuParserStates.TOP_LEVEL, EGosuParserStates.IN_TYPE).markStart().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CLASS, ETokenType.ENUM}), ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EGosuParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inStateSkipModifiers(EGosuParserStates.TOP_LEVEL, EGosuParserStates.IN_TYPE, EGosuParserStates.IN_INTERFACE).markStart().sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.INTERFACE, ETokenType.STRUCTURE}), ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EGosuParserStates.IN_INTERFACE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inStateSkipModifiers(EGosuParserStates.TOP_LEVEL).markStart().sequence(new ITokenMatcher[]{ETokenType.ENHANCEMENT, ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.secondMatchedTokenText()).parseUntil(EGosuParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private RecognizerBase<EGosuParserStates> inStateSkipModifiers(EGosuParserStates ... states) {
        return this.inState(states).repeated(MODIFIERS);
    }

    private void createVariableRules() {
        ITokenMatcher typeMemberTerminatorsAndEq = MEMBER_TERMINATOR_TOKENS.or(new ITokenMatcher[]{ETokenType.EQ});
        RecognizerBase<EGosuParserStates> varStart = this.inStateSkipModifiers(EGosuParserStates.IN_TYPE, EGosuParserStates.IN_INTERFACE).markStart().sequence(new ITokenMatcher[]{ETokenType.VAR, ETokenType.IDENTIFIER}).skipBeforeWithNesting(typeMemberTerminatorsAndEq, ALL_OPEN_PAREN, ALL_CLOSE_PAREN);
        varStart.sequence(new ITokenMatcher[]{ETokenType.EQ, ETokenType.LBRACE}).skipAfter(new ITokenMatcher[]{ETokenType.RBRACE}).createNode(EShallowEntityType.ATTRIBUTE, "field", INameResolver.secondMatchedTokenText()).endNode();
        varStart.sequence(new ITokenMatcher[]{ETokenType.EQ}).createNode(EShallowEntityType.ATTRIBUTE, "field", INameResolver.secondMatchedTokenText()).optionalSubRecognizer(this.createRecognizer(start -> start.parseOnce(EGosuParserStates.IN_EXPRESSION))).skipBeforeWithNesting(MEMBER_TERMINATOR_TOKENS, ALL_OPEN_PAREN, ALL_CLOSE_PAREN).endNode();
        varStart.sequenceBefore(MEMBER_TERMINATOR_TOKENS).createNode(EShallowEntityType.ATTRIBUTE, "field", INameResolver.secondMatchedTokenText()).endNode();
    }

    private void createAbstractTypeMemberRules() {
        this.interfaceMemberSkipBeforeNextMember(new ITokenMatcher[]{ETokenType.FUNCTION, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "function", INameResolver.secondMatchedTokenText()).endNode();
        this.interfaceMemberSkipBeforeNextMember(new ITokenMatcher[]{ETokenType.CONSTRUCT}).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText()).endNode();
        this.interfaceMemberSkipBeforeNextMember(new ITokenMatcher[]{ETokenType.PROPERTY, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "property", INameResolver.ofIndex(2)).endNode();
    }

    private RecognizerBase<EGosuParserStates> interfaceMemberSkipBeforeNextMember(ITokenMatcher ... memberMatchTerms) {
        return this.inStateSkipModifiers(EGosuParserStates.IN_INTERFACE, EGosuParserStates.IN_TYPE).markStart().sequence(memberMatchTerms).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).skipBeforeWithNesting(MEMBER_TERMINATOR_TOKENS, ALL_OPEN_PAREN, ALL_CLOSE_PAREN);
    }

    private void createTypeMemberWithBodyRules() {
        this.createFunctionRule("function", EGosuParserStates.IN_TYPE);
        GosuShallowParser.skipToTypeMemberBody(this.inStateSkipModifiers(EGosuParserStates.IN_TYPE).markStart().sequence(new ITokenMatcher[]{ETokenType.CONSTRUCT}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN)).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText()).parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        GosuShallowParser.skipToTypeMemberBody(this.inStateSkipModifiers(EGosuParserStates.IN_TYPE).markStart().sequence(new ITokenMatcher[]{ETokenType.PROPERTY}).sequence(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GET, ETokenType.SET}), ETokenType.IDENTIFIER})).createNode(EShallowEntityType.METHOD, "property", INameResolver.secondMatchedTokenText()).parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createFunctionRule(String subtype, EGosuParserStates ... states) {
        GosuShallowParser.skipToTypeMemberBody(this.inStateSkipModifiers(states).markStart().sequence(new ITokenMatcher[]{ETokenType.FUNCTION, ETokenType.IDENTIFIER}).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN)).createNode(EShallowEntityType.METHOD, subtype, INameResolver.secondMatchedTokenText()).parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEnumRules() {
        RecognizerBase enumLiteral = this.inState(new EGosuParserStates[]{EGosuParserStates.IN_TYPE}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA, ETokenType.LBRACE, ETokenType.RBRACE})).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText());
        enumLiteral.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGosuParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).endNode();
        enumLiteral.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).endNode();
        RecognizerBase constructorOrEnum = this.inState(new EGosuParserStates[]{EGosuParserStates.IN_TYPE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED})).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        constructorOrEnum.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).endNode();
        constructorOrEnum.skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AT_OPERATOR, ETokenType.PUBLIC, ETokenType.PRIVATE, ETokenType.PROTECTED})).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).parseUntil(EGosuParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA})).endNode();
    }

    private static RecognizerBase<EGosuParserStates> skipToTypeMemberBody(RecognizerBase<EGosuParserStates> recognizerBase) {
        return recognizerBase.skipBefore(MEMBER_TERMINATOR_TOKENS.or(new ITokenMatcher[]{ETokenType.LBRACE})).sequence(new ITokenMatcher[]{ETokenType.LBRACE});
    }

    private void createStatementRules() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
        this.createElseIfRule();
        this.createSimpleBlockRules();
        this.createSwitchCaseRules();
        RecognizerBase varStatementRecognizer = this.createRecognizer(start -> start.repeated(MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.VAR, ETokenType.IDENTIFIER}));
        this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD, EGosuParserStates.IN_TYPE}).preCondition(varStatementRecognizer).subRecognizer(new GosuSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "local variable"), 1, 1).endNode();
        this.inState(new EGosuParserStates[]{EGosuParserStates.TOP_LEVEL}).preCondition(varStatementRecognizer).subRecognizer(new GosuSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "global variable"), 1, 1).endNode();
        this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD, EGosuParserStates.TOP_LEVEL, EGosuParserStates.IN_TYPE}).sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).subRecognizer(new GosuSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "simple statement"), 1, 1).endNode();
        this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD, EGosuParserStates.TOP_LEVEL, EGosuParserStates.IN_TYPE}).sequenceBefore(ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.KEYWORD})).subRecognizer(new GosuSimpleStatementRecognizer(EShallowEntityType.STATEMENT, "simple statement"), 1, 1).endNode();
    }

    private void createElseIfRule() {
        RecognizerBase<EGosuParserStates> elseIfAlternative = this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD, EGosuParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).createNode(EShallowEntityType.STATEMENT, "else if").skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        this.endWithPossibleContinuation(elseIfAlternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), (ITokenMatcher)ETokenType.ELSE);
        this.endWithPossibleContinuation(elseIfAlternative.parseOnce(EGosuParserStates.IN_METHOD), (ITokenMatcher)ETokenType.ELSE);
    }

    private void createSimpleBlockRules() {
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR, ETokenType.SWITCH, ETokenType.WITH}), null, true);
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.FINALLY}), null, false);
        this.createBlockRuleWithContinuation((ITokenMatcher)ETokenType.IF, (ITokenMatcher)ETokenType.ELSE, true);
        this.createBlockRuleWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.CATCH}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.FINALLY}), true);
    }

    private void createSwitchCaseRules() {
        this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE, LITERALS_AND_IDENTIFIERS, ETokenType.COLON}).createNode(EShallowEntityType.META, "case", INameResolver.secondMatchedTokenText()).endNode();
        this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE}).skipAfterWithNesting((ITokenMatcher)ETokenType.COLON, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EGosuParserStates[]{EGosuParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT, ETokenType.COLON}).createNode(EShallowEntityType.META, "default", INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createBlockRuleWithContinuation(ITokenMatcher startTokens, ITokenMatcher continuationTokens, boolean canBeFollowedByParentheses) {
        RecognizerBase<Object> alternative = this.inAnyState().sequence(startTokens).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        if (canBeFollowedByParentheses) {
            alternative = alternative.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, this.getSubExpressionRecognizer());
        }
        this.endWithPossibleContinuation(alternative.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}), continuationTokens);
        this.endWithPossibleContinuation(alternative.parseOnce((Object)EGosuParserStates.IN_METHOD), continuationTokens);
    }

    private void createSubExpressionRules() {
        RecognizerBase<EGosuParserStates> lambdaStart = this.inState(new EGosuParserStates[]{EGosuParserStates.IN_EXPRESSION, EGosuParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.BACKSLASH}).skipAfter(new ITokenMatcher[]{ETokenType.ARROW}).createNode(EShallowEntityType.METHOD, "lambda");
        lambdaStart.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGosuParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        lambdaStart.parseOnce(EGosuParserStates.IN_METHOD).endNode();
    }

    private RecognizerBase<EGosuParserStates> getSubExpressionRecognizer() {
        return this.createRecognizer(start -> start.sequenceBefore(new ITokenMatcher[]{ETokenType.BACKSLASH}).parseOnce(EGosuParserStates.IN_EXPRESSION));
    }

    public static enum EGosuParserStates {
        TOP_LEVEL,
        IN_TYPE,
        IN_INTERFACE,
        IN_METHOD,
        IN_EXPRESSION;

    }
}

