/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.plsql;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import java.util.Set;

public class PlsqlShallowParser
extends ShallowParserBase<EPlsqlParserStates> {
    private static final ITokenMatcher PLSQL_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.A, ETokenType.ADD, ETokenType.AGENT, ETokenType.AGGREGATE, ETokenType.ARRAY, ETokenType.ATTRIBUTE, ETokenType.AUTHID, ETokenType.AVG, ETokenType.BFILE_BASE, ETokenType.BINARY, ETokenType.BLOB_BASE, ETokenType.BLOCK, ETokenType.BODY, ETokenType.BOTH, ETokenType.BOUND, ETokenType.BULK, ETokenType.BYTE, ETokenType.C, ETokenType.CALL, ETokenType.CALLING, ETokenType.CASCADE, ETokenType.CHAR, ETokenType.CHARACTER, ETokenType.CHARSET, ETokenType.CHARSETFORM, ETokenType.CHARSETID, ETokenType.CHAR_BASE, ETokenType.CLEAR, ETokenType.ACCESSIBLE, ETokenType.CLONE, ETokenType.CREDENTIAL, ETokenType.CLOB_BASE, ETokenType.CLOSE, ETokenType.COLLECT, ETokenType.COMMENT, ETokenType.COMMIT, ETokenType.COMMITTED, ETokenType.COMPILED, ETokenType.CONSTANT, ETokenType.CONSTRUCTOR, ETokenType.CONTEXT, ETokenType.CONTINUE, ETokenType.CONVERT, ETokenType.COUNT, ETokenType.CURSOR, ETokenType.CUSTOMDATUM, ETokenType.DANGLING, ETokenType.DATA, ETokenType.DATE, ETokenType.DATE_BASE, ETokenType.DAY, ETokenType.DEFINE, ETokenType.DETERMINISTIC, ETokenType.DIRECTORY, ETokenType.DOUBLE, ETokenType.DURATION, ETokenType.ELEMENT, ETokenType.ELSIF, ETokenType.EMPTY, ETokenType.ESCAPE, ETokenType.EXCEPT, ETokenType.EXCEPTIONS, ETokenType.EXIT, ETokenType.EXTERNAL, ETokenType.FINAL, ETokenType.FIRST, ETokenType.FIXED, ETokenType.FLOAT, ETokenType.FORALL, ETokenType.FORCE, ETokenType.FUNCTION, ETokenType.GENERAL, ETokenType.HASH, ETokenType.HEAP, ETokenType.HIDDEN, ETokenType.HOUR, ETokenType.IDENTIFIER, ETokenType.IMMEDIATE, ETokenType.IMMUTABLE, ETokenType.INCLUDING, ETokenType.INDICATOR, ETokenType.INDICES, ETokenType.INFINITE, ETokenType.INSTANTIABLE, ETokenType.INT, ETokenType.INTERFACE, ETokenType.INTERVAL, ETokenType.INVALIDATE, ETokenType.ISOLATION, ETokenType.JAVA, ETokenType.LANGUAGE, ETokenType.LARGE, ETokenType.LEADING, ETokenType.LENGTH, ETokenType.LEVEL, ETokenType.LIBRARY, ETokenType.LIKE2, ETokenType.LIKE4, ETokenType.LIKEC, ETokenType.LIMIT, ETokenType.LIMITED, ETokenType.LOCAL, ETokenType.LONG, ETokenType.LOOP, ETokenType.MAP, ETokenType.MAX, ETokenType.MAXLEN, ETokenType.MEMBER, ETokenType.MERGE, ETokenType.MIN, ETokenType.MINUTE, ETokenType.MOD, ETokenType.MODIFY, ETokenType.MONTH, ETokenType.MULTISET, ETokenType.MUTABLE, ETokenType.NAME, ETokenType.NAN, ETokenType.NATIONAL, ETokenType.NATIVE, ETokenType.NCHAR, ETokenType.NEW, ETokenType.NOCOPY, ETokenType.NUMBER_BASE, ETokenType.OBJECT, ETokenType.OCICOLL, ETokenType.OCIDATETIME, ETokenType.OCIDATE, ETokenType.OCIDURATION, ETokenType.OCIINTERVAL, ETokenType.OCILOBLOCATOR, ETokenType.OCINUMBER, ETokenType.OCIRAW, ETokenType.OCIREF, ETokenType.OCIREFCURSOR, ETokenType.OCIROWID, ETokenType.OCISTRING, ETokenType.OCITYPE, ETokenType.OLD, ETokenType.ONLY, ETokenType.OPAQUE, ETokenType.OPEN, ETokenType.OPERATOR, ETokenType.ORACLE, ETokenType.ORADATA, ETokenType.ORGANIZATION, ETokenType.ORLANY, ETokenType.ORLVARY, ETokenType.OTHERS, ETokenType.OUT, ETokenType.OVERRIDING, ETokenType.PACKAGE, ETokenType.PARALLEL_ENABLE, ETokenType.PARAMETER, ETokenType.PARAMETERS, ETokenType.PARENT, ETokenType.PERSISTABLE, ETokenType.PLUGGABLE, ETokenType.PARTITION, ETokenType.PASCAL, ETokenType.PIPE, ETokenType.PIPELINED, ETokenType.PRAGMA, ETokenType.POLYMORPHIC, ETokenType.PRECISION, ETokenType.PRIVATE, ETokenType.RAISE, ETokenType.RANGE, ETokenType.RAW, ETokenType.READ, ETokenType.RECORD, ETokenType.REF, ETokenType.REFERENCE, ETokenType.RELIES_ON, ETokenType.REMAINDER, ETokenType.RENAME, ETokenType.REPLACE, ETokenType.RESULT, ETokenType.RESULT_CACHE, ETokenType.RETURN, ETokenType.RETURNING, ETokenType.REVERSE, ETokenType.ROLLBACK, ETokenType.ROW, ETokenType.RUN, ETokenType.SAMPLE, ETokenType.SAVE, ETokenType.SAVEPOINT, ETokenType.SB1, ETokenType.SB2, ETokenType.SB4, ETokenType.SECOND, ETokenType.SEGMENT, ETokenType.SELF, ETokenType.SEPARATE, ETokenType.SEQUENCE, ETokenType.SERIALIZABLE, ETokenType.SET, ETokenType.SHORT, ETokenType.SIZE_T, ETokenType.SKIP, ETokenType.SOME, ETokenType.SPARSE, ETokenType.SQLCODE, ETokenType.SQLDATA, ETokenType.SQLNAME, ETokenType.SQLSTATE, ETokenType.STANDARD, ETokenType.STATIC, ETokenType.STDDEV, ETokenType.STORED, ETokenType.STRING, ETokenType.STRUCT, ETokenType.STYLE, ETokenType.SUBMULTISET, ETokenType.SUBPARTITION, ETokenType.SUBSTITUTABLE, ETokenType.SUBTYPE, ETokenType.SUM, ETokenType.SYNONYM, ETokenType.TDO, ETokenType.THE, ETokenType.TIME, ETokenType.TIMESTAMP, ETokenType.TIMEZONE_ABBR, ETokenType.TIMEZONE_HOUR, ETokenType.TIMEZONE_MINUTE, ETokenType.TIMEZONE_REGION, ETokenType.TRAILING, ETokenType.TRANSACTION, ETokenType.TRANSACTIONAL, ETokenType.TRUSTED, ETokenType.TYPE, ETokenType.UB1, ETokenType.UB2, ETokenType.UB4, ETokenType.UNDER, ETokenType.UNSIGNED, ETokenType.UNPLUG, ETokenType.UNTRUSTED, ETokenType.USE, ETokenType.USING, ETokenType.VALIST, ETokenType.VALUE, ETokenType.VAR, ETokenType.VARIABLE, ETokenType.VARIANCE, ETokenType.VARRAY, ETokenType.VARYING, ETokenType.VOID, ETokenType.WHILE, ETokenType.WORK, ETokenType.WRAPPED, ETokenType.WRITE, ETokenType.YEAR, ETokenType.ZONE, ETokenType.DELETE, ETokenType.ON, ETokenType.OFF});

    public PlsqlShallowParser() {
        super(EPlsqlParserStates.class, EPlsqlParserStates.DECLARATIONS);
        this.createIfsPreprocessorRules(EPlsqlParserStates.DECLARATIONS);
        this.createIfsPreprocessorRules(EPlsqlParserStates.STATEMENTS);
        this.createMetaRules();
        this.createPackageAndTypeRules();
        this.createMethodAndAttributeRules();
        this.createStatementRules();
    }

    private void createIfsPreprocessorRules(EPlsqlParserStates state) {
        RecognizerBase<EPlsqlParserStates> ifAlternative = this.inState(new EPlsqlParserStates[]{state}).sequence(new ITokenMatcher[]{ETokenType.IFS_IF}).createNode(EShallowEntityType.META, "preprocessor condition", INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.IFS_THEN}).parseUntil(state).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IFS_ELSE, ETokenType.IFS_END}));
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.IFS_END}).endNode();
        ifAlternative.endNodeWithContinuation();
        this.inState(new EPlsqlParserStates[]{state}).sequence(new ITokenMatcher[]{ETokenType.IFS_ELSE}).createNode(EShallowEntityType.META, "preprocessor condition", INameResolver.previousTokenText()).parseUntil(state).sequence(new ITokenMatcher[]{ETokenType.IFS_END}).endNode();
        this.inState(new EPlsqlParserStates[]{state}).sequence(new ITokenMatcher[]{ETokenType.IFS_PREPEND}).createNode(EShallowEntityType.META, "ifs search block", INameResolver.previousTokenText()).parseStrictlyUntil(state).sequenceBefore(new ITokenMatcher[]{ETokenType.IFS_SEARCH}).endNodeWithContinuation();
        RecognizerBase searchAlternative = this.inState(new EPlsqlParserStates[]{state}).sequence(new ITokenMatcher[]{ETokenType.IFS_SEARCH}).createNode(EShallowEntityType.META, "ifs search block", INameResolver.previousTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IFS_END, ETokenType.IFS_APPEND, ETokenType.IFS_REPLACE}), ETokenType.IFS_IF, ETokenType.IFS_END);
        searchAlternative.sequence(new ITokenMatcher[]{ETokenType.IFS_END}).endNode();
        searchAlternative.endNodeWithContinuation();
        this.inState(new EPlsqlParserStates[]{state}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IFS_APPEND, ETokenType.IFS_REPLACE})).createNode(EShallowEntityType.META, "ifs search block", INameResolver.previousTokenText()).parseStrictlyUntil(state).skipAfterWithNesting((ITokenMatcher)ETokenType.IFS_END, ETokenType.IFS_IF, ETokenType.IFS_END).endNode();
        this.inState(new EPlsqlParserStates[]{state}).sequence(new ITokenMatcher[]{ETokenType.IFS_TEXTPREPEND}).createNode(EShallowEntityType.META, "ifs search block", INameResolver.previousTokenText()).parseStrictlyUntil(state).sequenceBefore(new ITokenMatcher[]{ETokenType.IFS_TEXTSEARCH}).endNodeWithContinuation();
        RecognizerBase textsearchAlternative = this.inState(new EPlsqlParserStates[]{state}).sequence(new ITokenMatcher[]{ETokenType.IFS_TEXTSEARCH}).createNode(EShallowEntityType.META, "ifs search block", INameResolver.previousTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IFS_TEXTEND, ETokenType.IFS_TEXTAPPEND, ETokenType.IFS_TEXTREPLACE}));
        textsearchAlternative.sequence(new ITokenMatcher[]{ETokenType.IFS_TEXTEND}).endNode();
        textsearchAlternative.endNodeWithContinuation();
        this.inState(new EPlsqlParserStates[]{state}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IFS_TEXTAPPEND, ETokenType.IFS_TEXTREPLACE})).createNode(EShallowEntityType.META, "ifs search block", INameResolver.previousTokenText()).parseStrictlyUntil(state).sequence(new ITokenMatcher[]{ETokenType.IFS_TEXTEND}).endNode();
    }

    private void createMetaRules() {
        this.createShowErrorsRules();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.EXIT}).optional(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "exit").endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.BREAK}).optional(new ITokenMatcher[]{ETokenType.ON, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "break").endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.SKIP}).optional(new ITokenMatcher[]{ETokenType.EQUAL}).sequence(new ITokenMatcher[]{ETokenType.INTEGER_LITERAL}).optional(new ITokenMatcher[]{ETokenType.ON, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "skip").endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.PRAGMA}).createNode(EShallowEntityType.META, "pragma").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.EXCEPTION}).createNode(EShallowEntityType.META, "exception section").endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.OVERRIDE}).createNode(EShallowEntityType.META, INameResolver.previousTokenText()).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.OVERTAKE}).createNode(EShallowEntityType.META, "@overtake", INameResolver.previousTokenText()).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.ANNOTATION}).createNode(EShallowEntityType.META, "annotation", INameResolver.previousTokenText()).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.AT}).optional(new ITokenMatcher[]{ETokenType.AT}).createNode(EShallowEntityType.META, "run script").repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.MINUS, ETokenType.MOD, ETokenType.DIV, ETokenType.SQL})).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.ECHO}).createNode(EShallowEntityType.META, "echo").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.REMOVE}).createNode(EShallowEntityType.META, "remove").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase sqlBasic = this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.AGGREGATE, ETokenType.ALTER, ETokenType.COMMIT, ETokenType.DELETE, ETokenType.GRANT, ETokenType.INSERT, ETokenType.LOCK, ETokenType.ROLLBACK, ETokenType.SAVEPOINT, ETokenType.SELECT, ETokenType.DROP, ETokenType.MERGE, ETokenType.UPDATE, ETokenType.WITH})).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText());
        sqlBasic.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        sqlBasic.skipAfter(new ITokenMatcher[]{ETokenType.DIV}).endNode();
        RecognizerBase sqlCreate = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.CREATE, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.INDEX, ETokenType.UNIQUE})}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText());
        sqlCreate.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        sqlCreate.skipAfter(new ITokenMatcher[]{ETokenType.DIV}).endNode();
        RecognizerBase sqlSet = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SET, ETokenType.TRANSACTION}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText());
        sqlSet.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        sqlSet.skipAfter(new ITokenMatcher[]{ETokenType.DIV}).endNode();
        RecognizerBase sqlCreateOrReplace = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.CREATE}).optional(new ITokenMatcher[]{ETokenType.OR, ETokenType.REPLACE}).optional(new ITokenMatcher[]{ETokenType.PUBLIC}).sequence(new ITokenMatcher[]{ETokenType.SYNONYM}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText());
        sqlCreateOrReplace.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        sqlCreateOrReplace.skipAfter(new ITokenMatcher[]{ETokenType.DIV}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.COMMENT, ETokenType.ON}).createNode(EShallowEntityType.STATEMENT, "SQL", "comment on").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        ITokenMatcher setIdentifiers = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DEFINE});
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.SET, setIdentifiers, PLSQL_IDENTIFIERS}).createNode(EShallowEntityType.META, "set").repeated(setIdentifiers, PLSQL_IDENTIFIERS).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.END}).createNode(EShallowEntityType.META, "dangling end").skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON});
    }

    private void createShowErrorsRules() {
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.SHOW, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasPrefix((String)"err")})}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "show errors").endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasPrefix((String)"sho")}), ETokenType.ERRORS}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "show errors").endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.SHOW, ETokenType.ERRORS}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "show errors").endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasPrefix((String)"sho")}), ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasPrefix((String)"err")})).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "show errors").endNode();
    }

    private void createPackageAndTypeRules() {
        RecognizerBase<EPlsqlParserStates> optionalBeginAlternative = this.createOrReplace().sequence(new ITokenMatcher[]{ETokenType.PACKAGE}).optional(new ITokenMatcher[]{ETokenType.BODY}).markStart().repeated(new ITokenMatcher[]{PLSQL_IDENTIFIERS, ETokenType.DOT}).sequence(PLSQL_IDENTIFIERS).createNode(EShallowEntityType.MODULE, "package", INameResolver.ofRange(0, -1)).skipAfter(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.AS})).parseUntil(EPlsqlParserStates.DECLARATIONS);
        optionalBeginAlternative.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        optionalBeginAlternative.sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createOrReplace().sequence(new ITokenMatcher[]{ETokenType.TYPE, ETokenType.BODY}).markStart().repeated(new ITokenMatcher[]{PLSQL_IDENTIFIERS, ETokenType.DOT}).sequence(PLSQL_IDENTIFIERS).createNode(EShallowEntityType.MODULE, "type body", INameResolver.ofRange(0, -1)).skipAfter(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.AS})).parseUntil(EPlsqlParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EPlsqlParserStates> typeMatcher = this.createOrReplace().markStart().sequence(new ITokenMatcher[]{ETokenType.TYPE}).repeated(new ITokenMatcher[]{PLSQL_IDENTIFIERS, ETokenType.DOT}).sequence(PLSQL_IDENTIFIERS).createNode(EShallowEntityType.TYPE, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.AS, ETokenType.UNDER, ETokenType.SEMICOLON, ETokenType.DIV}));
        typeMatcher.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.DIV})).endNode();
        RecognizerBase<EPlsqlParserStates> typeMatcher2 = typeMatcher.skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.AS, ETokenType.UNDER})).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.AS}));
        typeMatcher2.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OBJECT, ETokenType.UNDER})).skipAfter(new ITokenMatcher[]{ETokenType.LPAREN}).parseUntil(EPlsqlParserStates.DECLARATIONS).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.NOT, ETokenType.FINAL, ETokenType.INSTANTIABLE})).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.DIV})).endNode();
        typeMatcher2.skipAfter(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.DIV})).endNode();
        this.createOrReplace().markStart().optional(new ITokenMatcher[]{ETokenType.AND, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.JAVA}).skipAfter(new ITokenMatcher[]{ETokenType.AS}).createNode(EShallowEntityType.TYPE, "java code").sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.METHOD, "top-level code").parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createMethodAndAttributeRules() {
        RecognizerBase<EPlsqlParserStates> methodStart = this.createOrReplace().repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MAP, ETokenType.NOT, ETokenType.OVERRIDING, ETokenType.ORDER, ETokenType.FINAL, ETokenType.INSTANTIABLE, ETokenType.MEMBER, ETokenType.STATIC, ETokenType.CONSTRUCTOR})).markStart().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PROCEDURE, ETokenType.FUNCTION})).repeated(PLSQL_IDENTIFIERS, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.DOUBLE_DOT})).sequence(PLSQL_IDENTIFIERS).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).optional(new ITokenMatcher[]{ETokenType.RETURN, ETokenType.SELF, ETokenType.AS, ETokenType.RESULT}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.IS, ETokenType.AS, ETokenType.RPAREN, ETokenType.COMMA}));
        methodStart.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RPAREN, ETokenType.COMMA})).endNode();
        RecognizerBase<EPlsqlParserStates> alternativeMethodStart = methodStart.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IS, ETokenType.AS}));
        alternativeMethodStart.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LANGUAGE, ETokenType.EXTERNAL})).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        alternativeMethodStart.parseUntil(EPlsqlParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RPAREN, ETokenType.COMMA}), ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        this.createOrReplace().markStart().sequence(new ITokenMatcher[]{ETokenType.VIEW, PLSQL_IDENTIFIERS}).optional(new ITokenMatcher[]{ETokenType.DOT, PLSQL_IDENTIFIERS}).sequence(new ITokenMatcher[]{ETokenType.AS}).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -2)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{PLSQL_IDENTIFIERS, ETokenType.EXCEPTION, ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "exception declaration", INameResolver.firstMatchedTokenText()).endNode();
        RecognizerBase<EPlsqlParserStates> triggerMatch = this.createOrReplace().markStart().sequence(new ITokenMatcher[]{ETokenType.TRIGGER}).repeated(new ITokenMatcher[]{PLSQL_IDENTIFIERS, ETokenType.DOT}).sequence(PLSQL_IDENTIFIERS).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.DECLARE, ETokenType.BEGIN, ETokenType.COMPOUND}));
        triggerMatch.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        triggerMatch.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        triggerMatch.sequence(new ITokenMatcher[]{ETokenType.DECLARE}).parseUntil(EPlsqlParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        triggerMatch.sequence(new ITokenMatcher[]{ETokenType.COMPOUND, ETokenType.TRIGGER}).parseUntil(EPlsqlParserStates.DECLARATIONS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BEFORE, ETokenType.AFTER})).repeatedSubRecognizer(this.createCompoundTriggerSegmentRecogniser()).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.CURSOR}).skipAfter(new ITokenMatcher[]{ETokenType.IS}).createNode(EShallowEntityType.ATTRIBUTE, "cursor", INameResolver.secondMatchedTokenText()).parseOnce(EPlsqlParserStates.STATEMENTS).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).optional(new ITokenMatcher[]{ETokenType.VAR}).markStart().sequence(PLSQL_IDENTIFIERS).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.firstMatchedTokenText()).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.RPAREN, ETokenType.COMMA}), ETokenType.LPAREN, ETokenType.RPAREN).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).sequence(new ITokenMatcher[]{ETokenType.COLUMN}).createNode(EShallowEntityType.ATTRIBUTE, "column").repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.NULL_LITERAL, ETokenType.NAME})).endNode();
    }

    private RecognizerBase<EPlsqlParserStates> createCompoundTriggerSegmentRecogniser() {
        return this.createRecognizer(start -> start.markStart().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BEFORE, ETokenType.AFTER})).skipAfter(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode());
    }

    private RecognizerBase<EPlsqlParserStates> createOrReplace() {
        return this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.DECLARATIONS}).optional(new ITokenMatcher[]{ETokenType.CREATE}).optional(new ITokenMatcher[]{ETokenType.OR, ETokenType.REPLACE}).optional(new ITokenMatcher[]{ETokenType.FORCE});
    }

    public static boolean isSystemObjectKeyword(String keyword) {
        return Set.of("sysobjects", "sysviews", "syscolumns", "sysindexes", "syspublications", "sysjars", "sysxtypes", "sysusers", "syslog", "sysconstraints").contains(keyword);
    }

    private void createStatementRules() {
        RecognizerBase<EPlsqlParserStates> ifAlternative = this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.THEN, ETokenType.CASE, ETokenType.END).parseUntil(EPlsqlParserStates.STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSIF, ETokenType.ELSE, ETokenType.END}));
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.IF, ETokenType.SEMICOLON}).endNode();
        ifAlternative.endNodeWithContinuation();
        RecognizerBase<EPlsqlParserStates> elseMatcher = this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EPlsqlParserStates.STATEMENTS);
        elseMatcher.sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.IF}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        elseMatcher.sequenceBefore(new ITokenMatcher[]{ETokenType.END, ETokenType.CASE}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LOOP}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.LOOP}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHILE, ETokenType.FOR})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LOOP}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.LOOP}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE}).createNode(EShallowEntityType.STATEMENT, "block").parseUntil(EPlsqlParserStates.DECLARATIONS).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "block").parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.WHEN, ETokenType.ELSE})).parseUntil(EPlsqlParserStates.STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.CASE}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).createNode(EShallowEntityType.META, "when", INameResolver.secondMatchedTokenText()).endNode();
        this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.LEFT_LABEL_BRACKET, PLSQL_IDENTIFIERS, ETokenType.RIGHT_LABEL_BRACKET}).createNode(EShallowEntityType.META, "label", INameResolver.secondMatchedTokenText()).endNode();
        ITokenMatcher basicStatementStarts = PLSQL_IDENTIFIERS.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SELF, ETokenType.RETURN, ETokenType.GOTO, ETokenType.FETCH, ETokenType.NULL_LITERAL, ETokenType.SPOOL})});
        RecognizerBase statementMatcher = this.inState(new EPlsqlParserStates[]{EPlsqlParserStates.STATEMENTS}).sequence(basicStatementStarts).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON});
        statementMatcher.endNode();
        RecognizerBase execStart = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.EXECUTE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText());
        execStart.subRecognizer(statementMatcher).endNode();
        execStart.sequence(new ITokenMatcher[0]).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.DOUBLE_DOT})).optionalSubRecognizer(this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN})).endNode();
    }

    public static enum EPlsqlParserStates {
        DECLARATIONS,
        STATEMENTS;

    }
}

