/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.clike;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorBase;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CLikeTypeInfoExtractorBase
extends TypeInfoExtractorBase {
    protected final CLikeLanguageFeatureParserBase featureParser;

    public CLikeTypeInfoExtractorBase(CLikeLanguageFeatureParserBase languageUtils) {
        CCSMAssert.isNotNull((Object)languageUtils);
        this.featureParser = languageUtils;
    }

    @Override
    public List<TypedVariable> extractFromAttribute(ShallowEntity attributeEntity) {
        String subtype = attributeEntity.getSubtype();
        if (subtype.equals("attribute") || subtype.equals("global variable") || subtype.equals("property")) {
            return this.extractFromVariableTokens(attributeEntity, (List<IToken>)attributeEntity.ownStartTokens());
        }
        return super.extractFromAttribute(attributeEntity);
    }

    @Override
    public List<TypedVariable> extractFromMethod(ShallowEntity methodEntity) {
        List<List<IToken>> splitParameterTokens = this.featureParser.getSplitParameterTokens(methodEntity);
        ArrayList<TypedVariable> typeInfo = new ArrayList<TypedVariable>();
        for (List<IToken> parameter : splitParameterTokens) {
            List<IToken> parameterWithoutAnnotations = this.featureParser.removeParameterAnnotationTokens(parameter);
            Pair<List<IToken>, String> modifiersAndType = this.featureParser.getModifiersAndTypeFromTokens(parameterWithoutAnnotations);
            List<String> genericTypeParameters = this.featureParser.getGenericTypeNames(parameter);
            String genericTypeParameterRepresentation = null;
            if (!CollectionUtils.isNullOrEmpty(genericTypeParameters)) {
                genericTypeParameterRepresentation = StringUtils.concat(genericTypeParameters, (String)",");
            }
            String typeName = (String)modifiersAndType.getSecond();
            List modifiers = (List)modifiersAndType.getFirst();
            IToken variableName = this.featureParser.getVariableNameFromTokens(parameterWithoutAnnotations);
            if (variableName == null) continue;
            typeInfo.add(new TypedVariable(variableName.getText(), typeName, modifiers, methodEntity, genericTypeParameterRepresentation));
        }
        return typeInfo;
    }

    protected List<TypedVariable> extractFromForLikeTokens(ShallowEntity entity, ETokenType endToken) {
        List<IToken> variableTokens = CLikeLanguageFeatureParserBase.getVariableTokensFromForLikeTokens((List<IToken>)entity.ownStartTokens(), endToken);
        return this.extractFromVariableTokens(entity, variableTokens);
    }

    protected List<TypedVariable> extractFromVariableTokens(ShallowEntity entity, List<IToken> variableTokens) {
        List<List<IToken>> splitTokens = this.featureParser.splitVariableTokens(variableTokens);
        CCSMAssert.isFalse((boolean)splitTokens.isEmpty(), (String)"splitTokens must have at least one element");
        List<IToken> firstTokens = splitTokens.get(0);
        if (!this.featureParser.isVariableDeclaration(firstTokens)) {
            return CollectionUtils.emptyList();
        }
        List modifiers = (List)this.featureParser.getModifiersAndTypeFromTokens(firstTokens).getFirst();
        ArrayList<TypedVariable> typeInfo = new ArrayList<TypedVariable>();
        for (int i = 0; i < splitTokens.size(); ++i) {
            List<IToken> tokensWithBaseTypeInformation;
            List<IToken> tokens = splitTokens.get(i);
            List<IToken> baseTypeTokens = this.featureParser.getBaseTypeTokens(firstTokens);
            if (i == 0) {
                tokensWithBaseTypeInformation = tokens;
            } else {
                tokensWithBaseTypeInformation = new ArrayList<IToken>();
                tokensWithBaseTypeInformation.addAll(baseTypeTokens);
                tokensWithBaseTypeInformation.addAll(tokens);
            }
            Pair<List<IToken>, String> modifiersAndType = this.featureParser.getModifiersAndTypeFromTokens(tokensWithBaseTypeInformation);
            String typeName = (String)modifiersAndType.getSecond();
            IToken variableName = this.featureParser.getVariableNameFromTokens(tokens);
            if (variableName == null) continue;
            typeInfo.add(new TypedVariable(variableName.getText(), typeName, modifiers, entity));
        }
        return typeInfo;
    }

    protected List<TypedVariable> extractFromCatchTokens(ShallowEntity entity) {
        List<IToken> exceptionTokens = TokenStreamUtils.tokensBetween((List<IToken>)entity.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN);
        ArrayList<TypedVariable> typeInfo = new ArrayList<TypedVariable>();
        if (exceptionTokens.size() <= 1) {
            return typeInfo;
        }
        Pair<List<IToken>, String> modifiersAndType = this.featureParser.getModifiersAndTypeFromTokens(exceptionTokens);
        String typeName = (String)modifiersAndType.getSecond();
        List modifiers = (List)modifiersAndType.getFirst();
        IToken variableName = this.featureParser.getVariableNameFromTokens(exceptionTokens);
        if (variableName != null) {
            typeInfo.add(new TypedVariable(variableName.getText(), typeName, modifiers, entity));
        }
        return typeInfo;
    }

    protected List<TypedVariable> extractFromForConstructWithPossibleColon(ShallowEntity statementEntity) {
        ETokenType endToken = ETokenType.SEMICOLON;
        if (CLikeTypeInfoExtractorBase.hasTopLevelColon(statementEntity)) {
            endToken = ETokenType.COLON;
        }
        return this.extractFromForLikeTokens(statementEntity, endToken);
    }

    private static boolean hasTopLevelColon(ShallowEntity statementEntity) {
        return TokenStreamUtils.findFirstTopLevel((List<IToken>)statementEntity.ownStartTokens(), (ITokenMatcher)ETokenType.COLON, Arrays.asList(ETokenType.LBRACE), Arrays.asList(ETokenType.RBRACE)) != -1;
    }
}

