/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallFinder;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;

public class JavaMethodCallMatcher {
    private final Set<String> fullTypeNames = new HashSet<String>();
    private final Set<String> targetMethodNames = new HashSet<String>();
    private final Set<String> knownMethodReturningSameType = new HashSet<String>();
    private boolean findConstructors;
    private boolean alsoAddGetInstanceCalls;
    private @Nullable Integer minParameters;
    private @Nullable Integer maxParameters;
    private @Nullable Object tag = null;
    private boolean allowChaining;
    private final List<Predicate<List<List<IToken>>>> parameterPredicates = new ArrayList<Predicate<List<List<IToken>>>>();

    private JavaMethodCallMatcher() {
    }

    public static JavaMethodCallMatcher create() {
        return new JavaMethodCallMatcher();
    }

    public JavaMethodCallMatcher onTypes(Set<String> fullTypeNames) {
        this.fullTypeNames.addAll(fullTypeNames);
        return this;
    }

    public JavaMethodCallMatcher onTypes(String ... fullTypeNames) {
        this.fullTypeNames.addAll(Arrays.asList(fullTypeNames));
        return this;
    }

    public JavaMethodCallMatcher withTargetMethodNames(Set<String> targetMethodNames) {
        this.targetMethodNames.addAll(targetMethodNames);
        return this;
    }

    public JavaMethodCallMatcher withTargetMethodNames(String ... targetMethodNames) {
        return this.withTargetMethodNames(CollectionUtils.asHashSet((Object[])targetMethodNames));
    }

    public JavaMethodCallMatcher constructors(boolean alsoLookForGetInstanceCalls) {
        this.findConstructors = true;
        this.alsoAddGetInstanceCalls = alsoLookForGetInstanceCalls;
        return this;
    }

    public JavaMethodCallMatcher withKnownMethodReturningSameType(String ... knownMethodReturningSameType) {
        return this.withKnownMethodReturningSameType(CollectionUtils.asHashSet((Object[])knownMethodReturningSameType));
    }

    public JavaMethodCallMatcher withKnownMethodReturningSameType(Set<String> knownMethodReturningSameType) {
        this.knownMethodReturningSameType.addAll(knownMethodReturningSameType);
        return this;
    }

    public JavaMethodCallMatcher withParameterCount(int parameterCount) {
        return this.withParameterCount(parameterCount, parameterCount);
    }

    public JavaMethodCallMatcher withParameterCount(@Nullable Integer minParameters, @Nullable Integer maxParameters) {
        this.minParameters = minParameters;
        this.maxParameters = maxParameters;
        return this;
    }

    public JavaMethodCallMatcher withTag(@Nullable Object tag) {
        this.tag = tag;
        return this;
    }

    public JavaMethodCallMatcher allowChaining(boolean allow) {
        this.allowChaining = allow;
        return this;
    }

    public boolean allowChaining() {
        return this.allowChaining;
    }

    public List<MethodCall> find(ICheckContext checkContext, JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        return this.find(checkContext.getRootEntity(ECodeViewOption.FILTERED), checkContext.getTypeResolution(ECodeViewOption.FILTERED), typeResolver);
    }

    public List<MethodCall> find(ShallowEntity root, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        ArrayList<MethodCall> result = new ArrayList<MethodCall>();
        if (!this.targetMethodNames.isEmpty()) {
            result.addAll(JavaMethodCallFinder.findCallsOnType(root, typeResolver, typeResolution, this));
        }
        if (this.findConstructors) {
            result.addAll(JavaMethodCallFinder.findConstructorCalls(root, typeResolver, this));
        }
        return result;
    }

    public JavaMethodCallMatcher withParameters(Predicate<List<List<IToken>>> parameterPredicate) {
        this.parameterPredicates.add(parameterPredicate);
        return this;
    }

    public Set<String> getKnownMethodReturningSameType() {
        return CollectionUtils.asUnmodifiable(this.knownMethodReturningSameType);
    }

    public Set<String> getTargetMethodNames() {
        return CollectionUtils.asUnmodifiable(this.targetMethodNames);
    }

    public @Nullable Integer getMinParameters() {
        return this.minParameters;
    }

    public @Nullable Integer getMaxParameters() {
        return this.maxParameters;
    }

    public List<Predicate<List<List<IToken>>>> getParameterPredicates() {
        return CollectionUtils.asUnmodifiable(this.parameterPredicates);
    }

    public @Nullable Object getTag() {
        return this.tag;
    }

    public Set<String> getFullTypeNames() {
        return CollectionUtils.asUnmodifiable(this.fullTypeNames);
    }

    public boolean alsoAddGetInstanceCalls() {
        return this.alsoAddGetInstanceCalls;
    }

    public record ChainedCall(String methodName, IToken callToken, List<IToken> parameters) {
    }

    public record MethodCall(ShallowEntity statement, IToken token, List<List<IToken>> parameters, @Nullable Object tag) {
        private static final int TOKEN_BEFORE_CHAIN_GROUP = 0;
        private static final int TOKEN_AFTER_CHAIN_GROUP = 1;
        private static final TokenPattern CHAINED_CALL_PATTERN = new TokenPattern().beginningOfStream().sequence(ETokenType.RPAREN).group(0).repeated(new TokenPattern().sequence(ETokenType.DOT, ETokenType.IDENTIFIER).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false)).alternative(new TokenPattern().endOfStream(), new TokenPattern().sequence(ETokenType.SEMICOLON)).group(1);

        public String methodName() {
            return this.token.getText();
        }

        public List<ChainedCall> findChainedCalls() {
            IToken startTokenExclusive = this.parameters().getLast().getLast();
            List<IToken> tokensAfterCall = this.statement().includedTokens().stream().filter(token -> token.getOffset() > startTokenExclusive.getOffset()).toList();
            ArrayList<ChainedCall> chainedCalls = new ArrayList<ChainedCall>();
            CHAINED_CALL_PATTERN.findNonOverlappingMatches(tokensAfterCall).forEach(match -> {
                List<IToken> allChainTokens = match.tokensBetweenGroupsExclusive(0, 1);
                List<List> methods = TokenStreamUtils.splitWithNesting(allChainTokens, ETokenType.DOT, ETokenType.LPAREN, ETokenType.RPAREN).stream().filter(tokens -> !tokens.isEmpty()).toList();
                for (List method : methods) {
                    IToken callToken = (IToken)method.getFirst();
                    List<IToken> parameterTokens = LanguageFeatureParser.JAVA.extractParameterTokens(method);
                    chainedCalls.add(new ChainedCall(callToken.getText(), callToken, parameterTokens));
                }
            });
            return chainedCalls;
        }
    }
}

