/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class CppCheckUtils {
    public static final Map<String, Set<String>> ALLOWED_SPECIALIZATIONS_BY_NAMESPACE = new HashMap<String, Set<String>>();
    public static final Set<String> HEADER_EXTENSIONS;

    public static boolean isHeaderFile(String uniformPath) {
        String extension = FileSystemUtils.getFileExtension((File)new File(uniformPath));
        return extension != null && HEADER_EXTENSIONS.contains(extension.toLowerCase());
    }

    public static TextRegionLocation extractSignatureLocationFrom(String uniformPath, ShallowEntity methodDeclaration) {
        UnmodifiableList declarationTokens = methodDeclaration.ownStartTokens();
        int endOffset = ((IToken)declarationTokens.get(declarationTokens.size() - 1)).getOffset();
        int endLine = ((IToken)declarationTokens.get(declarationTokens.size() - 1)).getLineNumber() + 1;
        return new TextRegionLocation(uniformPath, methodDeclaration.getStartOffset(), endOffset, methodDeclaration.getStartLine(), endLine);
    }

    static {
        ALLOWED_SPECIALIZATIONS_BY_NAMESPACE.put("std", CollectionUtils.asHashSet((Object[])new String[]{"hash", "complex", "numeric_limits", "common_type", "basic_common_reference", "atomic", "shared_ptr", "weak_ptr", "istreambuf_iterator"}));
        HEADER_EXTENSIONS = CollectionUtils.asHashSet((Object[])new String[]{"h", "hh", "hpp", "hxx", "H"});
    }
}

