/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp.alignment;

import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.cpp.BinarySizeCheckUtils;
import eu.cqse.check.framework.util.cpp.alignment.ContainerTypeDataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.TypeEntityAlignmentInfoExtractor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class StructAlignmentInfoExtractor
extends TypeEntityAlignmentInfoExtractor {
    private static StructAlignmentInfoExtractor singletonInstance;

    private StructAlignmentInfoExtractor() {
    }

    @Override
    public final boolean isApplicable(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && "struct".equals(entity.getSubtype());
    }

    @Override
    protected final ContainerTypeDataAlignmentInfo extractFromType(ShallowEntity struct, List<DataAlignmentInfo> members, int alignment, boolean hasPackedAttribute, boolean hasAlignmentImposedByAttribute) {
        int padding = StructAlignmentInfoExtractor.calculatePadding(members, alignment, hasPackedAttribute, hasAlignmentImposedByAttribute);
        int size = members.isEmpty() ? 1 : StructAlignmentInfoExtractor.sumSize(members) + padding;
        return StructAlignmentInfoExtractor.createInfo(struct, size, alignment, members, padding, hasPackedAttribute, hasAlignmentImposedByAttribute);
    }

    public static int calculateMinimalSize(ContainerTypeDataAlignmentInfo structAlignmentInfo) {
        ArrayList<DataAlignmentInfo> sortedMembers = new ArrayList<DataAlignmentInfo>(structAlignmentInfo.getMembers());
        sortedMembers.sort(Comparator.comparing(DataAlignmentInfo::getAlignment, Comparator.reverseOrder()));
        int paddingWithOptimalOrder = StructAlignmentInfoExtractor.calculatePadding(sortedMembers, structAlignmentInfo.getAlignment(), structAlignmentInfo.isPackedAttributeSet(), structAlignmentInfo.isAlignmentImposedByAttribute());
        return structAlignmentInfo.getSize() - (structAlignmentInfo.getPadding() - paddingWithOptimalOrder);
    }

    private static int calculatePadding(List<DataAlignmentInfo> members, int alignment, boolean hasPackedAttribute, boolean hasAlignmentImposedByAttribute) {
        if (hasPackedAttribute) {
            if (hasAlignmentImposedByAttribute) {
                return BinarySizeCheckUtils.calculatePadding(StructAlignmentInfoExtractor.sumSize(members), alignment);
            }
            return 0;
        }
        int offset = 0;
        int paddingInBetweenMembers = 0;
        for (DataAlignmentInfo member : members) {
            if (!member.hasKnownAlignment()) continue;
            int requiredPadding = BinarySizeCheckUtils.calculatePadding(offset, member.getAlignment());
            paddingInBetweenMembers += requiredPadding;
            offset += requiredPadding + member.getSize();
        }
        int requiredEndPadding = 0;
        if (members.stream().anyMatch(DataAlignmentInfo::hasKnownAlignment)) {
            requiredEndPadding = BinarySizeCheckUtils.calculatePadding(offset, alignment);
        }
        return paddingInBetweenMembers + requiredEndPadding;
    }

    private static int sumSize(List<DataAlignmentInfo> members) {
        return members.stream().mapToInt(DataAlignmentInfo::getSize).sum();
    }

    public static StructAlignmentInfoExtractor getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new StructAlignmentInfoExtractor();
        }
        return singletonInstance;
    }
}

