/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.AlternativePattern;
import eu.cqse.check.framework.util.tokens.NotFollowedByPattern;
import eu.cqse.check.framework.util.tokens.NotPrecededByPattern;
import eu.cqse.check.framework.util.tokens.OptionalPattern;
import eu.cqse.check.framework.util.tokens.RegexPattern;
import eu.cqse.check.framework.util.tokens.RepeatedPattern;
import eu.cqse.check.framework.util.tokens.SequencePattern;
import eu.cqse.check.framework.util.tokens.SingleTokenPatternBase;
import eu.cqse.check.framework.util.tokens.SkipNestedPattern;
import eu.cqse.check.framework.util.tokens.SkipPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternBase;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import eu.cqse.check.framework.util.tokens.ZeroLengthTokenPatternBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TokenPattern {
    public static final TokenPattern NEVER_MATCHING_PATTERN = new TokenPattern(){

        @Override
        protected TokenPatternMatch matchesLocally(TokenStream stream) {
            return null;
        }
    };
    private final List<TokenPatternBase> submatchers = new ArrayList<TokenPatternBase>();

    public String toString() {
        return "submatchers " + String.valueOf(this.submatchers);
    }

    public List<TokenPatternMatch> findAll(List<IToken> tokens) {
        ArrayList<TokenPatternMatch> matches = new ArrayList<TokenPatternMatch>();
        TokenStream stream = new TokenStream(tokens, 0);
        for (int i = 0; i < tokens.size(); ++i) {
            stream.setPosition(i);
            TokenPatternMatch match = this.matchesLocally(stream);
            if (match == null) continue;
            matches.add(match);
        }
        return matches;
    }

    public @Nullable TokenPatternMatch findFirstMatch(List<IToken> tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            TokenStream stream = new TokenStream(tokens, i);
            TokenPatternMatch match = this.matchesLocally(stream);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public List<TokenPatternMatch> findNonOverlappingMatches(List<IToken> tokens) {
        ArrayList<TokenPatternMatch> matches = new ArrayList<TokenPatternMatch>();
        TokenStream stream = new TokenStream(tokens, 0);
        int i = 0;
        while (i < tokens.size()) {
            TokenPatternMatch match = this.matchesLocally(stream);
            if (match == null) {
                stream.setPosition(++i);
                continue;
            }
            matches.add(match);
            i = stream.getPosition();
            if (!stream.isExhausted()) continue;
            break;
        }
        return matches;
    }

    public @Nullable TokenPatternMatch matchAtStartOf(List<IToken> tokens) {
        TokenStream stream = new TokenStream(tokens, 0);
        return this.matchesLocally(stream);
    }

    public @Nullable TokenPatternMatch matchFully(List<IToken> tokens) {
        TokenStream stream = new TokenStream(tokens, 0);
        TokenPatternMatch result = this.matchesLocally(stream);
        if (!stream.isExhausted()) {
            return null;
        }
        return result;
    }

    public @Nullable TokenPatternMatch matchAtCurrentPosition(TokenStream stream) {
        int position = stream.getPosition();
        TokenPatternMatch match = this.matchesLocally(stream);
        stream.setPosition(position);
        return match;
    }

    public boolean matchesAnywhere(List<IToken> tokens) {
        return this.findFirstMatch(tokens) != null;
    }

    protected @Nullable TokenPatternMatch matchesLocally(TokenStream stream) {
        return new SequencePattern((TokenPatternBase[])CollectionUtils.toArray(this.submatchers, TokenPatternBase.class)).matchesLocally(stream);
    }

    public TokenPattern group(int groupIndex) {
        CCSMAssert.isFalse((boolean)this.submatchers.isEmpty(), (String)"You must specify a pattern part before you can assign a group to it.");
        this.submatchers.getLast().setGroupIndex(groupIndex);
        return this;
    }

    public TokenPattern skipTo(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        this.submatchers.add(new SkipPattern(matchers, true));
        this.submatchers.add(new AlternativePattern(matchers));
        return this;
    }

    public TokenPattern skipUntil(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        this.submatchers.add(new SkipPattern(matchers, false));
        return this;
    }

    public TokenPattern skipNested(Object openTerm, Object closeTerm, boolean optional) {
        TokenPatternBase openMatcher = TokenPattern.convertMatchTerm(openTerm);
        TokenPatternBase closeMatcher = TokenPattern.convertMatchTerm(closeTerm);
        this.submatchers.add(new SkipNestedPattern(openMatcher, closeMatcher, optional));
        return this;
    }

    public TokenPattern repeated(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        this.submatchers.add(new RepeatedPattern(matchers));
        return this;
    }

    public TokenPattern sequence(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        this.submatchers.add(new SequencePattern(matchers));
        return this;
    }

    public TokenPattern endOfStream() {
        this.submatchers.add(new ZeroLengthTokenPatternBase(this){

            @Override
            public boolean conditionApplies(TokenStream stream) {
                return stream.isExhausted();
            }

            public String toString() {
                return "ZeroLength is exhausted";
            }
        });
        return this;
    }

    public TokenPattern beginningOfStream() {
        this.submatchers.add(new ZeroLengthTokenPatternBase(this){

            @Override
            public boolean conditionApplies(TokenStream stream) {
                return stream.isAtBeginning();
            }

            public String toString() {
                return "ZeroLength at beginning";
            }
        });
        return this;
    }

    public TokenPattern notAtBeginningOfStream() {
        this.submatchers.add(new ZeroLengthTokenPatternBase(this){

            @Override
            public boolean conditionApplies(TokenStream stream) {
                return !stream.isAtBeginning();
            }

            public String toString() {
                return "ZeroLength not at beginning";
            }
        });
        return this;
    }

    public TokenPattern notFollowedBy(Object matchTerm) {
        TokenPatternBase matcher = TokenPattern.convertMatchTerm(matchTerm);
        this.submatchers.add(new NotFollowedByPattern(matcher));
        return this;
    }

    public TokenPattern notPrecededBy(Object matchTerm) {
        TokenPatternBase matcher = TokenPattern.convertMatchTerm(matchTerm);
        this.submatchers.add(new NotPrecededByPattern(matcher));
        return this;
    }

    public TokenPattern alternative(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        this.submatchers.add(new AlternativePattern(matchers));
        return this;
    }

    public TokenPattern optional(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        this.submatchers.add(new OptionalPattern(matchers));
        return this;
    }

    public TokenPattern regex(String regex) {
        this.submatchers.add(new RegexPattern(regex));
        return this;
    }

    public TokenPattern anyToken() {
        this.submatchers.add(new SingleTokenPatternBase(this){

            @Override
            public boolean matchesToken(IToken token) {
                return true;
            }
        });
        return this;
    }

    public TokenPattern tokenText(String text) {
        this.submatchers.add(TokenPattern.text(text));
        return this;
    }

    private static TokenPatternBase[] convertMatchTerms(Object[] matchTerms) {
        CCSMAssert.isFalse((matchTerms.length == 0 ? 1 : 0) != 0, (String)"You must provide at least one match term.");
        TokenPatternBase[] matchers = new TokenPatternBase[matchTerms.length];
        for (int i = 0; i < matchTerms.length; ++i) {
            matchers[i] = TokenPattern.convertMatchTerm(matchTerms[i]);
        }
        return matchers;
    }

    private static TokenPatternBase convertMatchTerm(final TokenPattern matchTerm) {
        return new TokenPatternBase(){

            @Override
            protected TokenPatternMatch matchesLocally(TokenStream stream) {
                int beforePosition = stream.getPosition();
                TokenPatternMatch match = matchTerm.matchesLocally(stream);
                if (match == null) {
                    stream.setPosition(beforePosition);
                    return null;
                }
                return match;
            }

            public String toString() {
                return matchTerm.toString();
            }
        };
    }

    private static TokenPatternBase convertMatchTerm(final Set<?> matchTerm) {
        return new SingleTokenPatternBase(){

            @Override
            public boolean matchesToken(IToken token) {
                ETokenType type = token.getType();
                return matchTerm.contains(type) || matchTerm.contains(type.getTokenClass());
            }

            public String toString() {
                return matchTerm.toString();
            }
        };
    }

    private static TokenPatternBase convertMatchTerm(final ITokenMatcher matcher) {
        return new SingleTokenPatternBase(){

            @Override
            public boolean matchesToken(IToken token) {
                return matcher.matches(token);
            }

            public String toString() {
                return matcher.toString();
            }
        };
    }

    private static TokenPatternBase convertMatchTerm(Object matchTerm) {
        if (matchTerm instanceof TokenPatternBase) {
            return (TokenPatternBase)matchTerm;
        }
        if (matchTerm instanceof TokenPattern) {
            return TokenPattern.convertMatchTerm((TokenPattern)matchTerm);
        }
        if (matchTerm instanceof ITokenMatcher) {
            ITokenMatcher matcher = (ITokenMatcher)matchTerm;
            return TokenPattern.convertMatchTerm(matcher);
        }
        if (matchTerm instanceof Set) {
            return TokenPattern.convertMatchTerm((Set)matchTerm);
        }
        throw new AssertionError((Object)("Unsupported match term of type " + String.valueOf(matchTerm.getClass())));
    }

    public TokenPattern repeatedAtLeastOnce(Object ... matchTerms) {
        TokenPatternBase[] matchers = TokenPattern.convertMatchTerms(matchTerms);
        TokenPatternBase[] repeatedAtLeastOncePattern = new TokenPatternBase[]{new SequencePattern(matchers), new RepeatedPattern(matchers)};
        this.submatchers.add(new SequencePattern(repeatedAtLeastOncePattern));
        return this;
    }

    public static TokenPatternBase text(final String tokenText) {
        return new SingleTokenPatternBase(){

            @Override
            public boolean matchesToken(IToken token) {
                return tokenText.equals(token.getText());
            }

            public String toString() {
                return tokenText;
            }
        };
    }
}

