/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionParser;
import eu.cqse.check.matlab.MatlabActionParserException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkCheckUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    @VisibleForTesting
    public static SimulinkModel parseModelFromByteArrayWithoutRelatedModels(String uniformPath, byte[] binaryContent) throws IOException, SimulinkModelBuildingException {
        return SimulinkUtils.parseModelFromByteArray((byte[])binaryContent, (String)uniformPath, otherUniformPath -> null);
    }

    public static Optional<MatlabActionAstNode> parseMatlabTokens(List<IToken> tokens, QualifiedNameLocation location) {
        try {
            return Optional.ofNullable(MatlabActionParser.parse(tokens));
        }
        catch (MatlabActionParserException e) {
            LOGGER.error("Could not parse tokens to generate MatlabActionAstNode for " + location.toLocationString() + ": " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }
}

