/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

@Check(id="cqse-empty-abap-catch-block", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, defaultEnablement=EFindingEnablement.RED)
public class EmptyAbapCatchBlockCheck
extends CheckImplementationBase {
    @CheckOption(name="Assume catch block with only comments is empty", description="If enabled, this check generates findings for catch blocks that contain only comments. The default comment `handle exception` is always ignored.")
    private boolean treatCommentsAsEmptyBlock = false;
    public static final String CHECK_ID = "cqse-empty-abap-catch-block";
    public static final String DEFAULT_IDE_COMMENT = "\"handle exception";

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List catchEntities = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)entities, Set.of(EShallowEntityType.STATEMENT), Set.of("catch"));
        for (ShallowEntity catchEntity : catchEntities) {
            this.processEntity(catchEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (entity.hasChildren()) {
            return;
        }
        if (!this.treatCommentsAsEmptyBlock && this.containsNonDefaultComments(entity)) {
            return;
        }
        this.buildFinding("Empty `CATCH` block", this.buildLocation().forEntity(entity)).createAndStore();
    }

    private boolean containsNonDefaultComments(ShallowEntity entity) throws CheckException {
        List allTokens = this.context.getTokens(this.getCodeViewOption());
        int indexAfterFirstDot = TokenStreamUtils.firstTokenMatching((List)allTokens, (int)TokenStreamUtils.indexOfByOffset((List)allTokens, (int)entity.getStartOffset()), (ITokenMatcher)ETokenType.DOT) + 1;
        int parsedTokenEndIndex = entity.getEndTokenIndex();
        if (TokenStreamUtils.endsWith((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.ENDTRY, ETokenType.DOT})) {
            parsedTokenEndIndex -= 2;
        }
        int indexAfterCatchBlock = TokenStreamUtils.indexOfByOffset((List)allTokens, (int)((IToken)entity.getAllTokensOfFile().get(parsedTokenEndIndex)).getOffset());
        if (indexAfterFirstDot == -1 || indexAfterCatchBlock == -1) {
            LogManager.getLogger().error("Could not determine whether shallow entity contains comments in " + this.context.getUniformPath() + " entity " + entity.getName() + " at line " + entity.getStartLine());
            return true;
        }
        return !this.isEmptyOrDefaultComment(allTokens.subList(indexAfterFirstDot, indexAfterCatchBlock));
    }

    private boolean isEmptyOrDefaultComment(List<IToken> tokens) {
        return tokens.isEmpty() || tokens.size() == 1 && this.isDefaultComment(tokens.get(0));
    }

    private boolean isDefaultComment(IToken token) {
        return token.getType() == ETokenType.END_OF_LINE_COMMENT && token.getText().equals(DEFAULT_IDE_COMMENT);
    }
}

