/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.MissingCheckOfSySubrcCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-missing-check-of-sy-subrc-after-authority-check", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingCheckOfSySubrcAfterAuthorityCheckCheck
extends MissingCheckOfSySubrcCheckBase {
    private static final String FUNCTION_AUTHORITY_CHECK = "AUTHORITY_CHECK";
    private static final String AUTHORITY_CHECK = "authority-check";

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!statement.getSubtype().equals(AUTHORITY_CHECK) && !"call".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    @Override
    protected boolean isEntityToCheck(ShallowEntity entity) throws CheckException {
        return entity.getSubtype().equals(AUTHORITY_CHECK) || AbapCheckUtils.isFunctionCallOfAny((ShallowEntity)entity, (String[])new String[]{"AUTHORITY_CHECK_TCODE", FUNCTION_AUTHORITY_CHECK});
    }

    @Override
    protected String getFindingsMessage(ShallowEntity entity) {
        if (entity.getSubtype().equals("call")) {
            return "Improper authorization: Missing check of `SY-SUBRC` after `CALL FUNCTION` 'AUTHORITY_CHECK_TCODE'";
        }
        return "Improper authorization: Missing check of `SY-SUBRC` after `AUTHORITY-CHECK`";
    }
}

