/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.markup.MarkupUtils;

public abstract class UnusedImportsCheckBase
extends CheckImplementationBase {
    public void execute() throws CheckException {
        ListMap importsBySimpleNames = new ListMap();
        ListMap importsByFullNames = new ListMap();
        ListMap duplicates = new ListMap();
        this.context.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren().stream().filter(entity -> entity.getType() == EShallowEntityType.META && this.isImportStatement((ShallowEntity)entity)).forEach(entity -> this.recordImport((ShallowEntity)entity, (ListMap<String, ShallowEntity>)importsBySimpleNames, (ListMap<String, ShallowEntity>)importsByFullNames, (ListMap<String, ShallowEntity>)duplicates));
        this.context.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren().stream().filter(entity -> entity.getType() != EShallowEntityType.META || !this.isImportStatement((ShallowEntity)entity)).forEach(entity -> this.processEntity((ShallowEntity)entity, (ListMap<String, ShallowEntity>)importsBySimpleNames));
        this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED).stream().filter(token -> token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT).forEach(token -> this.processComment((IToken)token, (ListMap<String, ShallowEntity>)importsBySimpleNames));
        this.createFindings((ListMap<String, ShallowEntity>)importsBySimpleNames, (ListMap<String, ShallowEntity>)duplicates);
    }

    protected abstract void processEntity(ShallowEntity var1, ListMap<String, ShallowEntity> var2);

    protected abstract boolean isImportStatement(ShallowEntity var1);

    private void recordImport(ShallowEntity entity, ListMap<String, ShallowEntity> importsBySimpleNames, ListMap<String, ShallowEntity> importsByFullNames, ListMap<String, ShallowEntity> duplicates) {
        String unqualifiedTypeName = this.getSimpleNameFromImport(entity);
        String fullTypeName = this.getFullyQualifiedNameFromImport(entity);
        if (unqualifiedTypeName != null) {
            if (!importsByFullNames.getKeys().contains((Object)fullTypeName)) {
                importsBySimpleNames.add((Object)unqualifiedTypeName, (Object)entity);
                importsByFullNames.add((Object)fullTypeName, (Object)entity);
            } else {
                duplicates.add((Object)unqualifiedTypeName, (Object)entity);
            }
        }
    }

    protected abstract void processComment(IToken var1, ListMap<String, ShallowEntity> var2);

    protected void useType(String typeName, ListMap<String, ShallowEntity> imports) {
        imports.removeCollection((Object)typeName);
    }

    private void createFindings(ListMap<String, ShallowEntity> imports, ListMap<String, ShallowEntity> duplicates) throws CheckException {
        this.createFindings(imports, "Unused");
        this.createFindings(duplicates, "Duplicated");
    }

    private void createFindings(ListMap<String, ShallowEntity> map, String description) throws CheckException {
        for (String typeName : map.getKeys()) {
            for (ShallowEntity entity : (List)map.getCollection((Object)typeName)) {
                this.buildFinding(description + " import: " + MarkupUtils.formatAsSourceCode((String)this.getFullyQualifiedNameFromImport(entity)), this.buildLocation().forEntity(entity)).createAndStore();
            }
        }
    }

    protected abstract String getSimpleNameFromImport(ShallowEntity var1);

    protected abstract String getFullyQualifiedNameFromImport(ShallowEntity var1);
}

