/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-creating-simple-date-format-without-locale", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidCreatingSimpleDateFormatWithoutLocaleCheck
extends CheckImplementationBase {
    public static final String CHECK_NAME = "Avoid creating SimpleDateFormat objects without specifying the Locale";
    private static final String SIMPLE_DATE_FORMAT_FULL_CLASS_NAME = "java.text.SimpleDateFormat";
    private static final String SIMPLE_DATE_FORMAT_SIMPLE_CLASS_NAME = "SimpleDateFormat";
    private static final String LOCALE_FULL_CLASS_NAME = "java.util.Locale";
    private static final String FINDING_MESSAGE = "`SimpleDateFormat` constructor should specify `Locale`";
    private JavaImportSensitiveTypeResolver typeResolver;

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        if (!this.typeResolver.isImported(SIMPLE_DATE_FORMAT_FULL_CLASS_NAME)) {
            return;
        }
        List entitiesInType = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.TYPE), type -> true, EnumSet.of(EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT));
        for (ShallowEntity entityInType : entitiesInType) {
            if (entityInType.getType() != EShallowEntityType.STATEMENT && (entityInType.getType() != EShallowEntityType.ATTRIBUTE || Objects.requireNonNull(entityInType.getParent()).getType() != EShallowEntityType.TYPE)) continue;
            this.processEntity(entityInType);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        this.processPlainConstructors((List<IToken>)tokens, entity);
        this.processLambdaLikeConstructor((List<IToken>)tokens);
    }

    private void processPlainConstructors(List<IToken> tokens, ShallowEntity containingEntity) throws CheckException {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.LPAREN});
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IToken classNameToken = tokens.get(index + 1);
            if (!classNameToken.getText().equals(SIMPLE_DATE_FORMAT_SIMPLE_CLASS_NAME)) continue;
            List<IToken> constructorCallInitTokens = tokens.subList(index, tokens.size());
            this.checkIsSimpleDateFormatConstructorCallWithoutLocale(constructorCallInitTokens, containingEntity);
        }
    }

    private void processLambdaLikeConstructor(List<IToken> tokens) throws CheckException {
        List indices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOUBLE_COLON, ETokenType.NEW});
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            IToken classNameToken = tokens.get(index);
            if (!classNameToken.getText().equals(SIMPLE_DATE_FORMAT_SIMPLE_CLASS_NAME)) continue;
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forTokens(tokens)).createAndStore();
        }
    }

    private void checkIsSimpleDateFormatConstructorCallWithoutLocale(List<IToken> constructorCallInitTokens, ShallowEntity containingEntity) throws CheckException {
        List<IToken> parameterListTokens = constructorCallInitTokens.subList(3, constructorCallInitTokens.size() - 1);
        Pair parameterTokensListAndCallEnd = TokenStreamUtils.splitWithNestingHalting(parameterListTokens, (ETokenType)ETokenType.COMMA, List.of(ETokenType.LPAREN, ETokenType.LBRACE), List.of(ETokenType.RPAREN, ETokenType.RBRACE));
        List<IToken> constructorCallTokens = constructorCallInitTokens.subList(0, 3 + (Integer)parameterTokensListAndCallEnd.getSecond() + 1 + 1);
        if (((List)parameterTokensListAndCallEnd.getFirst()).size() != 2) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forTokens(constructorCallTokens)).createAndStore();
            return;
        }
        ScopedTypeLookup lookup = this.context.getTypeResolution(this.getCodeViewOption()).getTypeLookup(containingEntity);
        List secondParameterTokens = (List)((List)parameterTokensListAndCallEnd.getFirst()).get(1);
        Optional isOfType = this.typeResolver.isOfType(secondParameterTokens, Collections.singleton(LOCALE_FULL_CLASS_NAME), lookup);
        if (isOfType.isPresent() && !((Boolean)isOfType.get()).booleanValue()) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forTokens(constructorCallTokens)).createAndStore();
        }
    }
}

