/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-constructor-call-without-encoding", languages={ELanguage.JAVA}, parameters={ECheckParameter.TYPE_RESOLUTION, ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ConstructorCallWithoutEncodingCheck
extends CheckImplementationBase {
    public static final String CHECK_NAME = "Transformation of byte sequence into String must consider encoding";
    private static final ETokenType[] CONSTRUCTOR_CALL_SEQUENCE = new ETokenType[]{ETokenType.NEW, ETokenType.IDENTIFIER, ETokenType.LPAREN};
    private static final Set<String> IO_STREAM_CONSTRUCTOR_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"InputStreamReader", "OutputStreamWriter", "FileReader"});
    private static final Set<String> STRING_CONSTRUCTOR_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"String"});
    private static final Map<ETokenType, ETokenType> MATCHING_TOKEN_TYPES = new HashMap<ETokenType, ETokenType>();

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        this.processTokens(entity, (List<IToken>)entity.ownStartTokens());
        if (entity.hasChildren()) {
            this.processTokens(entity, (List<IToken>)entity.ownEndTokens());
        }
    }

    private void processTokens(ShallowEntity entity, List<IToken> tokens) throws CheckException {
        List callIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])CONSTRUCTOR_CALL_SEQUENCE);
        for (Integer callIndex : callIndices) {
            IToken constructorNameToken = tokens.get(callIndex + 1);
            String constructorName = constructorNameToken.getText();
            if (STRING_CONSTRUCTOR_NAMES.contains(constructorName)) {
                ScopedTypeLookup typeLookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
                this.stringCheck(typeLookup, constructorNameToken, ConstructorCallWithoutEncodingCheck.getConstructorArgumentTokens(tokens, callIndex));
                continue;
            }
            if (!IO_STREAM_CONSTRUCTOR_NAMES.contains(constructorName)) continue;
            this.ioStreamReaderWriterCheck(constructorNameToken, ConstructorCallWithoutEncodingCheck.getConstructorArgumentTokens(tokens, callIndex));
        }
    }

    private void stringCheck(ScopedTypeLookup tokenTypeLookup, IToken constructorNameToken, List<IToken> constructorArguments) {
        List<List<IToken>> parameters = ConstructorCallWithoutEncodingCheck.extractParameters(constructorArguments);
        int numberOfParameters = parameters.size();
        if (numberOfParameters == 0) {
            return;
        }
        if (ConstructorCallWithoutEncodingCheck.isParameterByteArray(tokenTypeLookup, parameters.getFirst())) {
            List<IToken> lastParameter;
            if (numberOfParameters == 1 || numberOfParameters == 3) {
                this.createFinding(constructorNameToken);
            } else if ((numberOfParameters == 2 || numberOfParameters == 4) && ConstructorCallWithoutEncodingCheck.parameterIsNotCharsetOrString(tokenTypeLookup, lastParameter = parameters.getLast())) {
                this.createFinding(constructorNameToken);
            }
        }
    }

    private void ioStreamReaderWriterCheck(IToken constructorNameToken, List<IToken> constructorArguments) {
        List<List<IToken>> parameters = ConstructorCallWithoutEncodingCheck.extractParameters(constructorArguments);
        int numberOfParameters = parameters.size();
        if (numberOfParameters == 1) {
            this.createFinding(constructorNameToken);
        }
    }

    private static boolean parameterIsNotCharsetOrString(ScopedTypeLookup tokenTypeLookup, List<IToken> parameterTokens) {
        if (parameterTokens.size() == 1) {
            IToken parameterToken = parameterTokens.getFirst();
            ETokenType parameterTokenType = parameterToken.getType();
            if (parameterTokenType == ETokenType.IDENTIFIER) {
                return ConstructorCallWithoutEncodingCheck.identifierTypeNotStringOrCharset(parameterToken, tokenTypeLookup);
            }
            return parameterTokenType != ETokenType.STRING_LITERAL;
        }
        if (TokenStreamUtils.endsWith(parameterTokens, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER})) {
            return ConstructorCallWithoutEncodingCheck.identifierTypeNotStringOrCharset(parameterTokens.getLast(), tokenTypeLookup);
        }
        return false;
    }

    private static boolean identifierTypeNotStringOrCharset(IToken identifier, ScopedTypeLookup tokenTypeLookup) {
        TypedVariable typeInfo = tokenTypeLookup.getTypeInfo(identifier.getText());
        if (typeInfo != null) {
            String typeName = typeInfo.getTypeNameWithoutGenericTypeParameter();
            return !typeName.equals("String") && !typeName.equals("Charset");
        }
        return false;
    }

    private static boolean isParameterByteArray(ScopedTypeLookup tokenTypeLookup, List<IToken> parameterTokens) {
        TypedVariable typeInfo;
        if (parameterTokens.size() == 1 && parameterTokens.getFirst().getType() == ETokenType.IDENTIFIER && (typeInfo = tokenTypeLookup.getTypeInfo(parameterTokens.getFirst().getText())) != null && typeInfo.getTypeNameWithoutGenericTypeParameter().equals("byte[]")) {
            return true;
        }
        if (parameterTokens.size() > 4) {
            int lastIndex = parameterTokens.size() - 1;
            if (ConstructorCallWithoutEncodingCheck.endsWithMethodCall(parameterTokens, lastIndex, "getBytes") || ConstructorCallWithoutEncodingCheck.endsWithMethodCall(parameterTokens, lastIndex, "toByteArray")) {
                return true;
            }
            if (parameterTokens.size() >= 6) {
                return ConstructorCallWithoutEncodingCheck.isCastToByteArray(parameterTokens) || ConstructorCallWithoutEncodingCheck.isByteArrayConstruction(parameterTokens) && parameterTokens.get(lastIndex).getType() == ETokenType.RBRACE;
            }
        }
        return false;
    }

    private static boolean endsWithMethodCall(List<IToken> parameterTokens, int lastIndex, String methodName) {
        return TokenStreamTextUtils.hasSequence(parameterTokens, (int)(lastIndex - 3), (String[])new String[]{".", methodName, "(", ")"});
    }

    private static boolean isByteArrayConstruction(List<IToken> parameterTokens) {
        return TokenStreamTextUtils.hasSequence(parameterTokens, (int)0, (String[])new String[]{"new", "byte", "[", "]", "{"});
    }

    private static boolean isCastToByteArray(List<IToken> parameterTokens) {
        return TokenStreamTextUtils.hasSequence(parameterTokens, (int)0, (String[])new String[]{"(", "byte", "[", "]", ")"});
    }

    private static List<IToken> getConstructorArgumentTokens(List<IToken> tokens, Integer callIndex) {
        return TokenStreamUtils.tokensBetweenWithNesting(tokens, (int)callIndex, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
    }

    private static List<List<IToken>> extractParameters(List<IToken> constructorArgumentTokens) {
        ArrayList<List<IToken>> parameters = new ArrayList<List<IToken>>();
        ArrayList<IToken> buffer = new ArrayList<IToken>();
        int i = 0;
        while (i < constructorArgumentTokens.size()) {
            IToken currentToken = constructorArgumentTokens.get(i);
            if (currentToken.getType() == ETokenType.LPAREN || currentToken.getType() == ETokenType.LBRACE) {
                buffer.add(currentToken);
                List tokensBetweenWithNesting = TokenStreamUtils.tokensBetweenWithNesting(constructorArgumentTokens, (int)i, (ETokenType)currentToken.getType(), (ETokenType)MATCHING_TOKEN_TYPES.get(currentToken.getType()));
                buffer.addAll(tokensBetweenWithNesting);
                i += tokensBetweenWithNesting.size() + 1;
                buffer.add(constructorArgumentTokens.get(i++));
                continue;
            }
            if (currentToken.getType() == ETokenType.COMMA) {
                parameters.add(buffer);
                buffer = new ArrayList();
                ++i;
                continue;
            }
            buffer.add(currentToken);
            ++i;
        }
        if (!buffer.isEmpty()) {
            parameters.add(buffer);
        }
        return parameters;
    }

    private void createFinding(IToken constructorNameToken) {
        this.buildFinding("Transformation of byte sequence into `String` uses platform encoding", this.buildLocation().forToken(constructorNameToken)).createAndStore();
    }

    static {
        MATCHING_TOKEN_TYPES.put(ETokenType.LPAREN, ETokenType.RPAREN);
        MATCHING_TOKEN_TYPES.put(ETokenType.LBRACE, ETokenType.RBRACE);
        MATCHING_TOKEN_TYPES.put(ETokenType.LBRACK, ETokenType.RBRACK);
    }
}

