/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Check(id="cqse-order-of-modifiers", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OrderOfModifiersCheck
extends CheckImplementationBase {
    private static final Map<String, Integer> MODIFIER_ORDER = Collections.unmodifiableMap(new HashMap<String, Integer>(){
        {
            this.put("public", 1);
            this.put("private", 1);
            this.put("protected", 1);
            this.put("abstract", 2);
            this.put("static", 3);
            this.put("default", 3);
            this.put("final", 4);
            this.put("transient", 5);
            this.put("volatile", 6);
            this.put("synchronized", 7);
            this.put("native", 8);
            this.put("strictfp", 9);
        }
    });

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        int previousPriority = 0;
        for (IToken token : entity.includedTokens()) {
            if (!MODIFIER_ORDER.containsKey(token.getText())) {
                return;
            }
            if (MODIFIER_ORDER.get(token.getText()) < previousPriority) {
                this.buildFinding("Modifiers of `" + entity.getName() + "` are in wrong order", this.buildLocation().forToken(token)).createAndStore();
                return;
            }
            previousPriority = MODIFIER_ORDER.get(token.getText());
        }
    }
}

