/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import com.google.common.collect.Iterables;
import eu.cqse.check.base.string_interpolation.FormatStrategy;
import eu.cqse.check.base.string_interpolation.JavaFormatStrategies;
import eu.cqse.check.base.string_interpolation.MethodCallFinding;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-string-interpolation", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class StringInterpolationCheck
extends CheckImplementationBase {
    private static final String LOG4J_LOGGER = "org.apache.logging.log4j.Logger";
    private static final String SL4J_LOGGER = "org.slf4j.Logger";
    private static final List<String> LOG_LEVELS = Arrays.asList("trace", "debug", "info", "warn", "error", "fatal");
    private static final Map<String, MethodFormatStrategies> METHOD_TO_FORMAT_STRATEGIES = new HashMap<String, MethodFormatStrategies>();
    private static final Set<FormatStrategy> ALL_INSTANCE_FORMAT_STRATEGIES;
    private static final Pattern BASIC_JAVA_TYPES;
    private JavaImportSensitiveTypeResolver typeResolver;

    public void execute() throws CheckException {
        this.typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            if (selectedEntity.getType() != EShallowEntityType.ATTRIBUTE && !"simple statement".equals(selectedEntity.getSubtype()) && !"local variable".equals(selectedEntity.getSubtype())) continue;
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.includedTokens();
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).iterator();
        while (iterator.hasNext()) {
            FormatStrategy.LastParameterType typeOfLastParameter;
            int callIndex = (Integer)iterator.next();
            Collection<FormatStrategy> possibleStrategies = this.getPossibleStrategies(entity, (List<IToken>)tokens, callIndex);
            if (possibleStrategies.isEmpty()) continue;
            Pair paramTokensListAndEnd = TokenStreamUtils.splitWithNestingHalting(tokens.subList(callIndex + 2, tokens.size()), (ETokenType)ETokenType.COMMA, List.of(ETokenType.LPAREN, ETokenType.LBRACE), List.of(ETokenType.RPAREN, ETokenType.RBRACE));
            int callEndIndex = callIndex + 2 + (Integer)paramTokensListAndEnd.getSecond() + 1;
            List<List<IToken>> normalizedParamList = StringInterpolationCheck.normalizeParamListIfApplicable((List)paramTokensListAndEnd.getFirst());
            if (normalizedParamList.isEmpty() || (typeOfLastParameter = StringInterpolationCheck.getTypeOfLastParameter(entity, normalizedParamList)) == FormatStrategy.LastParameterType.UNKNOWN && normalizedParamList.size() <= 2) continue;
            String formatString = StringEscapeUtils.unescapeJava((String)TokenStreamTextUtils.concatTokenTexts((List)CollectionUtils.filter((Collection)normalizedParamList.get(0), token -> token.getType() == ETokenType.STRING_LITERAL)));
            List<MethodCallFinding> leastMethodCallFindings = StringInterpolationCheck.getMethodCallFindings(possibleStrategies, formatString, normalizedParamList, typeOfLastParameter);
            for (MethodCallFinding methodCallFinding : leastMethodCallFindings) {
                this.reportMethodCallFinding(methodCallFinding, normalizedParamList, (List<IToken>)tokens, callIndex, callEndIndex);
            }
        }
    }

    private static @NonNull List<MethodCallFinding> getMethodCallFindings(Collection<FormatStrategy> possibleStrategies, String formatString, List<List<IToken>> normalizedParamList, FormatStrategy.LastParameterType typeOfLastParameter) throws CheckException {
        List leastMethodCallFindings = null;
        for (FormatStrategy formatType : possibleStrategies) {
            List methodCallFindings = formatType.handleCall(formatString, normalizedParamList, typeOfLastParameter);
            if (leastMethodCallFindings != null && methodCallFindings.size() >= leastMethodCallFindings.size()) continue;
            leastMethodCallFindings = methodCallFindings;
        }
        return CollectionUtils.emptyIfNull(leastMethodCallFindings);
    }

    private static FormatStrategy.LastParameterType getTypeOfLastParameter(ShallowEntity entity, List<List<IToken>> arguments) {
        if (arguments.size() <= 1) {
            return FormatStrategy.LastParameterType.NO_LAST_PARAMETER;
        }
        List<IToken> lastArgument = arguments.get(arguments.size() - 1);
        if (lastArgument.size() != 1) {
            return FormatStrategy.LastParameterType.UNKNOWN;
        }
        if (lastArgument.get(0).getType().getTokenClass() == ETokenType.ETokenClass.LITERAL) {
            return FormatStrategy.LastParameterType.BASIC_TYPE;
        }
        String lastArgumentText = lastArgument.get(0).getText();
        LocalVariableTypeResult result = StringInterpolationCheck.getLocalVariableType(entity, lastArgumentText);
        if (result != null) {
            if (BASIC_JAVA_TYPES.matcher(result.localVariableType).matches()) {
                return FormatStrategy.LastParameterType.BASIC_TYPE;
            }
            if (StringInterpolationCheck.exceptionFromLocalVariableWithThrownExceptionType(result)) {
                return FormatStrategy.LastParameterType.EXCEPTION;
            }
        }
        if (StringInterpolationCheck.exceptionFromCatchStatement(entity, lastArgumentText)) {
            return FormatStrategy.LastParameterType.EXCEPTION;
        }
        return FormatStrategy.LastParameterType.UNKNOWN;
    }

    private static boolean exceptionFromCatchStatement(ShallowEntity entity, String argument) {
        Optional<String> lastCatchParameter = StringInterpolationCheck.extractExceptionVariableFromSurroundingCatch(entity);
        return lastCatchParameter.filter(param -> param.equals(argument)).isPresent();
    }

    private static @Nullable LocalVariableTypeResult getLocalVariableType(ShallowEntity entity, String argument) {
        while (entity.getParent() != null && entity.getType() != EShallowEntityType.TYPE) {
            UnmodifiableList children = entity.getParent().getChildren();
            for (int i = children.indexOf(entity); i >= 0; --i) {
                ShallowEntity childBefore = (ShallowEntity)children.get(i);
                if (!StringInterpolationCheck.isLocalVariableWithName(childBefore, argument)) continue;
                String localVariableType = LanguageFeatureParser.JAVA.getVariableTypeFromTokens((List)childBefore.ownStartTokens());
                return new LocalVariableTypeResult(ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, potentialParent -> potentialParent.getType() == EShallowEntityType.METHOD).orElse(null), localVariableType);
            }
            entity = entity.getParent();
        }
        return null;
    }

    private static boolean exceptionFromLocalVariableWithThrownExceptionType(@NonNull LocalVariableTypeResult result) {
        if (result.surroundingMethod() == null) {
            return false;
        }
        Stream thrownExceptionTypes = LanguageFeatureParser.JAVA.getThrownTypesTokens(result.surroundingMethod()).stream().flatMap(throwTokenList -> throwTokenList.stream().map(IToken::getText));
        return thrownExceptionTypes.anyMatch(type -> type.equals(result.localVariableType()));
    }

    private static boolean isLocalVariableWithName(ShallowEntity entity, String name) {
        return (entity.getSubtype().equals("local variable") || entity.getSubtype().equals("attribute")) && LanguageFeatureParser.JAVA.isVariableDeclaration((List)entity.ownStartTokens()) && LanguageFeatureParser.JAVA.getVariableNameFromTokens((List)entity.ownStartTokens()).getText().equals(name);
    }

    private static Optional<String> extractExceptionVariableFromSurroundingCatch(ShallowEntity statement) {
        Optional catchEntity = ShallowEntityTraversalUtils.findParentEntityWithSubType((ShallowEntity)statement, (String)"catch");
        if (catchEntity.isEmpty()) {
            return Optional.empty();
        }
        statement = (ShallowEntity)catchEntity.get();
        UnmodifiableList tokens = statement.ownStartTokens();
        for (int i = tokens.size() - 1; i >= 0; --i) {
            if (((IToken)tokens.get(i)).getType() != ETokenType.IDENTIFIER) continue;
            return Optional.of(((IToken)tokens.get(i)).getText());
        }
        return Optional.empty();
    }

    private static List<List<IToken>> normalizeParamListIfApplicable(List<List<IToken>> paramList) {
        for (int skipped = 0; !paramList.isEmpty() && skipped <= 2; ++skipped) {
            if (paramList.get(0).size() == 1 && paramList.get(0).get(0).getType() == ETokenType.STRING_LITERAL && (skipped == 0 || JavaFormatStrategies.looksLikeAFormatString((String)paramList.get(0).get(0).getText()))) {
                return paramList;
            }
            paramList = paramList.subList(1, paramList.size());
        }
        return Collections.emptyList();
    }

    private void reportMethodCallFinding(MethodCallFinding methodCallFinding, List<List<IToken>> paramList, List<IToken> tokens, int callIndex, int callEndIndex) {
        if (methodCallFinding instanceof MethodCallFinding.WholeCallFinding) {
            MethodCallFinding.WholeCallFinding wholeCallFinding = (MethodCallFinding.WholeCallFinding)methodCallFinding;
            this.buildFinding(wholeCallFinding.findingMessage, this.buildLocation().betweenTokens(tokens.get(callIndex), tokens.get(callEndIndex), ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
        } else if (methodCallFinding instanceof MethodCallFinding.ParameterListIndexFinding) {
            MethodCallFinding.ParameterListIndexFinding parameterListIndexFinding = (MethodCallFinding.ParameterListIndexFinding)methodCallFinding;
            this.buildFinding(parameterListIndexFinding.findingMessage, this.buildLocation().betweenTokens(paramList.get(parameterListIndexFinding.index).get(0), (IToken)Iterables.getLast((Iterable)paramList.get(parameterListIndexFinding.index)), ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
        } else {
            CCSMAssert.fail((String)"Unhandled type of MethodCallFinding");
        }
    }

    private Collection<FormatStrategy> getPossibleStrategies(ShallowEntity entity, List<IToken> tokens, int callIndex) throws CheckException {
        Optional<Integer> qualifiedSequenceStart = StringInterpolationCheck.getQualifiedSequenceStart(tokens, callIndex);
        if (qualifiedSequenceStart.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        String methodName = tokens.get(callIndex).getText();
        MethodFormatStrategies classesAndTypesToStrategy = METHOD_TO_FORMAT_STRATEGIES.get(methodName);
        if (classesAndTypesToStrategy == null) {
            return CollectionUtils.emptyList();
        }
        List<IToken> possiblyQualifiedSequence = tokens.subList(qualifiedSequenceStart.get(), callIndex - 1);
        String possiblyQualifiedSequenceString = this.typeResolver.getFullyQualifiedTypeName(TokenStreamTextUtils.concatTokenTexts(possiblyQualifiedSequence));
        FormatStrategy formatType = classesAndTypesToStrategy.classToStaticMethodFormatStrategy().get(possiblyQualifiedSequenceString);
        if (formatType != null) {
            return List.of(formatType);
        }
        Optional identifierFullyQualifiedTypeNameOpt = this.typeResolver.getFullyQualifiedTypeOfIdentifier(possiblyQualifiedSequenceString, this.context.getTypeResolution(this.getCodeViewOption()).getTypeLookup(entity));
        Optional ret = identifierFullyQualifiedTypeNameOpt.flatMap(identifierFullyQualifiedTypeName -> Optional.ofNullable(classesAndTypesToStrategy.classToInstanceMethodFormatStrategy().get(identifierFullyQualifiedTypeName)));
        if (ret.isEmpty()) {
            return ALL_INSTANCE_FORMAT_STRATEGIES;
        }
        return Collections.singletonList((FormatStrategy)ret.get());
    }

    private static Optional<Integer> getQualifiedSequenceStart(List<IToken> tokens, int callIndex) {
        int endOffset = callIndex - 2;
        if (endOffset < 0) {
            return Optional.empty();
        }
        int qualifiedSequenceStart = TokenStreamUtils.firstTokenOfAlternatingTypes(tokens, (int)endOffset, (ETokenType)ETokenType.IDENTIFIER, (ETokenType)ETokenType.DOT);
        if (qualifiedSequenceStart == -1) {
            return Optional.empty();
        }
        return Optional.of(qualifiedSequenceStart);
    }

    static {
        BASIC_JAVA_TYPES = Pattern.compile("[bB]yte|[sS]hort|int|Integer|[lL]ong|[fF]loat|[dD]ouble|[bB]oolean|char|Character|String|(?:Collection|Set|List|Map|HashMap|ArrayList|LinkedList|Vector|TreeMap|NavigableMap|SortedMap) < .+ >");
        HashMap<String, JavaFormatStrategies.PrintfFormatStrategy> systemFakeStatic = new HashMap<String, JavaFormatStrategies.PrintfFormatStrategy>();
        systemFakeStatic.put("System.out", new JavaFormatStrategies.PrintfFormatStrategy(false));
        systemFakeStatic.put("System.err", new JavaFormatStrategies.PrintfFormatStrategy(false));
        HashMap<String, JavaFormatStrategies.PrintfFormatStrategy> systemWriters = new HashMap<String, JavaFormatStrategies.PrintfFormatStrategy>();
        systemWriters.put("java.io.PrintStream", new JavaFormatStrategies.PrintfFormatStrategy(false));
        systemWriters.put("java.io.PrintWriter", new JavaFormatStrategies.PrintfFormatStrategy(false));
        HashMap<String, FormatStrategy> printfStatic = new HashMap<String, FormatStrategy>(systemFakeStatic);
        HashMap<String, FormatStrategy> printfTypes = new HashMap<String, FormatStrategy>(systemWriters);
        printfTypes.put(LOG4J_LOGGER, JavaFormatStrategies.LOG4J);
        METHOD_TO_FORMAT_STRATEGIES.put("printf", new MethodFormatStrategies(printfStatic, printfTypes));
        HashMap<String, FormatStrategy> formatStatic = new HashMap<String, FormatStrategy>(systemFakeStatic);
        formatStatic.put("String", (FormatStrategy)new JavaFormatStrategies.PrintfFormatStrategy(false));
        formatStatic.put("java.text.MessageFormat", (FormatStrategy)new JavaFormatStrategies.MessageFormatStrategy(false));
        HashMap<String, FormatStrategy> formatTypes = new HashMap<String, FormatStrategy>(systemWriters);
        formatTypes.put("java.util.Formatter", (FormatStrategy)new JavaFormatStrategies.PrintfFormatStrategy(false));
        METHOD_TO_FORMAT_STRATEGIES.put("format", new MethodFormatStrategies(formatStatic, formatTypes));
        HashMap<String, FormatStrategy> logTypes = new HashMap<String, FormatStrategy>();
        logTypes.put(LOG4J_LOGGER, JavaFormatStrategies.LOG4J);
        METHOD_TO_FORMAT_STRATEGIES.put("log", new MethodFormatStrategies(Collections.emptyMap(), logTypes));
        HashMap<String, FormatStrategy> levelTypes = new HashMap<String, FormatStrategy>();
        levelTypes.put(LOG4J_LOGGER, JavaFormatStrategies.LOG4J);
        levelTypes.put(SL4J_LOGGER, (FormatStrategy)new JavaFormatStrategies.ParameterizedFormatStrategy(true));
        for (String logLevel : LOG_LEVELS) {
            METHOD_TO_FORMAT_STRATEGIES.put(logLevel, new MethodFormatStrategies(Collections.emptyMap(), levelTypes));
        }
        ALL_INSTANCE_FORMAT_STRATEGIES = METHOD_TO_FORMAT_STRATEGIES.values().stream().flatMap(f -> Stream.concat(f.classToStaticMethodFormatStrategy().values().stream(), f.classToInstanceMethodFormatStrategy().values().stream())).collect(Collectors.toSet());
    }

    private record LocalVariableTypeResult(@Nullable ShallowEntity surroundingMethod, String localVariableType) {
    }

    private record MethodFormatStrategies(Map<String, FormatStrategy> classToStaticMethodFormatStrategy, Map<String, FormatStrategy> classToInstanceMethodFormatStrategy) {
    }
}

