/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.python.PythonImportExtractor;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.ListMap;

@Check(id="cqse-do-not-import-private-members", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotImportPrivateMembers
extends CheckImplementationBase {
    private static final Pattern PRIVATE_IMPORT_PATTERN = Pattern.compile("\\._");

    public void execute() throws CheckException {
        ListMap<String, ShallowEntity> imports = PythonImportExtractor.extractImports(this.context.getRootEntity(ECodeViewOption.FILTERED));
        for (Map.Entry importEntry : imports) {
            this.createFindingsForPrivateImports(importEntry);
        }
    }

    private void createFindingsForPrivateImports(Map.Entry<String, List<ShallowEntity>> importEntry) throws CheckException {
        String importStatement = importEntry.getKey();
        if (PRIVATE_IMPORT_PATTERN.matcher(importStatement).find()) {
            for (ShallowEntity importEntity : importEntry.getValue()) {
                this.buildFinding("Do not import private member `" + importStatement + "`", this.buildLocation().forEntity(importEntity)).createAndStore();
            }
        }
    }
}

