/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility.python3;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-metaclasses-compatibility-python3", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MetaclassesCompatibilityPython3Check
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            this.processTokens((List<IToken>)attribute.ownStartTokens());
            this.processTokens((List<IToken>)attribute.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        TokenPattern pattern = this.getFindingPattern();
        for (TokenPatternMatch match : pattern.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            this.buildFinding("Metaclasses are used in an incompatible way", this.buildLocation().forTokens(matchedTokens)).createAndStore();
        }
    }

    private TokenPattern getFindingPattern() {
        return new TokenPattern().regex("^__metaclass__$").group(0).sequence(new Object[]{ETokenType.EQ});
    }
}

