/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility.python3;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-print-compatibility-python3", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PrintCompatibilityPython3Check
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processTokens((List<IToken>)statement.ownStartTokens());
            this.processTokens((List<IToken>)statement.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        TokenPattern pattern = new TokenPattern().notPrecededBy((Object)ETokenType.DOT).regex("^print$").group(0).notFollowedBy((Object)ETokenType.LPAREN);
        for (TokenPatternMatch match : pattern.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            String message = "Print method is used in an incompatible way";
            this.buildFinding(message, this.buildLocation().forTokens(matchedTokens)).createAndStore();
        }
    }
}

