/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.ICheckContext;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.markup.MarkupUtils;

class SimulinkNameLengthCheckUtils {
    SimulinkNameLengthCheckUtils() {
    }

    private static FindingPropertyList createRecommendedAction(int minimumLength, int maximumLength) {
        if (minimumLength > 0) {
            return FindingPropertyList.singleton((String)"Recommended Action", (String)("Change the name such that it adheres to the character constraint of " + minimumLength + " to " + maximumLength + " characters."));
        }
        return FindingPropertyList.singleton((String)"Recommended Action", (String)("Change the name such that it adheres to the character constraint of a maximum of " + maximumLength + " characters."));
    }

    private static String createFindingMessage(int minimumLenght, int maximumLength, String name, String simulinkObjectName) {
        if (name.length() < minimumLenght) {
            if (name.length() == 0) {
                return simulinkObjectName + " has no name; this violates the lower length constraint of " + minimumLenght + " characters";
            }
            return simulinkObjectName + " name " + MarkupUtils.formatAsSourceCode((String)name) + " violates the lower length constraint of " + minimumLenght + " characters";
        }
        return simulinkObjectName + " name " + MarkupUtils.formatAsSourceCode((String)name) + " violates the upper length constraint of " + maximumLength + " characters";
    }

    static void performLengthRestrictionCheck(ICheckContext context, int minimumLength, int maximumLength, String name, String simulinkObjectName, QualifiedNameLocation namedLocation) {
        if (name == null) {
            return;
        }
        if (name.length() < minimumLength || name.length() > maximumLength) {
            context.buildFinding(SimulinkNameLengthCheckUtils.createFindingMessage(minimumLength, maximumLength, name, simulinkObjectName), (ElementLocation)namedLocation).addFindingProperties(SimulinkNameLengthCheckUtils.createRecommendedAction(minimumLength, maximumLength)).createAndStore();
        }
    }
}

