/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0655", languages={ELanguage.SIMULINK})
public class SimulinkLogicalValueComparisonStateflowCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_VAL = "Usage of a logical value ({0}) in a Stateflow transition condition";
    private static final String FINDING_MESSAGE_VAR = "Boolean value comparison to a constant variable ({0}) in a Stateflow transition condition";
    private static final FindingPropertyList RECOMMENDED_ACTION_VAL = FindingPropertyList.singleton((String)"Recommended Action", (String)"Do not use true/false in a transition condition. E.g. use [b] instead of [b==true] and [~b] instead of [false==b].");
    private static final FindingPropertyList RECOMMENDED_ACTION_VAR = FindingPropertyList.singleton((String)"Recommended Action", (String)"Do not compare boolean variables to block-level constant variables in transition. E.g. use [b] instead of [b==ON_uint8] and [~b] instead of [b==OFF_uint16].");
    private static final Set<ETokenType> COMPARISON_OPERATORS = EnumSet.of(ETokenType.EQEQ, ETokenType.NOTEQ);
    private static final Set<String> LOGICAL_VALUE_NUMBERS = CollectionUtils.asHashSet((Object[])new String[]{"1", "0"});

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalSimulinkModel.get();
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            this.checkTransitions(((StateflowBlock)block).getChart());
        }
    }

    private void checkTransitions(StateflowChart chart) {
        for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
            StateflowTransitionParts transitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
            List conditionTokens = transitionParts.condition;
            if (conditionTokens.size() < 3) continue;
            this.checkComparisons(conditionTokens, transition, chart);
        }
    }

    private void checkComparisons(List<IToken> conditionTokens, StateflowTransition transition, StateflowChart chart) {
        String conditionText = TokenStreamTextUtils.concatTokenTexts(conditionTokens);
        for (int i = 0; i < conditionTokens.size(); ++i) {
            IToken token = conditionTokens.get(i);
            if (token.getType() != ETokenType.IDENTIFIER || !this.isBooleanVariable(token.getText(), chart)) continue;
            if (i > 1 && COMPARISON_OPERATORS.contains(conditionTokens.get(i - 1).getType())) {
                this.checkComparedVariable(conditionTokens.get(i - 2), conditionText, transition, chart);
                continue;
            }
            if (i + 2 >= conditionTokens.size() || !COMPARISON_OPERATORS.contains(conditionTokens.get(i + 1).getType())) continue;
            this.checkComparedVariable(conditionTokens.get(i + 2), conditionText, transition, chart);
        }
    }

    private void checkComparedVariable(IToken identifier, String conditionText, StateflowTransition transition, StateflowChart chart) {
        QualifiedNameLocation findingLocation = this.buildLocation().forStateflowTransition(transition);
        if (SimulinkLogicalValueComparisonStateflowCheck.isBooleanLiteral(identifier)) {
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE_VAL, conditionText), (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_VAL).createAndStore();
        } else if (SimulinkLogicalValueComparisonStateflowCheck.isConstantBlockLevelBooleanVariable(chart, identifier.getText())) {
            this.buildFinding(MessageFormat.format(FINDING_MESSAGE_VAR, conditionText), (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_VAR).createAndStore();
        }
    }

    private boolean isBooleanVariable(String variable, StateflowChart chart) {
        Optional<StateflowData> variableData = chart.getData().stream().filter(data -> variable.equals(data.getName())).findFirst();
        if (variableData.isEmpty()) {
            return false;
        }
        return SimulinkLogicalValueComparisonStateflowCheck.hasDirectDataTypeBoolean(variable, chart) || SimulinkLogicalValueComparisonStateflowCheck.isInputVariable(variableData.get()) && this.hasInheritedDataTypeBoolean(variable, chart);
    }

    private static boolean isInputVariable(StateflowData data) {
        return "INPUT_DATA".equals(data.getParameter("scope"));
    }

    private static boolean hasDirectDataTypeBoolean(String variable, StateflowChart chart) {
        return "boolean".equals(StateflowUtils.getDataTypeOfDataName((StateflowChart)chart, (String)variable).orElse(""));
    }

    private boolean hasInheritedDataTypeBoolean(String variable, StateflowChart chart) {
        Optional<SimulinkBlock> inPortBlock = chart.getStateflowBlock().getSubBlocks().stream().filter(subBlock -> subBlock.isOfType("Inport") && variable.equals(subBlock.getName())).findFirst();
        if (inPortBlock.isEmpty()) {
            return false;
        }
        Optional resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile();
        if (resolvedDataTypes.isEmpty()) {
            return false;
        }
        String dataType = ((SimulinkResolvedDataTypes)resolvedDataTypes.get()).getInputDataType((SimulinkBlock)chart.getStateflowBlock(), inPortBlock.get().getParameter("Port"));
        return "boolean".equals(dataType);
    }

    private static boolean isBooleanLiteral(IToken token) {
        return LOGICAL_VALUE_NUMBERS.contains(token.getText()) || token.getType() == ETokenType.BOOLEAN_LITERAL || token.getType() == ETokenType.IDENTIFIER && (token.getText().equalsIgnoreCase("true") || token.getText().equalsIgnoreCase("false"));
    }

    private static boolean isConstantBlockLevelBooleanVariable(StateflowChart chart, String variableName) {
        for (StateflowData data : chart.getData()) {
            boolean hasLogicalNumberValue;
            if (!variableName.equals(data.getName())) continue;
            if (!"CONSTANT_DATA".equals(data.getParameter("scope"))) {
                return false;
            }
            String value = data.getParameter("props.initialValue");
            boolean bl = hasLogicalNumberValue = value != null && LOGICAL_VALUE_NUMBERS.contains(value);
            if (!hasLogicalNumberValue && !"boolean".equals(data.getParameter("dataType"))) continue;
            return true;
        }
        return false;
    }
}

