/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jc_0802", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkUseOfImplicitTypeCastingInStateflowCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Operation is performed on multiple data types: {0} ({1})";
    private static final FindingPropertyList RECOMMENDED_ACTION_MODIFY = FindingPropertyList.singleton((String)"Recommended Action", (String)"Perform an explicit type cast, so the operation is performed on variables of the same data type.");
    private static final EMatlabActionEntityType[] MATLAB_OPERATIONS = new EMatlabActionEntityType[]{EMatlabActionEntityType.COMPARISON, EMatlabActionEntityType.ASSIGNMENT, EMatlabActionEntityType.ADDITION, EMatlabActionEntityType.SUBTRACTION, EMatlabActionEntityType.MULTIPLICATION, EMatlabActionEntityType.DIVISION, EMatlabActionEntityType.MODULO, EMatlabActionEntityType.MODULO, EMatlabActionEntityType.MATRIX_MULTIPLICATION};
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedDataTypes == null || model.getStateflowMachine() == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (StateflowChart chart : model.getStateflowMachine().getCharts()) {
            for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
                if (state.isMatlabFunction()) {
                    this.checkMatlabFunction(state, resolvedDataTypes, dataDictionaries);
                    continue;
                }
                if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) continue;
                this.checkStateflowState(state, resolvedDataTypes, dataDictionaries);
            }
            if (StateflowUtils.hasActionLanguageC((StateflowChart)chart)) continue;
            for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
                StateflowTransitionParts transitionLabelParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
                this.checkTransitionAction(transition, transitionLabelParts.condition, resolvedDataTypes, dataDictionaries);
                this.checkTransitionAction(transition, transitionLabelParts.conditionAction, resolvedDataTypes, dataDictionaries);
                this.checkTransitionAction(transition, transitionLabelParts.transitionAction, resolvedDataTypes, dataDictionaries);
                this.checkTransitionAction(transition, transitionLabelParts.eventOrMessage, resolvedDataTypes, dataDictionaries);
            }
        }
    }

    private void checkMatlabFunction(StateflowState state, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        try {
            List typesPerFunction = MatlabActionTypeResolver.fromMatlabFunctionNode((StateflowState)state, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries);
            for (MatlabActionTypeResolver types : typesPerFunction) {
                for (Pair operationText : SimulinkUseOfImplicitTypeCastingInStateflowCheck.operationsWithMultipleDataTypesToText(types)) {
                    String findingMessage = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)((String)operationText.getFirst())), operationText.getSecond());
                    this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION_MODIFY).createAndStore();
                }
            }
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Could not parse code in " + this.buildLocation().forStateflowNode((StateflowNodeBase)state).getQualifiedName(), (Throwable)e);
        }
    }

    private void checkStateflowState(StateflowState state, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        List stateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state);
        for (StateflowStateAction stateAction : stateActions) {
            try {
                MatlabActionTypeResolver types = MatlabActionTypeResolver.from((List)stateAction.actionCode, (StateflowState)state, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries);
                for (Pair operationText : SimulinkUseOfImplicitTypeCastingInStateflowCheck.operationsWithMultipleDataTypesToText(types)) {
                    String findingMessage = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)((String)operationText.getFirst())), operationText.getSecond());
                    this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION_MODIFY).createAndStore();
                }
            }
            catch (MatlabActionParserException e) {
                LOGGER.debug("Could not parse code in " + this.buildLocation().forStateflowNode((StateflowNodeBase)state).getQualifiedName(), (Throwable)e);
            }
        }
    }

    private void checkTransitionAction(StateflowTransition transition, List<IToken> transitionLabelPart, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        try {
            MatlabActionTypeResolver types = MatlabActionTypeResolver.from(transitionLabelPart, (StateflowTransition)transition, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries);
            for (Pair operationText : SimulinkUseOfImplicitTypeCastingInStateflowCheck.operationsWithMultipleDataTypesToText(types)) {
                String findingMessage = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)((String)operationText.getFirst())), operationText.getSecond());
                this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION_MODIFY).createAndStore();
            }
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Could not parse code in " + this.buildLocation().forStateflowTransition(transition).getQualifiedName(), (Throwable)e);
        }
    }

    private static PairList<String, String> operationsWithMultipleDataTypesToText(MatlabActionTypeResolver ast) {
        List operations = MatlabActionAstUtils.listNodesOfEntityTypeRecursively((MatlabActionAstNode)ast.getRootNode(), (EMatlabActionEntityType[])MATLAB_OPERATIONS);
        PairList violatingOperations = new PairList();
        for (MatlabActionAstNode operation : operations) {
            LinkedHashSet typesInOperation = operation.getChildren().stream().map(arg_0 -> ((MatlabActionTypeResolver)ast).inferDataTypeOf(arg_0)).filter(type -> type != null && !type.equals("Unknown") && !type.equals("NOT_CONNECTED")).collect(Collectors.toCollection(LinkedHashSet::new));
            if (typesInOperation.size() <= 1) continue;
            String operationText = TokenStreamTextUtils.concatTokenTexts((List)operation.getTokens());
            violatingOperations.add((Object)operationText, (Object)String.join((CharSequence)", ", typesInOperation));
        }
        return violatingOperations;
    }
}

