/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-dynamic-sql", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidDynamicSqlCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"exec".equals(statement.getSubtype()) && !"execute".equals(statement.getSubtype())) continue;
            this.buildFinding(this.getFindingMessage(statement), this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private String getFindingMessage(ShallowEntity entity) {
        Object subType = entity.getSubtype();
        UnmodifiableList tokens = entity.ownStartTokens();
        if (((String)subType).equals("execute") && tokens.size() > 1) {
            subType = (String)subType + " " + ((IToken)tokens.get(1)).getText();
        }
        return "Usage of Dynamic SQL by '" + ((String)subType).toUpperCase() + "'";
    }
}

