/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ManualTestCase;
import com.teamscale.wia.ManualTestCaseDescriber;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.SpecItemDescriber;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.WorkItemLocationBuilder;
import eu.cqse.check.framework.core.option.CheckOptionBase;
import eu.cqse.check.framework.core.option.ICheckOption;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class WorkItemCheckBase<T extends TeamscaleIssue>
extends CheckImplementationBase {
    private final Class<T> workItemClass;
    private T workItem;
    private boolean executeOnClosedItems;

    protected WorkItemCheckBase(Class<T> workItemClass) {
        CCSMAssert.isNotNull(workItemClass, () -> String.format("Expected \"%s\" to be not null", "workItemClass"));
        this.workItemClass = workItemClass;
    }

    public final void execute() throws CheckException {
        this.workItem = this.getWorkItem();
        if (!this.executeOnClosedItems && this.workItem.isClosed()) {
            return;
        }
        this.execute(this.workItem);
    }

    protected abstract void execute(T var1) throws CheckException;

    protected ShallowEntity getWorkItemEntity() {
        try {
            ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
            List workItemEntities = rootEntity.getChildrenOfType(EShallowEntityType.TYPE);
            CCSMAssert.isTrue((workItemEntities.size() == 1 ? 1 : 0) != 0, () -> String.format("Expected root entity %s to contain exactly one work item, but did contain %d", rootEntity, workItemEntities.size()));
            return (ShallowEntity)workItemEntities.get(0);
        }
        catch (CheckException e) {
            throw new IllegalStateException("Unable to obtain root work item entity from context", e);
        }
    }

    protected WorkItemLocationBuilder buildLocation() {
        return new WorkItemLocationBuilder(this.context.buildLocation(), this.getCodeViewOption().textView, this.getWorkItemEntity(), this.workItem.getId().getInternalId());
    }

    protected WorkItemDescriberBase<T> getDescriber(TeamscaleIssue specItem) {
        if (specItem instanceof ManualTestCase) {
            return new ManualTestCaseDescriber();
        }
        if (specItem instanceof SpecItem) {
            return new SpecItemDescriber();
        }
        return new WorkItemDescriberBase();
    }

    public List<ICheckOption<?>> getAdditionalOptions(String readableCheckName) {
        ArrayList additionalOptions = new ArrayList(super.getAdditionalOptions(readableCheckName));
        additionalOptions.add((ICheckOption<?>)new ExecuteOnClosedItemsCheckOption(readableCheckName));
        return additionalOptions;
    }

    private T getWorkItem() throws CheckException {
        return (T)((TeamscaleIssue)this.context.getWorkItem(this.workItemClass).orElseThrow(() -> new IllegalStateException("Work item check was executed without work item of type: " + String.valueOf(this.workItemClass))));
    }

    private static class ExecuteOnClosedItemsCheckOption
    extends CheckOptionBase<Boolean> {
        private static final boolean DEFAULT_VALUE = false;

        private ExecuteOnClosedItemsCheckOption(String checkName) {
            super(checkName + " - Execute on closed items", "Whether the check should also be executed on closed items.", false, Boolean.class, (Object)false);
        }

        public void setOption(CheckImplementationBase check, Boolean value) {
            if (!(check instanceof WorkItemCheckBase)) {
                throw new IllegalArgumentException("Cannot set option %s on check instance: %s".formatted(this.getName(), check.getClass()));
            }
            WorkItemCheckBase workItemCheck = (WorkItemCheckBase)check;
            workItemCheck.executeOnClosedItems = value;
        }
    }
}

