/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.delegatedauthorization.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.delegatedauthorization.SessionToken;
import com.microsoft.alm.visualstudio.services.delegatedauthorization.SessionTokenType;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class DelegatedAuthorizationHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    public DelegatedAuthorizationHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public SessionToken createSessionToken(SessionToken sessionToken, SessionTokenType tokenType, Boolean isPublic) {
        UUID locationId = UUID.fromString("ada996bc-8c18-4193-b20c-cd41b13f5b4d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("tokenType", tokenType);
        queryParameters.addIfNotNull("isPublic", isPublic);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, sessionToken, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, SessionToken.class);
    }

    public List<SessionToken> getSessionTokens(String authorizationId, Boolean isPublic, Boolean includePublicData) {
        UUID locationId = UUID.fromString("ada996bc-8c18-4193-b20c-cd41b13f5b4d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("authorizationId", authorizationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("isPublic", isPublic);
        queryParameters.addIfNotNull("includePublicData", includePublicData);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<List<SessionToken>>(){});
    }

    public void revokeSessionToken(UUID authorizationId, Boolean isPublic) {
        UUID locationId = UUID.fromString("ada996bc-8c18-4193-b20c-cd41b13f5b4d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("authorizationId", authorizationId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("isPublic", isPublic);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }
}

