/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build;

import com.microsoft.tfs.core.clients.build.IBuildDefinitionSourceProvider;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionSourceProvider;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.util.StringUtil;

public class BuildSourceProviders {
    public static final String TfVersionControl = "TFVC";
    public static final String TfGit = "TFGIT";
    public static final String Git = "GIT";

    public static boolean isTfGit(String sourceProvider) {
        return TfGit.equalsIgnoreCase(sourceProvider);
    }

    public static boolean isGit(String sourceProvider) {
        return Git.equalsIgnoreCase(sourceProvider) || BuildSourceProviders.isTfGit(sourceProvider);
    }

    public static boolean isTfVersionControl(String sourceProvider) {
        return StringUtil.isNullOrEmpty(sourceProvider) || sourceProvider.equalsIgnoreCase(TfVersionControl);
    }

    public static boolean isTfGit(IBuildDefinitionSourceProvider sourceProvider) {
        if (sourceProvider == null || sourceProvider.getName() == null) {
            return false;
        }
        return BuildSourceProviders.isTfGit(sourceProvider.getName());
    }

    public static boolean isTfVersionControl(IBuildDefinitionSourceProvider sourceProvider) {
        if (sourceProvider == null || sourceProvider.getName() == null) {
            return true;
        }
        return BuildSourceProviders.isTfVersionControl(sourceProvider.getName());
    }

    public static BuildDefinitionSourceProvider createGitSourceProvider() {
        return new BuildDefinitionSourceProvider(TfGit, DefinitionTriggerType.ALL.remove(DefinitionTriggerType.GATED_CHECKIN));
    }

    public static BuildDefinitionSourceProvider createTfVcSourceProvider() {
        return new BuildDefinitionSourceProvider(TfVersionControl, DefinitionTriggerType.ALL);
    }
}

