/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.clients.build.internal.utils.QueryResultHelper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._BuildControllerQueryResult;
import ms.tfs.build.buildservice._04._BuildServiceHost;

public class BuildControllerQueryResult
extends WebServiceObjectWrapper
implements IBuildControllerQueryResult {
    private final BuildController[] controllers;
    private final BuildServiceHost[] serviceHosts;
    private final BuildAgent[] agents;

    public BuildControllerQueryResult(IBuildServer buildServer, _BuildControllerQueryResult webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.serviceHosts = BuildTypeConvertor.toBuildServiceHostArray(buildServer, this.getWebServiceObject().getServiceHosts());
        this.agents = BuildTypeConvertor.toBuildAgentArray(this.getWebServiceObject().getAgents());
        this.controllers = BuildTypeConvertor.toBuildControllersArray(buildServer, this.getWebServiceObject().getControllers());
        this.afterDeserialize(buildServer);
    }

    public BuildControllerQueryResult(IBuildServer buildServer, BuildAgent[] agents, BuildController[] controllers, BuildServiceHost[] serviceHosts) {
        super(new _BuildControllerQueryResult());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(agents, "agents");
        Check.notNull(controllers, "controllers");
        Check.notNull(serviceHosts, "serviceHosts");
        this.agents = agents;
        this.controllers = controllers;
        this.serviceHosts = serviceHosts;
        _BuildAgent[] _agents = (_BuildAgent[])WrapperUtils.unwrap(_BuildAgent.class, agents);
        _BuildController[] _controllers = (_BuildController[])WrapperUtils.unwrap(_BuildController.class, controllers);
        _BuildServiceHost[] _serviceHosts = (_BuildServiceHost[])WrapperUtils.unwrap(_BuildServiceHost.class, serviceHosts);
        this.getWebServiceObject().setAgents(_agents);
        this.getWebServiceObject().setControllers(_controllers);
        this.getWebServiceObject().setServiceHosts(_serviceHosts);
        this.afterDeserialize(buildServer);
    }

    public _BuildControllerQueryResult getWebServiceObject() {
        return (_BuildControllerQueryResult)this.webServiceObject;
    }

    @Override
    public IBuildController[] getControllers() {
        return this.controllers;
    }

    @Override
    public IFailure[] getFailures() {
        return new IFailure[0];
    }

    private void afterDeserialize(IBuildServer buildServer) {
        QueryResultHelper.match(this.serviceHosts, this.controllers, this.agents);
    }
}

