/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolveErrorHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolvedHandler;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictComparator;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ResolveConflictHandler
implements ConflictResolvedHandler,
ConflictResolveErrorHandler {
    private final VersionControlClient client;
    private final Workspace workspace;
    private final Map<Integer, String> updatedSourceLocalItems;
    private final List<GetOperationGroup> getOpGroups = new ArrayList<GetOperationGroup>();
    private final List<Conflict> resolvedConflicts = new ArrayList<Conflict>();
    private final List<UpdateLocalVersionSpec> updateLocalVersionSpecs = new ArrayList<UpdateLocalVersionSpec>();
    private ChangePendedFlags flags = ChangePendedFlags.UNKNOWN;

    public ResolveConflictHandler(VersionControlClient client, Workspace workspace, Map<Integer, String> updatedSourceLocalItems) {
        Check.notNull(client, "client");
        Check.notNull(workspace, "workspace");
        Check.notNull(updatedSourceLocalItems, "updatedSourceLocalItems");
        this.client = client;
        this.workspace = workspace;
        this.updatedSourceLocalItems = updatedSourceLocalItems;
    }

    public List<GetOperationGroup> getGetOpGroups() {
        return this.getOpGroups;
    }

    public List<Conflict> getResolvedConflicts() {
        return this.resolvedConflicts;
    }

    public List<UpdateLocalVersionSpec> getUpdateLocalVersionSpecs() {
        return this.updateLocalVersionSpecs;
    }

    public ChangePendedFlags getFlags() {
        return this.flags;
    }

    @Override
    public void conflictResolved(Conflict conflict, GetOperation[] getOps, GetOperation[] undoOps, Conflict[] otherResolvedConflicts, ChangePendedFlags changePendedFlags) {
        Check.notNull(conflict, "conflict");
        String updatedSourceLocalItem = this.updatedSourceLocalItems.get(conflict.getConflictID());
        if (updatedSourceLocalItem != null) {
            this.workspace.getWorkspaceWatcher().removeSkippedItem(updatedSourceLocalItem);
            conflict.setSourceLocalItem(updatedSourceLocalItem);
        }
        Check.isTrue(!Resolution.DELETE_CONFLICT.equals(conflict.getResolution()) || getOps.length == 0 && undoOps.length == 0, MessageFormat.format("Didn't expect any get ops (got {0}) or undo ops (got {1})", getOps.length, undoOps.length));
        conflict.setResolved(true);
        this.client.getEventEngine().fireConflictResolved(new ConflictResolvedEvent(EventSource.newFromHere(), this.workspace, conflict, changePendedFlags));
        Arrays.sort(otherResolvedConflicts, new ConflictComparator());
        for (Conflict conflict2 : otherResolvedConflicts) {
            conflict2.setResolved(true);
            conflict2.setResolution(conflict.getResolution());
            this.client.getEventEngine().fireConflictResolved(new ConflictResolvedEvent(EventSource.newFromHere(), this.workspace, conflict2, changePendedFlags));
        }
        if (Resolution.ACCEPT_THEIRS.equals(conflict.getResolution()) && !conflict.isNamespaceConflict()) {
            for (WebServiceObjectWrapper webServiceObjectWrapper : undoOps) {
                if (((GetOperation)webServiceObjectWrapper).getTargetServerItem() == null || !ServerPath.equals(((GetOperation)webServiceObjectWrapper).getTargetServerItem(), conflict.getYourServerItem()) || ((GetOperation)webServiceObjectWrapper).getVersionLocal() != 0 || ((GetOperation)webServiceObjectWrapper).getSourceLocalItem() == null || !ItemType.FILE.equals(((GetOperation)webServiceObjectWrapper).getItemType())) continue;
                ((GetOperation)webServiceObjectWrapper).setOkayToOverwriteExistingLocal(true);
            }
        }
        if (Resolution.ACCEPT_THEIRS.equals(conflict.getResolution()) && conflict.getYourLocalChangeType().contains(ChangeType.EDIT)) {
            for (WebServiceObjectWrapper webServiceObjectWrapper : getOps) {
                String conflictItem;
                String getOpItem = ((GetOperation)webServiceObjectWrapper).getSourceServerItem() != null ? ((GetOperation)webServiceObjectWrapper).getSourceServerItem() : ((GetOperation)webServiceObjectWrapper).getTargetServerItem();
                String string = conflictItem = conflict.getYourServerItemSource() != null ? conflict.getYourServerItemSource() : conflict.getYourServerItem();
                if (!ServerPath.equals(getOpItem, conflictItem) || ((GetOperation)webServiceObjectWrapper).getVersionLocal() != -1 || ((GetOperation)webServiceObjectWrapper).getSourceLocalItem() == null || !((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.MERGE) && !((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.ROLLBACK) && !conflict.isShelvesetConflict() || !((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.EDIT)) continue;
                ((GetOperation)webServiceObjectWrapper).setOkayToOverwriteExistingLocal(true);
            }
        } else if (Resolution.ACCEPT_MERGE.equals(conflict.getResolution()) || Resolution.ACCEPT_YOURS.equals(conflict.getResolution())) {
            for (WebServiceObjectWrapper webServiceObjectWrapper : getOps) {
                if ((!Resolution.ACCEPT_MERGE.equals(conflict.getResolution()) || conflict.getMergedFileName() == null || conflict.getMergedFileName().length() <= 0 || !ServerPath.equals(((GetOperation)webServiceObjectWrapper).getTargetServerItem(), conflict.getYourServerItem()) || ((GetOperation)webServiceObjectWrapper).getItemID() != conflict.getYourItemID() || ((GetOperation)webServiceObjectWrapper).getVersionLocal() != -1 && ((GetOperation)webServiceObjectWrapper).getVersionLocal() != 0 || !((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.MERGE) || !((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.EDIT)) && (!ConflictType.CHECKIN.equals(conflict.getType()) && !ConflictType.GET.equals(conflict.getType()) || !ItemType.FILE.equals(((GetOperation)webServiceObjectWrapper).getItemType()) || !((GetOperation)webServiceObjectWrapper).getChangeType().contains(ChangeType.EDIT) || !LocalPath.equals(conflict.getSourceLocalItem(), ((GetOperation)webServiceObjectWrapper).getSourceLocalItem()))) continue;
                UpdateLocalVersionSpec ulvs = new UpdateLocalVersionSpec();
                ulvs.setSourceServerItem(((GetOperation)webServiceObjectWrapper).getSourceServerItem());
                ulvs.setItemID(((GetOperation)webServiceObjectWrapper).getItemID());
                ulvs.setSourceLocalItem(conflict.getSourceLocalItem());
                ulvs.setVersionServer(((GetOperation)webServiceObjectWrapper).getVersionServer());
                ulvs.setPropertyValues(((GetOperation)webServiceObjectWrapper).getPropertyValues());
                this.updateLocalVersionSpecs.add(ulvs);
                ((GetOperation)webServiceObjectWrapper).setVersionLocal(((GetOperation)webServiceObjectWrapper).getVersionServer());
                ((GetOperation)webServiceObjectWrapper).setSourceLocalItem(conflict.getSourceLocalItem());
            }
        }
        this.flags = this.flags.combine(changePendedFlags);
        GetOperationGroup currentGroup = null;
        boolean needNewGroup = true;
        if (this.getOpGroups.size() > 0) {
            needNewGroup = false;
            currentGroup = this.getOpGroups.get(this.getOpGroups.size() - 1);
            for (GetOperation getOp : getOps) {
                if (getOp.getTargetLocalItem() == null || !currentGroup.hasGetOpForLocalPath(getOp.getTargetLocalItem()).booleanValue()) continue;
                needNewGroup = true;
                break;
            }
            if (!needNewGroup) {
                for (GetOperation getOp : undoOps) {
                    if (getOp.getTargetLocalItem() == null || !currentGroup.hasGetOpForLocalPath(getOp.getTargetLocalItem()).booleanValue()) continue;
                    needNewGroup = true;
                    break;
                }
            }
        }
        if (needNewGroup) {
            currentGroup = new GetOperationGroup();
            this.getOpGroups.add(currentGroup);
        }
        currentGroup.addOperations(ProcessType.GET, getOps);
        currentGroup.addOperations(ProcessType.UNDO, undoOps);
        for (Conflict otherResolvedConflict : otherResolvedConflicts) {
            this.resolvedConflicts.add(otherResolvedConflict);
        }
    }

    @Override
    public void conflictResolveError(Conflict conflict, Exception exception) {
        String updatedSourceLocalItem = this.updatedSourceLocalItems.get(conflict.getConflictID());
        if (updatedSourceLocalItem != null) {
            this.workspace.getWorkspaceWatcher().removeSkippedItem(updatedSourceLocalItem);
            conflict.setSourceLocalItem(updatedSourceLocalItem);
        }
        this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)exception));
    }

    public class GetOperationGroup {
        private final Set<String> localItems = new TreeSet<String>(LocalPath.TOP_DOWN_COMPARATOR);
        private List<GetOperation> undoOps = new ArrayList<GetOperation>();
        private List<GetOperation> getOps = new ArrayList<GetOperation>();

        public Boolean hasGetOpForLocalPath(String localPath) {
            return this.localItems.contains(localPath);
        }

        public void addOperations(ProcessType processType, GetOperation[] operations) {
            for (GetOperation operation : operations) {
                if (operation.getTargetLocalItem() != null) {
                    this.localItems.add(operation.getTargetLocalItem());
                }
                if (processType == ProcessType.UNDO) {
                    this.undoOps.add(operation);
                    continue;
                }
                this.getOps.add(operation);
            }
        }

        public GetOperation[] getUndoOps() {
            return this.undoOps.toArray(new GetOperation[this.undoOps.size()]);
        }

        public void setUndoOps(List<GetOperation> undoOps) {
            this.undoOps = undoOps;
        }

        public GetOperation[] getGetOps() {
            return this.getOps.toArray(new GetOperation[this.getOps.size()]);
        }

        public void setGetOps(List<GetOperation> getOps) {
            this.getOps = getOps;
        }
    }

    public class UpdateLocalVersionSpec {
        private String sourceServerItem;
        private int itemID;
        private String sourceLocalItem;
        private int versionServer;
        private PropertyValue[] properties;

        public String getSourceServerItem() {
            return this.sourceServerItem;
        }

        public void setSourceServerItem(String sourceServerItem) {
            this.sourceServerItem = sourceServerItem;
        }

        public int getItemID() {
            return this.itemID;
        }

        public void setItemID(int itemID) {
            this.itemID = itemID;
        }

        public String getSourceLocalItem() {
            return this.sourceLocalItem;
        }

        public void setSourceLocalItem(String sourceLocalItem) {
            this.sourceLocalItem = sourceLocalItem;
        }

        public int getVersionServer() {
            return this.versionServer;
        }

        public void setVersionServer(int versionServer) {
            this.versionServer = versionServer;
        }

        public PropertyValue[] getProperyValues() {
            return this.properties;
        }

        public void setPropertyValues(PropertyValue[] properties) {
            this.properties = properties;
        }
    }
}

