/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissionProfile;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.InvalidWorkspacePropertiesTableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderState;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryWriter;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.EnumeratedLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalItemEnumerable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.Tables;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.internal.FileSystemWalker;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolderType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.helpers.FileCopyHelper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalWorkspaceProperties
extends LocalMetadataTable {
    private static final Log log = LogFactory.getLog(LocalWorkspaceProperties.class);
    private Map<String, BaselineFolder> metadataTableLocations;
    private List<BaselineFolder> baselineFolders;
    private List<WorkingFolder> workingFolders;
    private int newProjectRevisionId;
    private Workspace workspace;
    private int baselineFoldersWriteLockToken;
    private static final String ONE_LEVEL_MAPPING = "/*";
    private static final short MAGIC = 32316;
    private static final byte SCHEMA_VERSION2 = 2;

    public LocalWorkspaceProperties(String tableLocation, LocalWorkspaceProperties cachedLoadSource) throws Exception {
        super(tableLocation, cachedLoadSource);
    }

    @Override
    protected void initialize() {
        this.baselineFolders = new ArrayList<BaselineFolder>();
        this.workingFolders = new ArrayList<WorkingFolder>();
        this.metadataTableLocations = new HashMap<String, BaselineFolder>();
        this.workspace = LocalWorkspaceTransaction.getCurrent().getWorkspace();
    }

    public List<BaselineFolder> getBaselineFolders() {
        return this.baselineFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(InputStream is) throws Exception {
        block8: {
            log.trace((Object)"--- Entering load ---");
            BinaryReader br = new BinaryReader(is, "UTF-16LE");
            try {
                try {
                    short magic = br.readInt16();
                    log.trace((Object)("magic: " + magic));
                    if (32316 != magic) {
                        throw new InvalidWorkspacePropertiesTableException();
                    }
                    byte schemaVersion = br.readByte();
                    log.trace((Object)("version: " + schemaVersion));
                    if (schemaVersion == 2) {
                        this.loadFromVersion2(br, true);
                        break block8;
                    }
                    throw new InvalidWorkspacePropertiesTableException();
                }
                catch (Exception e) {
                    log.trace((Object)"--- leaving load with exception ---", (Throwable)e);
                    log.trace((Object)"");
                    if (e instanceof InvalidWorkspacePropertiesTableException) {
                        throw (InvalidWorkspacePropertiesTableException)e;
                    }
                    throw new InvalidWorkspacePropertiesTableException(e);
                }
            }
            finally {
                br.close();
            }
        }
        log.trace((Object)"--- Leaving load ---");
        log.trace((Object)"");
    }

    private void loadFromVersion2(BinaryReader br, boolean isVersionTwo) throws Exception {
        log.trace((Object)"--- Entering loadFromVersion2 ---");
        this.baselineFolders.clear();
        int count = br.readInt16();
        log.trace((Object)("baseline folders count: " + count));
        for (int i = 0; i < count; ++i) {
            String partition = br.readString();
            log.trace((Object)("baseline folder partition: " + partition));
            if (partition.length() == 0) {
                partition = null;
            }
            String path = br.readString();
            log.trace((Object)("baseline folder path: " + path));
            if (path.length() == 0) {
                path = null;
            }
            BaselineFolderState state = BaselineFolderState.fromByte(br.readByte());
            log.trace((Object)("baseline folder state: " + state));
            this.baselineFolders.add(new BaselineFolder(partition, path, state));
        }
        int mapCount = br.readInt16();
        log.trace((Object)("baseline folder map count: " + mapCount));
        for (int i = 0; i < mapCount; ++i) {
            String tableName = br.readString();
            log.trace((Object)("baseline folder map table name: " + tableName));
            if (tableName.length() == 0) continue;
            short index = br.readInt16();
            log.trace((Object)("baseline folder map table index: " + index));
            if (index >= 0 && index < count) {
                this.metadataTableLocations.put(tableName, this.baselineFolders.get(index));
                continue;
            }
            this.metadataTableLocations.put(tableName, null);
        }
        int workingFolderCount = br.readInt16();
        log.trace((Object)("working folder count: " + workingFolderCount));
        for (int i = 0; i < workingFolderCount; ++i) {
            WorkingFolderType type = WorkingFolderType.MAP;
            RecursionType recursionType = RecursionType.FULL;
            String serverItem = br.readString();
            log.trace((Object)("working folder server item: " + serverItem));
            if (serverItem.length() == 0) continue;
            String localItem = br.readString();
            log.trace((Object)("working folder local item: " + localItem));
            if (localItem.length() == 0) {
                localItem = null;
                type = WorkingFolderType.CLOAK;
            } else if (serverItem.endsWith(ONE_LEVEL_MAPPING)) {
                recursionType = RecursionType.ONE_LEVEL;
                serverItem = serverItem.substring(0, serverItem.length() - ONE_LEVEL_MAPPING.length());
            }
            this.workingFolders.add(new WorkingFolder(serverItem, localItem, type, recursionType));
        }
        if (isVersionTwo && !br.isEOF()) {
            this.newProjectRevisionId = br.readInt32();
            log.trace((Object)("working folder new project revision id: " + this.newProjectRevisionId));
        } else {
            this.newProjectRevisionId = 0;
        }
        log.trace((Object)"--- Leaving loadFromVersion2 ---");
    }

    @Override
    protected boolean cachedLoad(LocalMetadataTable source) {
        if (source instanceof LocalWorkspaceProperties) {
            LocalWorkspaceProperties wpCached = (LocalWorkspaceProperties)source;
            this.baselineFolders = wpCached.baselineFolders;
            this.metadataTableLocations = wpCached.metadataTableLocations;
            this.workingFolders = wpCached.workingFolders;
            this.newProjectRevisionId = wpCached.newProjectRevisionId;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save(OutputStream os) throws IOException {
        log.trace((Object)"--- Entering save ---");
        BinaryWriter bw = new BinaryWriter(os, "UTF-16LE");
        try {
            bw.write((short)32316);
            log.trace((Object)"magic: 32316");
            this.writeToVersion2(bw);
        }
        finally {
            bw.close();
        }
        log.trace((Object)"--- Leaving save ---");
        return true;
    }

    @Override
    public void close() throws IOException {
        WorkspaceLock wLock;
        BaselineFolderCollection baselineFolders;
        super.close();
        if (0 != this.baselineFoldersWriteLockToken && null != (baselineFolders = (wLock = LocalWorkspaceTransaction.getCurrent().getWorkspaceLock()).getBaselineFolders())) {
            baselineFolders.updateFrom(this.baselineFolders);
            baselineFolders.unlockForWrite(this.baselineFoldersWriteLockToken);
            this.baselineFoldersWriteLockToken = 0;
        }
    }

    @Override
    protected void saveComplete() {
        String sourceLocation = LocalWorkspaceProperties.getSlotOnePath(this.getFilename());
        String fileNamePart = LocalPath.getFileName(sourceLocation);
        for (BaselineFolder baselineFolder : this.baselineFolders) {
            try {
                if (BaselineFolderState.VALID != baselineFolder.getState()) {
                    String potentialOldBackupCopy = LocalPath.combine(baselineFolder.getPath(), fileNamePart);
                    if (!new File(potentialOldBackupCopy).exists()) continue;
                    FileHelpers.deleteFileWithoutException(potentialOldBackupCopy);
                    continue;
                }
                FileCopyHelper.copy(sourceLocation, LocalPath.combine(baselineFolder.getPath(), fileNamePart));
            }
            catch (Exception ex) {
                log.trace((Object)ex);
            }
        }
    }

    private void writeToVersion2(BinaryWriter bw) throws IOException {
        log.trace((Object)"--- Entering writeToVersion2 ---");
        bw.write((byte)2);
        log.trace((Object)"version: 2");
        bw.write((short)this.baselineFolders.size());
        log.trace((Object)("baseline folders size: " + this.baselineFolders.size()));
        for (BaselineFolder baselineFolder : this.baselineFolders) {
            bw.write(baselineFolder.partition == null ? "" : baselineFolder.partition);
            log.trace((Object)("baseline folder partition: " + (baselineFolder.partition == null ? "" : baselineFolder.partition)));
            bw.write(baselineFolder.path == null ? "" : baselineFolder.path);
            log.trace((Object)("baseline folder path: " + (baselineFolder.path == null ? "" : baselineFolder.path)));
            bw.write((byte)baselineFolder.state.getValue());
            log.trace((Object)("baseline folder state: " + baselineFolder.state));
        }
        bw.write((short)this.metadataTableLocations.size());
        log.trace((Object)("baseline folder maps count: " + this.metadataTableLocations.size()));
        for (String key : this.metadataTableLocations.keySet()) {
            BaselineFolder value = this.metadataTableLocations.get(key);
            bw.write(key == null ? "" : key);
            log.trace((Object)("baseline folder map name: " + (key == null ? "" : key)));
            short index = -1;
            if (null != value) {
                index = (short)this.baselineFolders.indexOf(value);
            }
            bw.write(index);
            log.trace((Object)("baseline folder maps index: " + index));
        }
        bw.write((short)this.workingFolders.size());
        log.trace((Object)("working folders count: " + this.workingFolders.size()));
        for (WorkingFolder workingFolder : this.workingFolders) {
            String serverItem = workingFolder.getServerItem();
            if (RecursionType.ONE_LEVEL == workingFolder.getDepth()) {
                serverItem = serverItem.concat(ONE_LEVEL_MAPPING);
            }
            bw.write(serverItem);
            log.trace((Object)("working folder server item: " + serverItem));
            if (WorkingFolderType.CLOAK == workingFolder.getType()) {
                bw.write("");
                log.trace((Object)"working folder local item: ");
                continue;
            }
            bw.write(workingFolder.getLocalItem());
            log.trace((Object)("working folder local item: " + workingFolder.getLocalItem()));
        }
        if (this.newProjectRevisionId > 0) {
            bw.write(this.newProjectRevisionId);
            log.trace((Object)("working folder new project revision id: " + this.newProjectRevisionId));
        }
        log.trace((Object)"--- Leaving writeToVersion2 ---");
        log.trace((Object)"");
    }

    public String getMetadataTableLocation(String tableName) {
        String programDataLocationFileName;
        String expectedLocation;
        String expectedFileName;
        Check.notNullOrEmpty(tableName, "tableName");
        BaselineFolder expectedBaselineFolder = null;
        if (this.metadataTableLocations.containsKey(tableName)) {
            expectedBaselineFolder = this.metadataTableLocations.get(tableName);
        }
        if (this.isMetadataTablePresentAtLocation(expectedFileName = LocalPath.combine(expectedLocation = null == expectedBaselineFolder || null == expectedBaselineFolder.path ? LocalPath.getParent(this.getFilename()) : expectedBaselineFolder.path, tableName))) {
            return expectedFileName;
        }
        for (BaselineFolder eachBaselineFolder : this.baselineFolders) {
            String potentialFileName;
            if (null == eachBaselineFolder.path || !this.isMetadataTablePresentAtLocation(potentialFileName = LocalPath.combine(eachBaselineFolder.path, tableName))) continue;
            this.metadataTableLocations.put(tableName, eachBaselineFolder);
            this.setDirty(true);
            return potentialFileName;
        }
        if (null != expectedBaselineFolder && null != expectedBaselineFolder.path && this.isMetadataTablePresentAtLocation(programDataLocationFileName = LocalPath.combine(this.workspace.getLocalMetadataDirectory(), tableName))) {
            this.metadataTableLocations.put(tableName, null);
            this.setDirty(true);
            return programDataLocationFileName;
        }
        BaselineFolder selectedBaselineFolder = null;
        for (BaselineFolder baselineFolder : this.baselineFolders) {
            if (baselineFolder.path == null || baselineFolder.state != BaselineFolderState.VALID) continue;
            selectedBaselineFolder = baselineFolder;
            break;
        }
        if (null != selectedBaselineFolder) {
            BaselineFolder currentMetadataTableFolder = this.metadataTableLocations.get(tableName);
            if (currentMetadataTableFolder == null || currentMetadataTableFolder != selectedBaselineFolder) {
                this.metadataTableLocations.put(tableName, selectedBaselineFolder);
                this.setDirty(true);
            }
            String path = selectedBaselineFolder.path;
            BaselineFolder.ensureLocalMetadataDirectoryExists(this.workspace, path);
            return LocalPath.combine(path, tableName);
        }
        if (!this.metadataTableLocations.containsKey(tableName) || this.metadataTableLocations.get(tableName) != null) {
            this.metadataTableLocations.put(tableName, null);
            this.setDirty(true);
        }
        BaselineFolder.ensureLocalMetadataDirectoryExists(this.workspace);
        return LocalPath.combine(this.workspace.getLocalMetadataDirectory(), tableName);
    }

    public void deleteBaseline(byte[] baselineFileGuid) {
        BaselineFolderCollection.deleteBaseline(this.workspace, this.baselineFolders, baselineFileGuid);
    }

    public void updateBaselineLocation(byte[] baselineFileGuid, String currentLocalItem) {
        BaselineFolderCollection.updateBaselineLocation(this.workspace, this.baselineFolders, baselineFileGuid, currentLocalItem);
    }

    public void copyBaselineToTarget(byte[] baselineFileGuid, String targetLocalItem, long baselineFileLength, byte[] baselineHashValue, boolean symlink) {
        BaselineFolderCollection.copyBaselineToTarget(this.workspace, this.baselineFolders, baselineFileGuid, targetLocalItem, baselineFileLength, baselineHashValue, symlink);
    }

    public void removeBaselineFolder(BaselineFolder baselineFolder) {
        Check.notNull(baselineFolder, "baselineFolder");
        Check.notNullOrEmpty(baselineFolder.path, "baselineFolder.Path");
        if (!this.baselineFolders.contains(baselineFolder)) {
            return;
        }
        BaselineFolder newBaselineFolder = null;
        for (BaselineFolder bf : this.baselineFolders) {
            if (null == bf.path || BaselineFolderState.VALID != bf.state || baselineFolder == bf) continue;
            if (LocalPath.equals(baselineFolder.partition, bf.partition)) {
                newBaselineFolder = bf;
                break;
            }
            if (null != newBaselineFolder) continue;
            newBaselineFolder = bf;
        }
        this.invalidateBaselineFolderCache();
        if (this.moveBaselineFolderStructure(baselineFolder.path, newBaselineFolder)) {
            try {
                FileHelpers.deleteDirectory(baselineFolder.path);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
            this.baselineFolders.remove(baselineFolder);
        } else {
            baselineFolder.state = BaselineFolderState.STALE;
        }
        this.setDirty(true);
    }

    private boolean moveBaselineFolderStructure(String rootBaselineFolderPath, BaselineFolder targetBaselineFolder) {
        String targetBaselineFolderPath;
        if (!new File(rootBaselineFolderPath).exists()) {
            return true;
        }
        boolean successfullyCleared = true;
        if (null != targetBaselineFolder) {
            targetBaselineFolderPath = targetBaselineFolder.getPath();
            BaselineFolder.ensureBaselineDirectoryExists(this.workspace, targetBaselineFolder.getPath());
        } else {
            targetBaselineFolderPath = this.workspace.getLocalMetadataDirectory();
            BaselineFolder.ensureLocalMetadataDirectoryExists(this.workspace);
        }
        BaselineFolder.createBaselineFolderStructure(targetBaselineFolderPath);
        for (EnumeratedLocalItem localItem : new LocalItemEnumerable(rootBaselineFolderPath, true, true, null)) {
            String metadataTablePath;
            if (localItem.isDirectory()) continue;
            String extension = LocalPath.getFileExtension(localItem.getFullPath());
            if (extension == null) {
                extension = "";
            }
            if (extension.equalsIgnoreCase(BaselineFolder.getGzipExtension()) || extension.equalsIgnoreCase(BaselineFolder.getRawExtension())) {
                String relativePath = LocalPath.makeRelative(localItem.getFullPath(), rootBaselineFolderPath);
                String newPath = LocalPath.combine(targetBaselineFolderPath, relativePath);
                try {
                    LocalWorkspaceProperties.rename(localItem.getFullPath(), newPath);
                    continue;
                }
                catch (Exception e) {
                    throw new VersionControlException(e);
                }
            }
            if (!extension.equalsIgnoreCase(".tf1") && !extension.equalsIgnoreCase(".tf2") || this.moveMetadataTable(metadataTablePath = localItem.getFullPath().substring(0, localItem.getFullPath().length() - extension.length()), targetBaselineFolder)) continue;
            successfullyCleared = false;
        }
        return successfullyCleared;
    }

    private boolean moveMetadataTable(String metadataTablePath, BaselineFolder targetBaselineFolder) {
        Check.isTrue(LocalWorkspaceTransaction.getCurrent().getOpenedTables().contains(Tables.WORKSPACE_PROPERTIES), "LocalWorkspaceTransaction.getCurrent().getOpenedTables().contains(Tables.WORKSPACE_PROPERTIES)");
        if (LocalPath.equals(metadataTablePath, this.getFilename())) {
            return false;
        }
        this.invalidateBaselineFolderCache();
        String slotOnePath = LocalWorkspaceProperties.getSlotOnePath(metadataTablePath);
        String slotTwoPath = LocalWorkspaceProperties.getSlotTwoPath(metadataTablePath);
        String metadataTableName = LocalPath.getFileName(metadataTablePath);
        String targetMetadataTablePath = LocalPath.combine(targetBaselineFolder != null ? targetBaselineFolder.path : this.workspace.getLocalMetadataDirectory(), metadataTableName);
        String targetSlotOnePath = LocalWorkspaceProperties.getSlotOnePath(targetMetadataTablePath);
        String targetSlotTwoPath = LocalWorkspaceProperties.getSlotTwoPath(targetMetadataTablePath);
        BaselineFolder currentBaselineFolder = this.metadataTableLocations.get(metadataTableName);
        try {
            this.setDirty(true);
            this.metadataTableLocations.put(metadataTableName, targetBaselineFolder);
            if (new File(slotOnePath).exists()) {
                LocalWorkspaceProperties.rename(slotOnePath, targetSlotOnePath);
                FileSystemAttributes attributes = FileSystemUtils.getInstance().getAttributes(targetSlotOnePath);
                attributes.setNotContentIndexed(true);
                FileSystemUtils.getInstance().setAttributes(targetSlotOnePath, attributes);
            } else if (new File(slotTwoPath).exists()) {
                LocalWorkspaceProperties.rename(slotTwoPath, targetSlotTwoPath);
                FileSystemAttributes attributes = FileSystemUtils.getInstance().getAttributes(targetSlotTwoPath);
                attributes.setNotContentIndexed(true);
                FileSystemUtils.getInstance().setAttributes(targetSlotTwoPath, attributes);
            }
        }
        catch (Throwable t) {
            this.metadataTableLocations.put(metadataTableName, currentBaselineFolder);
            throw new VersionControlException(t);
        }
        this.setDirty(true);
        return true;
    }

    public void applyAceToWorkingFolders(final String sidString, final boolean addOrRemove) {
        ArrayList<String> foldersToReceiveAce = new ArrayList<String>(this.workingFolders.size());
        for (WorkingFolder workingFolder : this.workingFolders) {
            String path = workingFolder.getLocalItem();
            if (path == null) continue;
            foldersToReceiveAce.add(new File(path).getAbsolutePath());
        }
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            for (String folderToReceiveAce : foldersToReceiveAce) {
                this.applyAceToFileOrFolder(folderToReceiveAce, sidString, addOrRemove);
            }
        } else {
            FileSystemWalker walker = new FileSystemWalker(this.workspace, foldersToReceiveAce.toArray(new String[foldersToReceiveAce.size()]), true, true, true, true);
            walker.walk(new FileSystemWalker.FileSystemVisitor(){

                @Override
                public void visit(String path) {
                    LocalWorkspaceProperties.this.applyAceToFileOrFolder(path, sidString, addOrRemove);
                }
            });
        }
    }

    public void applyAceToBaselineFolders(final String sidString, final boolean addOrRemove) {
        BaselineFolder.ensureLocalMetadataDirectoryExists(this.workspace);
        ArrayList<File> foldersToReceiveAce = new ArrayList<File>(this.baselineFolders.size() + 1);
        foldersToReceiveAce.add(new File(this.workspace.getLocalMetadataDirectory()));
        for (BaselineFolder baselineFolder : this.baselineFolders) {
            foldersToReceiveAce.add(new File(baselineFolder.getPath()));
        }
        for (int i = 0; i < foldersToReceiveAce.size(); ++i) {
            File folderToReceiveAce = (File)foldersToReceiveAce.get(i);
            this.applyAceToFileOrFolder(folderToReceiveAce.getAbsolutePath(), sidString, addOrRemove);
            if (Platform.isCurrentPlatform(Platform.WINDOWS)) continue;
            File[] subFolders = folderToReceiveAce.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    LocalWorkspaceProperties.this.applyAceToFileOrFolder(file.getAbsolutePath(), sidString, addOrRemove);
                    return false;
                }
            });
            foldersToReceiveAce.addAll(Arrays.asList(subFolders));
        }
    }

    public void applyAceToFileOrFolder(String path, String sidString, boolean addOrRemove) {
        Check.notNullOrEmpty(path, "path");
        try {
            File file = new File(path);
            if (file.exists()) {
                if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
                    if (addOrRemove) {
                        FileSystemUtils.getInstance().grantInheritableFullControl(file.getAbsolutePath(), sidString, null);
                    } else {
                        FileSystemUtils.getInstance().removeExplicitAllowEntries(file.getAbsolutePath(), sidString);
                    }
                } else {
                    FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(file);
                    if (attrs.isDirectory()) {
                        attrs.setExecutable(true);
                    }
                    attrs.setPublicWritable(addOrRemove);
                    FileSystemUtils.getInstance().setAttributes(file, attrs);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("Error applying access control rules to {0}", path), (Throwable)e);
        }
    }

    public void applyPermissionsProfileToBaselineFolders(WorkspacePermissionProfile profile) {
        String usersSIDString;
        String string = usersSIDString = Platform.isCurrentPlatform(Platform.WINDOWS) ? PlatformMiscUtils.getInstance().getWellKnownSID(27, null) : null;
        if (profile.getName().equals("Public") || profile.getName().equals("PublicLimited")) {
            this.applyAceToBaselineFolders(usersSIDString, true);
        } else if (profile.getName().equals("Private")) {
            this.applyAceToBaselineFolders(usersSIDString, false);
        }
    }

    public void applyPermissionsProfileToWorkingFolders(WorkspacePermissionProfile profile) {
        String usersSIDString;
        String string = usersSIDString = Platform.isCurrentPlatform(Platform.WINDOWS) ? PlatformMiscUtils.getInstance().getWellKnownSID(27, null) : null;
        if (profile.getName().equals("Public") || profile.getName().equals("PublicLimited")) {
            this.applyAceToWorkingFolders(usersSIDString, true);
        } else if (profile.getName().equals("Private")) {
            this.applyAceToWorkingFolders(usersSIDString, false);
        }
    }

    public void doBaselineFolderMaintenance() {
        WorkingFolder[] workingFolders = this.getWorkingFolders();
        HashMap<String, ArrayList<String>> partitions = new HashMap<String, ArrayList<String>>();
        for (String workspaceRoot : WorkingFolder.getWorkspaceRoots(workingFolders)) {
            String partition = BaselineFolder.getPartitionForPath(workspaceRoot);
            ArrayList<String> partitionRoots = (ArrayList<String>)partitions.get(partition);
            if (partitionRoots == null) {
                partitionRoots = new ArrayList<String>();
                partitions.put(partition, partitionRoots);
            }
            partitionRoots.add(workspaceRoot);
        }
        HashMap<String, ArrayList<BaselineFolder>> baselineMap = new HashMap<String, ArrayList<BaselineFolder>>();
        for (BaselineFolder bf : this.baselineFolders) {
            ArrayList<BaselineFolder> partitionFolders;
            if (!partitions.containsKey(bf.partition)) {
                this.setDirty(true);
                this.invalidateBaselineFolderCache();
                bf.state = BaselineFolderState.STALE;
            }
            if ((partitionFolders = (ArrayList<BaselineFolder>)baselineMap.get(bf.partition)) == null) {
                partitionFolders = new ArrayList<BaselineFolder>();
                baselineMap.put(bf.partition, partitionFolders);
            }
            partitionFolders.add(bf);
        }
        ArrayList<String> partitionsNeedingBaselineFolders = new ArrayList<String>();
        for (String key : partitions.keySet()) {
            List extantBaselineFoldersOnPartition = (List)baselineMap.get(key);
            if (extantBaselineFoldersOnPartition == null) {
                partitionsNeedingBaselineFolders.add(key);
                continue;
            }
            BaselineFolder extantValidBf = null;
            for (BaselineFolder baselineFolder : extantBaselineFoldersOnPartition) {
                if (baselineFolder.state != BaselineFolderState.VALID) continue;
                extantValidBf = baselineFolder;
                break;
            }
            if (null == extantValidBf) continue;
            String baselineFolderParent = LocalPath.getParent(extantValidBf.path);
            List partitionValue = (List)partitions.get(key);
            if (partitionValue.contains(baselineFolderParent)) continue;
            BaselineFolder staleBf = null;
            for (BaselineFolder baselineFolder : extantBaselineFoldersOnPartition) {
                if (baselineFolder.state != BaselineFolderState.STALE || !partitionValue.contains(LocalPath.getParent(baselineFolder.path))) continue;
                staleBf = baselineFolder;
                break;
            }
            if (null != staleBf) {
                this.setDirty(true);
                this.invalidateBaselineFolderCache();
                staleBf.state = BaselineFolderState.VALID;
            } else {
                partitionsNeedingBaselineFolders.add(key);
            }
            this.setDirty(true);
            this.invalidateBaselineFolderCache();
            extantValidBf.state = BaselineFolderState.STALE;
        }
        for (String partition : partitionsNeedingBaselineFolders) {
            String partitionRoot;
            List partitionRoots = (List)partitions.get(partition);
            BaselineFolder baselineFolder = null;
            Iterator i$ = partitionRoots.iterator();
            while (i$.hasNext() && null == (baselineFolder = BaselineFolder.create(this.workspace, partitionRoot = (String)i$.next()))) {
            }
            if (null == baselineFolder) continue;
            if (0 == this.baselineFolders.size()) {
                this.metadataTableLocations.put("localversion", baselineFolder);
                this.metadataTableLocations.put("pendingchanges", baselineFolder);
            }
            this.baselineFolders.add(baselineFolder);
            this.invalidateBaselineFolderCache();
            this.setDirty(true);
        }
        ArrayList<BaselineFolder> staleFolders = new ArrayList<BaselineFolder>();
        for (BaselineFolder folder : this.baselineFolders) {
            if (folder.state != BaselineFolderState.STALE) continue;
            staleFolders.add(folder);
        }
        for (BaselineFolder staleBf : staleFolders) {
            this.removeBaselineFolder(staleBf);
        }
        BaselineFolder validBaselineFolder = null;
        for (BaselineFolder baselineFolder : this.baselineFolders) {
            if (baselineFolder.state != BaselineFolderState.VALID) continue;
            validBaselineFolder = baselineFolder;
            break;
        }
        if (null != validBaselineFolder) {
            this.moveBaselineFolderStructure(this.workspace.getLocalMetadataDirectory(), validBaselineFolder);
        }
        this.workspace.getWorkspaceWatcher().ensureWatching();
    }

    public void invalidateBaselineFolderCache() {
        WorkspaceLock wLock = LocalWorkspaceTransaction.getCurrent().getWorkspaceLock();
        BaselineFolderCollection baselineFolders = wLock.getBaselineFolders();
        if (null != baselineFolders && 0 == this.baselineFoldersWriteLockToken) {
            this.baselineFoldersWriteLockToken = baselineFolders.lockForWrite();
        }
    }

    private boolean isMetadataTablePresentAtLocation(String fileName) {
        Check.notNullOrEmpty(fileName, "fileName");
        boolean presentAtLocation = false;
        try {
            Check.isTrue(LocalWorkspaceTransaction.getCurrent().getOpenedTables().contains(Tables.WORKSPACE_PROPERTIES), "LocalWorkspaceTransaction.getCurrent().getOpenedTables().contains(Tables.WORKSPACE_PROPERTIES)");
            if (new File(LocalWorkspaceProperties.getSlotOnePath(fileName)).exists() || new File(LocalWorkspaceProperties.getSlotTwoPath(fileName)).exists()) {
                presentAtLocation = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return presentAtLocation;
    }

    public WorkingFolder[] getWorkingFolders() {
        return this.workingFolders.toArray(new WorkingFolder[this.workingFolders.size()]);
    }

    public void setWorkingFolders(WorkingFolder[] workingFolders) {
        WorkingFolder[] newWorkingFolders;
        this.workingFolders = new ArrayList<WorkingFolder>(workingFolders.length);
        for (WorkingFolder workingFolder : newWorkingFolders = WorkingFolder.clone(workingFolders)) {
            this.workingFolders.add(workingFolder);
        }
        this.setDirty(true);
    }

    public int getNewProjectRevisionId() {
        return this.newProjectRevisionId;
    }

    public void setNewProjectRevisionId(int newProjectRevisionId) {
        if (this.newProjectRevisionId != newProjectRevisionId) {
            this.setDirty(true);
            this.newProjectRevisionId = newProjectRevisionId;
        }
    }

    private static void rename(String source, String target) throws FileNotFoundException, IOException {
        try {
            FileHelpers.rename(source, target);
        }
        catch (IOException e) {
            FileCopyHelper.copy(source, target);
            File fSource = new File(source);
            fSource.delete();
        }
    }
}

