/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ChangeRequestValidationException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.FileEncodingDetector;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.text.MessageFormat;
import ms.tfs.versioncontrol.clientservices._03._ChangeRequest;
import ms.tfs.versioncontrol.clientservices._03._ItemType;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;

public class ChangeRequest
extends WebServiceObjectWrapper {
    public ChangeRequest(_ChangeRequest request) throws ChangeRequestValidationException {
        this(request, true);
    }

    public ChangeRequest(ItemSpec item, VersionSpec version, RequestType requestType, ItemType itemType, int encoding, LockLevel lockLevel, int deletionID, String targetItem, boolean detectTargetItemType) throws ChangeRequestValidationException {
        this(new _ChangeRequest(requestType.getWebServiceObject(), deletionID, encoding, itemType == null ? null : itemType.getWebServiceObject(), lockLevel.getWebServiceObject(), targetItem, _ItemType.Any, item.getWebServiceObject(), version != null ? version.getWebServiceObject() : null, null), detectTargetItemType);
    }

    private ChangeRequest(_ChangeRequest request, boolean detectTargetItemType) throws ChangeRequestValidationException {
        super(request);
        if (this.getTargetItem() != null && !ServerPath.isServerPath(this.getTargetItem())) {
            this.setTargetItem(LocalPath.canonicalize(this.getTargetItem()));
        }
        Check.isTrue(this.getRequestType() != RequestType.NONE, "getRequestType() != RequestType.NONE");
        if (detectTargetItemType && (this.getRequestType() == RequestType.BRANCH || this.getRequestType() == RequestType.RENAME || this.getRequestType() == RequestType.UNDELETE)) {
            String targetItem = this.getTargetItem();
            boolean directoryAtTarget = false;
            if (targetItem != null && !Wildcard.isWildcard(targetItem) && !ServerPath.isServerPath(targetItem)) {
                File targetItemFile = new File(targetItem);
                FileSystemAttributes targetItemAttributes = FileSystemUtils.getInstance().getAttributes(targetItem);
                if (targetItemFile.exists()) {
                    boolean caseChangingRename;
                    if (targetItemFile.isDirectory()) {
                        directoryAtTarget = true;
                        if (!ServerPath.isServerPath(this.getItemSpec().getItem()) && !Wildcard.isWildcard(this.getItemSpec().getItem())) {
                            targetItem = LocalPath.combine(targetItem, LocalPath.getLastComponent(this.getItemSpec().getItem()));
                            targetItemFile = new File(targetItem);
                        }
                    }
                    boolean bl = caseChangingRename = !ServerPath.isServerPath(this.getItemSpec().getItem()) && !LocalPath.isWildcard(this.getItemSpec().getItem()) && this.getItemSpec().getItem().equalsIgnoreCase(targetItem) && !this.getItemSpec().getItem().equals(targetItem);
                    if (!caseChangingRename && targetItemFile.exists() && targetItemFile.isFile() && !targetItemAttributes.isReadOnly()) {
                        throw new ChangeRequestValidationException(MessageFormat.format(Messages.getString("ChangeRequest.AWritableFileExistsAtThePathWhichIsInTheWayOfTheChangeRequestForItemFormat"), targetItem, this.getItemSpec().getItem()));
                    }
                }
            }
            if (directoryAtTarget) {
                this.setTargetItemType(ItemType.FOLDER);
            }
        }
    }

    public _ChangeRequest getWebServiceObject() {
        return (_ChangeRequest)this.webServiceObject;
    }

    public int getDeletionID() {
        return this.getWebServiceObject().getDid();
    }

    public int getEncoding() {
        return this.getWebServiceObject().getEnc();
    }

    public ItemSpec getItemSpec() {
        return new ItemSpec(this.getWebServiceObject().getItem());
    }

    public LockLevel getLockLevel() {
        return LockLevel.fromWebServiceObject(this.getWebServiceObject().getLock());
    }

    public RequestType getRequestType() {
        return RequestType.fromWebServiceObject(this.getWebServiceObject().getReq());
    }

    public String getTargetItem() {
        String target = this.getWebServiceObject().getTarget();
        if (target != null && !ServerPath.isServerPath(target)) {
            return LocalPath.tfsToNative(target);
        }
        return this.getWebServiceObject().getTarget();
    }

    public ItemType getTargetItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getTargettype());
    }

    public ItemType getItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getType());
    }

    public VersionSpec getVersionSpec() {
        return VersionSpec.fromWebServiceObject(this.getWebServiceObject().getVspec());
    }

    public void setDeletionID(int did) {
        this.getWebServiceObject().setDid(did);
    }

    public void setEncoding(int enc) {
        this.getWebServiceObject().setEnc(enc);
    }

    public void setItemSpec(ItemSpec item) {
        this.getWebServiceObject().setItem(item.getWebServiceObject());
    }

    public void setLockLevel(LockLevel lock) {
        this.getWebServiceObject().setLock(lock.getWebServiceObject());
    }

    public void setRequestType(RequestType req) {
        this.getWebServiceObject().setReq(req.getWebServiceObject());
    }

    public void setTargetItem(String target) {
        if (!ServerPath.isServerPath(target)) {
            target = LocalPath.nativeToTFS(target);
        }
        this.getWebServiceObject().setTarget(target);
    }

    public void setTargetItemType(ItemType targettype) {
        this.getWebServiceObject().setTargettype(targettype.getWebServiceObject());
    }

    public void setItemType(ItemType type) {
        this.getWebServiceObject().setType(type.getWebServiceObject());
    }

    public void setVersionSpec(VersionSpec vspec) {
        this.getWebServiceObject().setVspec(vspec.getWebServiceObject());
    }

    public PropertyValue[] getProperties() {
        return (PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getProperties());
    }

    public void setProperties(PropertyValue[] properties) {
        this.getWebServiceObject().setProperties((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, properties));
    }

    public static ChangeRequest[] fromStrings(String[] paths, RequestType requestType, LockLevel[] lockLevel, RecursionType recursionType, FileEncoding[] fileEncoding) throws ChangeRequestValidationException {
        Check.notNull(paths, "paths");
        ItemSpec[] specs = new ItemSpec[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!ServerPath.isServerPath(path)) {
                path = LocalPath.canonicalize(path);
            }
            specs[i] = new ItemSpec(path, recursionType);
        }
        return ChangeRequest.fromSpecs(specs, requestType, lockLevel, fileEncoding);
    }

    public static ChangeRequest[] fromSpecs(ItemSpec[] specs, RequestType requestType, LockLevel[] lockLevel, FileEncoding[] fileEncoding) throws ChangeRequestValidationException {
        Check.notNull(specs, "specs");
        ChangeRequest[] ret = new ChangeRequest[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            ItemSpec itemSpec = specs[i];
            String path = itemSpec.getItem();
            int codePage = -2;
            if (fileEncoding != null && fileEncoding[i] != null) {
                try {
                    codePage = FileEncodingDetector.detectEncoding(path, fileEncoding[i]).getCodePage();
                }
                catch (TECoreException e) {
                    throw new ChangeRequestValidationException(MessageFormat.format(Messages.getString("ChangeRequest.ItemWasSkippedBecauseEncodingDetectionFailedFormat"), path, e.getMessage()));
                }
            }
            ret[i] = new ChangeRequest(itemSpec, null, requestType, ItemType.ANY, codePage, lockLevel[i], itemSpec.getDeletionID(), null, true);
        }
        return ret;
    }

    @Override
    public String toString() {
        _ChangeRequest changeRequest = this.getWebServiceObject();
        return ChangeRequest.class.getName() + " " + changeRequest.getItem().getItem() + ":" + (changeRequest.getItem().getRecurse() != null ? changeRequest.getItem().getRecurse().getName() : "null") + " " + changeRequest.getReq().getName() + (changeRequest.getTarget() != null ? " -> (" + changeRequest.getTarget() + ")" : "");
    }
}

