/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.sparsetree;

import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumParentsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumSubTreeOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumeratedSparseTreeNode;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.KeyNotFoundException;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.KeyValuePair;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTreeAdditionalData;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTreeNode;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTreeRange;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.NotYetImplementedException;
import com.microsoft.tfs.util.StringUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class SparseTree<T> {
    private SparseTreeNode<T> rootNode;
    private Comparator<String> tokenComparison;
    private char tokenSeparator;
    private char[] tokenSeparatorArray;
    private int fixedElementLength;
    private int count;
    private WeakReference<SparseTreeNode<T>> ts_findClosestNodeCache;
    private static final String[] EMPTY_STRING_ARRAY = new String[]{""};

    public SparseTree(char tokenSeparator) {
        this(tokenSeparator, -1, String.CASE_INSENSITIVE_ORDER);
    }

    public SparseTree(int fixedElementLength) {
        this('\u0000', fixedElementLength, String.CASE_INSENSITIVE_ORDER);
    }

    public SparseTree(Comparator<String> tokenComparison) {
        this('\u0000', tokenComparison);
    }

    public SparseTree(char tokenSeparator, Comparator<String> tokenComparison) {
        this(tokenSeparator, -1, tokenComparison);
    }

    public SparseTree(int fixedElementLength, Comparator<String> tokenComparison) {
        this('\u0000', fixedElementLength, tokenComparison);
    }

    public SparseTree(char tokenSeparator, int fixedElementLength, Comparator<String> tokenComparison) {
        Check.isTrue(tokenSeparator != '\u0000' || fixedElementLength > 0, "The token separator cannot be null or element length has to be greater than 0");
        this.clear();
        this.tokenComparison = tokenComparison;
        this.tokenSeparator = tokenSeparator;
        if (this.tokenSeparator != '\u0000') {
            this.tokenSeparatorArray = new char[]{this.tokenSeparator};
        }
        this.fixedElementLength = fixedElementLength;
    }

    public void add(String token, T referencedObject) {
        this.add(token, referencedObject, false);
    }

    public void add(String token, T referencedObject, boolean overwrite) {
        Check.notNull(token, "token");
        token = this.canonicalizeToken(token);
        String[] tokenElements = this.splitToken(token);
        AtomicReference<SparseTreeNode<T>> node = new AtomicReference<SparseTreeNode<T>>();
        boolean exactMatch = this.findClosestNode(token, tokenElements, this.rootNode, node);
        SparseTreeNode<T> closestNode = node.get();
        if (!exactMatch) {
            SparseTreeNode<T> newNode = new SparseTreeNode<T>(token, tokenElements, referencedObject);
            if (closestNode == null) {
                closestNode = this.rootNode;
            }
            this.addNode(closestNode, newNode);
        } else if (overwrite) {
            closestNode.referencedObject = referencedObject;
        } else {
            throw new IllegalArgumentException("A node with the same token already exists in the SparseTree.");
        }
    }

    public void modifyInPlace(String token, ModifyInPlaceCallback<T> callback, Object param) {
        Check.notNull(token, "token");
        token = this.canonicalizeToken(token);
        Object referencedObject = null;
        String[] tokenElements = this.splitToken(token);
        AtomicReference<SparseTreeNode<T>> node = new AtomicReference<SparseTreeNode<T>>();
        boolean exactMatch = this.findClosestNode(token, tokenElements, this.rootNode, node);
        SparseTreeNode<T> closestNode = node.get();
        if (exactMatch) {
            referencedObject = closestNode.referencedObject;
        }
        referencedObject = callback.invoke(token, referencedObject, param);
        if (!exactMatch) {
            SparseTreeNode<Object> newNode = new SparseTreeNode<Object>(token, tokenElements, referencedObject);
            if (closestNode == null) {
                closestNode = this.rootNode;
            }
            this.addNode(closestNode, newNode);
        } else {
            closestNode.referencedObject = referencedObject;
        }
    }

    public boolean remove(String token, boolean removeChildren) {
        SparseTreeRange range;
        Check.notNull(token, "token");
        token = this.canonicalizeToken(token);
        String[] tokenElements = this.splitToken(token);
        AtomicReference<SparseTreeNode<T>> node = new AtomicReference<SparseTreeNode<T>>();
        boolean isSpecifiedToken = this.findClosestNode(token, tokenElements, this.rootNode, node);
        SparseTreeNode<T> nodeToInvestigate = node.get();
        if (isSpecifiedToken) {
            return this.removeNode(nodeToInvestigate, removeChildren);
        }
        if (removeChildren && (range = this.findRange(tokenElements, tokenElements.length, 0, nodeToInvestigate)).getStart() >= 0) {
            int removedCount = 0;
            for (int i = range.getStart(); i <= range.getEnd(); ++i) {
                nodeToInvestigate.children.get((int)i).parent = null;
                removedCount += this.countNode(nodeToInvestigate.children.get(i));
            }
            int start = range.getStart();
            int count = range.getEnd() - range.getStart() + 1;
            for (int i = 0; i < count; ++i) {
                nodeToInvestigate.children.remove(start);
            }
            count -= removedCount;
            return true;
        }
        return false;
    }

    public T get(String token) {
        return this.get(token, true);
    }

    public T get(String token, boolean exactMatch) {
        if (token == null) {
            throw new IllegalArgumentException("token");
        }
        token = this.canonicalizeToken(token);
        String[] tokenElements = this.splitToken(token);
        AtomicReference<SparseTreeNode<T>> closestNode = new AtomicReference<SparseTreeNode<T>>();
        boolean found = this.findClosestNode(token, tokenElements, this.rootNode, closestNode);
        SparseTreeNode<T> node = closestNode.get();
        if (!found) {
            if (exactMatch || node == this.rootNode) {
                return null;
            }
            return (T)node.referencedObject;
        }
        return (T)node.referencedObject;
    }

    public void set(String token, T referencedObject) {
        this.add(token, referencedObject, true);
    }

    public void clear() {
        this.rootNode = new SparseTreeNode<Object>("", new String[0], null);
        this.count = 0;
    }

    public KeyValuePair<String, T>[] EnumChildren(String token) throws KeyNotFoundException {
        SparseTreeNode<T> node = this.rootNode;
        if (null != (token = this.canonicalizeToken(token))) {
            String[] tokenElements = this.splitToken(token);
            AtomicReference<SparseTreeNode<T>> closestNode = new AtomicReference<SparseTreeNode<T>>();
            boolean found = this.findClosestNode(token, tokenElements, this.rootNode, closestNode);
            node = closestNode.get();
            if (!found) {
                throw new KeyNotFoundException();
            }
        }
        ArrayList toReturn = new ArrayList(node.getChildCount());
        if (node.getChildCount() > 0) {
            for (int i = 0; i < node.children.size(); ++i) {
                toReturn.add(new KeyValuePair(node.children.get((int)i).token, node.children.get((int)i).referencedObject));
            }
        }
        return (KeyValuePair[])toReturn.toArray();
    }

    public boolean EnumParents(String token, EnumNodeCallback<T> callback) {
        return this.EnumParents(token, callback, EnumParentsOptions.NONE, null, null);
    }

    public boolean EnumParents(String token, EnumNodeCallback<T> callback, EnumParentsOptions options, SparseTreeAdditionalData additionalData, Object param) {
        options = options.remove(EnumParentsOptions.INCLUDE_ADDITIONAL_DATA);
        if (null != additionalData) {
            options = options.combine(EnumParentsOptions.INCLUDE_ADDITIONAL_DATA);
        }
        for (EnumeratedSparseTreeNode<T> node : this.EnumParents(token, options)) {
            if (null != additionalData) {
                additionalData.hasChildren = node.hasChildren;
                additionalData.noChildrenBelow = node.noChildrenBelow;
            }
            if (!callback.invoke(node.token, node.referencedObject, additionalData, param)) continue;
            return true;
        }
        return false;
    }

    public Iterable<EnumeratedSparseTreeNode<T>> EnumParents(String token, EnumParentsOptions options) {
        return new EnumParentsEnumerable(this, token, options);
    }

    public Iterable<T> EnumParentsReferencedObjects(String token, EnumParentsOptions options) {
        return new ReferencedObjectEnumerable(this.EnumParents(token, options));
    }

    public boolean EnumSubTree(String token, EnumNodeCallback<T> callback) {
        return this.EnumSubTree(token, callback, EnumSubTreeOptions.NONE, Integer.MAX_VALUE, null, null);
    }

    public boolean EnumSubTree(String token, EnumNodeCallback<T> callback, EnumSubTreeOptions options, int depth, SparseTreeAdditionalData additionalData, Object param) {
        options = options.remove(EnumSubTreeOptions.INCLUDE_ADDITIONAL_DATA);
        if (null != additionalData) {
            options = options.combine(EnumSubTreeOptions.INCLUDE_ADDITIONAL_DATA);
        }
        for (EnumeratedSparseTreeNode<T> node : this.EnumSubTree(token, options, depth)) {
            if (null != additionalData) {
                additionalData.hasChildren = node.hasChildren;
                additionalData.noChildrenBelow = node.noChildrenBelow;
            }
            if (!callback.invoke(node.token, node.referencedObject, additionalData, param)) continue;
            return true;
        }
        return false;
    }

    public Iterable<EnumeratedSparseTreeNode<T>> EnumSubTree(String token, EnumSubTreeOptions options, int depth) {
        return new EnumSubTreeEnumerable(this, token, options, depth);
    }

    public Iterable<T> EnumSubTreeReferencedObjects(String token, EnumSubTreeOptions options, int depth) {
        return new ReferencedObjectEnumerable(this.EnumSubTree(token, options, depth));
    }

    public Iterable<EnumeratedSparseTreeNode<T>> EnumRoots() {
        int size = this.rootNode.getChildCount();
        ArrayList<EnumeratedSparseTreeNode<T>> toReturn = new ArrayList<EnumeratedSparseTreeNode<T>>(size);
        for (int i = 0; i < size; ++i) {
            toReturn.add(new EnumeratedSparseTreeNode(this.rootNode.children.get((int)i).token, this.rootNode.children.get((int)i).referencedObject, this.rootNode.children.get(i).getChildCount() != 0, null));
        }
        return toReturn;
    }

    public Iterable<T> EnumRootsReferencedObjects() {
        int size = this.rootNode.getChildCount();
        ArrayList toReturn = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            toReturn.add(this.rootNode.children.get((int)i).referencedObject);
        }
        return toReturn;
    }

    private boolean isRooted(SparseTreeNode<T> node) {
        while (node.parent != null) {
            node = node.parent;
        }
        return node == this.rootNode;
    }

    private boolean findClosestNode(String token, String[] tokenElements, SparseTreeNode<T> nodeList, AtomicReference<SparseTreeNode<T>> closestNode) {
        int elementCount = 0;
        SparseTreeNode<T> cachedNode = this.getFindClosestNodeCache();
        if (null != cachedNode && null != cachedNode.parent && this.isSubItem(token, cachedNode.token) && this.isRooted(cachedNode)) {
            nodeList = cachedNode;
            elementCount = cachedNode.tokenElements.length;
            if (elementCount == tokenElements.length) {
                closestNode.set(cachedNode);
                return true;
            }
        }
        boolean result = this.findClosestNodeHelper(tokenElements, elementCount, nodeList, closestNode);
        this.setFindClosestNodeCache(closestNode.get());
        return result;
    }

    private boolean findClosestNodeHelper(String[] tokenElements, int elementIndex, SparseTreeNode<T> nodeList, AtomicReference<SparseTreeNode<T>> closestNode) {
        closestNode.set(nodeList);
        int startChildIndex = 0;
        int endChildIndex = nodeList.getChildCount() - 1;
        int midChildIndex = 0;
        while (startChildIndex <= endChildIndex) {
            int result;
            midChildIndex = startChildIndex + (endChildIndex - startChildIndex >> 1);
            SparseTreeNode childNode = nodeList.children.get(midChildIndex);
            int currentElementIndex = elementIndex;
            while ((result = this.tokenComparison.compare(tokenElements[currentElementIndex], childNode.tokenElements[currentElementIndex])) == 0) {
                if (currentElementIndex == tokenElements.length - 1 && childNode.tokenElements.length == tokenElements.length) {
                    closestNode.set(childNode);
                    return true;
                }
                if (childNode.tokenElements.length < tokenElements.length && currentElementIndex == childNode.tokenElements.length - 1) {
                    closestNode.set(childNode);
                    return this.findClosestNodeHelper(tokenElements, currentElementIndex + 1, childNode, closestNode);
                }
                if (++currentElementIndex != tokenElements.length) continue;
            }
            if (result == 0) {
                return false;
            }
            if (result < 0) {
                endChildIndex = midChildIndex - 1;
                continue;
            }
            startChildIndex = midChildIndex + 1;
        }
        return false;
    }

    private void addNode(SparseTreeNode<T> parentNode, SparseTreeNode<T> childNode) {
        int childCount = parentNode.getChildCount();
        this.reparentNode(parentNode, childNode);
        if (childCount == 0) {
            parentNode.children = new ArrayList();
            parentNode.children.add(childNode);
        } else {
            int insertIndex = this.compareByElements(childNode.tokenElements, parentNode.children.get((int)(childCount - 1)).tokenElements, parentNode.tokenElements.length, parentNode.children.get((int)(childCount - 1)).tokenElements.length - 1) > 0 ? childCount : ~this.findLocation(childNode.tokenElements, parentNode);
            if (insertIndex < childCount && 0 == this.compareByElements(childNode.tokenElements, parentNode.children.get((int)insertIndex).tokenElements, parentNode.tokenElements.length, childNode.tokenElements.length - 1)) {
                SparseTreeRange childrenRange = this.findRange(childNode.tokenElements, childNode.tokenElements.length, insertIndex, parentNode);
                childNode.children = new ArrayList(childrenRange.getEnd() - childrenRange.getStart() + 1);
                for (int i = childrenRange.getStart(); i <= childrenRange.getEnd(); ++i) {
                    this.reparentNode(childNode, parentNode.children.get(i));
                    childNode.children.add(parentNode.children.get(i));
                }
                int start = childrenRange.getStart();
                int count = childrenRange.getEnd() - childrenRange.getStart() + 1;
                for (int i = 0; i < count; ++i) {
                    parentNode.children.remove(start);
                }
            }
            parentNode.children.add(insertIndex, childNode);
        }
        ++this.count;
    }

    private boolean removeNode(SparseTreeNode<T> nodeToRemove, boolean removeChildren) {
        SparseTreeNode parent = nodeToRemove.parent;
        int removeIndex = this.findLocation(nodeToRemove.tokenElements, parent);
        if (removeIndex >= 0) {
            parent.children.remove(removeIndex);
            nodeToRemove.parent = null;
            if (!removeChildren) {
                if (nodeToRemove.getChildCount() > 0) {
                    int insertIndex = ~this.findLocation(nodeToRemove.children.get((int)0).tokenElements, parent);
                    for (int i = 0; i < nodeToRemove.children.size(); ++i) {
                        this.reparentNode(parent, nodeToRemove.children.get(i));
                    }
                    parent.children.addAll(insertIndex, nodeToRemove.children);
                }
                --this.count;
            } else {
                this.count -= this.countNode(nodeToRemove);
            }
        }
        return removeIndex >= 0;
    }

    private int countNode(SparseTreeNode<T> nodeToCount) {
        if (0 == nodeToCount.getChildCount()) {
            return 1;
        }
        int count = 1;
        Stack nodeStack = new Stack();
        nodeStack.push(nodeToCount);
        while (nodeStack.size() > 0) {
            SparseTreeNode currentNode = (SparseTreeNode)nodeStack.pop();
            if (currentNode.getChildCount() > 0) {
                for (SparseTreeNode childNode : currentNode.children) {
                    nodeStack.push(childNode);
                }
            }
            ++count;
        }
        return count;
    }

    private void reparentNode(SparseTreeNode<T> parentNode, SparseTreeNode<T> childNode) {
        childNode.parent = parentNode;
        for (int i = 0; i < parentNode.tokenElements.length; ++i) {
            childNode.tokenElements[i] = parentNode.tokenElements[i];
        }
    }

    private int findLocation(String[] tokenElements, SparseTreeNode<T> nodeToSearch) {
        int childCount = nodeToSearch.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int startIndex = 0;
        int midIndex = 0;
        int endIndex = childCount - 1;
        int result = 0;
        while (startIndex <= endIndex) {
            midIndex = startIndex + (endIndex - startIndex >> 1);
            result = this.compareByElements(tokenElements, nodeToSearch.children.get((int)midIndex).tokenElements, nodeToSearch.tokenElements.length, nodeToSearch.children.get((int)midIndex).tokenElements.length - 1);
            if (result == 0) {
                return midIndex;
            }
            if (result > 0) {
                startIndex = midIndex + 1;
                continue;
            }
            endIndex = midIndex - 1;
        }
        return ~startIndex;
    }

    private SparseTreeRange findRange(String[] tokenElements, int tokenElementsLength, int startIndex, SparseTreeNode<T> nodeToSearch) {
        int result;
        SparseTreeNode childNode;
        int midIndex;
        if (nodeToSearch.getChildCount() == 0) {
            return new SparseTreeRange(-1, -1);
        }
        SparseTreeRange toReturn = new SparseTreeRange();
        --startIndex;
        int endIndex = nodeToSearch.children.size();
        while (endIndex - startIndex > 1) {
            midIndex = startIndex + (endIndex - startIndex >> 1);
            childNode = nodeToSearch.children.get(midIndex);
            result = this.compareByElements(tokenElements, childNode.tokenElements, nodeToSearch.tokenElements.length, tokenElementsLength - 1);
            if (result > 0) {
                startIndex = midIndex;
                continue;
            }
            endIndex = midIndex;
        }
        if (endIndex == nodeToSearch.children.size() || this.compareByElements(tokenElements, nodeToSearch.children.get((int)endIndex).tokenElements, nodeToSearch.tokenElements.length, tokenElementsLength - 1) != 0) {
            toReturn.setStart(-1);
        } else {
            toReturn.setStart(endIndex);
        }
        if (toReturn.getStart() >= 0) {
            endIndex = nodeToSearch.children.size();
            startIndex = toReturn.getStart();
            while (endIndex - startIndex > 1) {
                midIndex = startIndex + (endIndex - startIndex >> 1);
                childNode = nodeToSearch.children.get(midIndex);
                result = this.compareByElements(tokenElements, childNode.tokenElements, nodeToSearch.tokenElements.length, tokenElementsLength - 1);
                if (result < 0) {
                    endIndex = midIndex;
                    continue;
                }
                startIndex = midIndex;
            }
            if (startIndex >= 0 && this.compareByElements(tokenElements, nodeToSearch.children.get((int)startIndex).tokenElements, nodeToSearch.tokenElements.length, tokenElementsLength - 1) != 0) {
                toReturn.setEnd(-1);
            } else {
                toReturn.setEnd(startIndex);
            }
        }
        return toReturn;
    }

    private int compareByElements(String[] tokenElements1, String[] tokenElements2, int tokenStartIndex, int tokenEndIndex) {
        int currentIndex;
        int lastIndex = tokenElements1.length > tokenElements2.length ? tokenElements2.length : tokenElements1.length;
        int n = lastIndex = tokenEndIndex > lastIndex ? lastIndex : ++tokenEndIndex;
        for (currentIndex = tokenStartIndex; currentIndex < lastIndex; ++currentIndex) {
            int ret = this.tokenComparison.compare(tokenElements1[currentIndex], tokenElements2[currentIndex]);
            if (ret == 0) continue;
            return ret;
        }
        if (currentIndex == tokenEndIndex) {
            return 0;
        }
        return tokenElements1.length - tokenElements2.length;
    }

    private String canonicalizeToken(String token) {
        if (null == token) {
            return null;
        }
        if (this.tokenSeparator != '\u0000') {
            return StringUtil.trimEnd(token, this.tokenSeparator);
        }
        if (this.fixedElementLength > 0) {
            if (token.length() == 0) {
                throw new IllegalArgumentException("Empty string tokens are not supported with a fixed element length.");
            }
            return token;
        }
        return null;
    }

    private String[] splitToken(String token) {
        if (this.tokenSeparator != '\u0000') {
            if (token.length() == 0) {
                return EMPTY_STRING_ARRAY;
            }
            return token.split(Pattern.quote(new String(this.tokenSeparatorArray)));
        }
        if (this.fixedElementLength > 0) {
            int numElements = token.length() / this.fixedElementLength;
            String[] elements = new String[numElements];
            for (int i = 0; i < numElements; ++i) {
                int startOffset = i * this.fixedElementLength;
                int endOffset = startOffset + this.fixedElementLength;
                elements[i] = token.substring(startOffset, endOffset);
            }
            return elements;
        }
        return null;
    }

    public boolean isSubItem(String item, String parent) {
        if (parent.length() > item.length()) {
            return false;
        }
        String itemPrefix = item.substring(0, parent.length());
        if (this.fixedElementLength > 0) {
            return this.tokenComparison.compare(parent, itemPrefix) == 0;
        }
        if (this.tokenSeparator != '\u0000') {
            return this.tokenComparison.compare(parent, itemPrefix) == 0 && (item.length() == parent.length() || parent.length() > 0 && parent.charAt(parent.length() - 1) == this.tokenSeparator || item.charAt(parent.length()) == this.tokenSeparator);
        }
        return false;
    }

    private void addTokenPart(StringBuilder builder, int tokenCountInBuilder, String tokenPart) {
        if (this.tokenSeparator != '\u0000') {
            if (tokenCountInBuilder > 0) {
                builder.append(this.tokenSeparator);
            }
            builder.append(tokenPart);
        } else if (this.fixedElementLength > 0) {
            builder.append(tokenPart);
        }
    }

    private int getCommonTokenCount(String[] xTokens, String[] yTokens, int startIndex) {
        int i;
        int length;
        int n = length = xTokens.length > yTokens.length ? yTokens.length : xTokens.length;
        if (startIndex > length - 1) {
            return 0;
        }
        for (i = startIndex; i < length && this.tokenComparison.compare(xTokens[i], yTokens[i]) == 0; ++i) {
        }
        return i - startIndex;
    }

    private StringBuilder getPartialTokenStringBuilder(StringBuilder toUse, String token, String[] tokenElements, int tokenCount) {
        if (null == toUse) {
            toUse = new StringBuilder(token.length());
        } else {
            toUse.ensureCapacity(token.length());
            toUse.setLength(0);
        }
        if (tokenCount == tokenElements.length) {
            toUse.append(token);
        } else if (this.tokenSeparator != '\u0000') {
            int length = 0;
            for (int i = 0; i < tokenCount; ++i) {
                length += tokenElements[i].length();
            }
            if (tokenCount > 1) {
                length += tokenCount - 1;
            }
            toUse.append(token.substring(0, length));
        } else if (this.fixedElementLength > 0) {
            toUse.append(token.substring(0, tokenCount * this.fixedElementLength));
        }
        return toUse;
    }

    public int getCount() {
        return this.count;
    }

    public char getTokenSeparator() {
        return this.tokenSeparator;
    }

    public int getFixedElementLength() {
        return this.fixedElementLength;
    }

    private SparseTreeNode<T> getFindClosestNodeCache() {
        if (null == this.ts_findClosestNodeCache) {
            return null;
        }
        return (SparseTreeNode)this.ts_findClosestNodeCache.get();
    }

    private void setFindClosestNodeCache(SparseTreeNode<T> value) {
        this.ts_findClosestNodeCache = new WeakReference<SparseTreeNode<SparseTreeNode<T>>>(value);
    }

    private class ReferencedObjectEnumerable<X>
    implements Iterable<X>,
    Iterator<X> {
        private final Iterator<EnumeratedSparseTreeNode<X>> iterator;

        public ReferencedObjectEnumerable(Iterable<EnumeratedSparseTreeNode<X>> iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public X next() {
            return this.iterator.next().referencedObject;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public Iterator<X> iterator() {
            return this;
        }
    }

    public class EnumSubTreeEnumerator
    implements Iterator<EnumeratedSparseTreeNode<T>> {
        private final SparseTree<T> sparseTree;
        private String token;
        private final EnumSubTreeOptions options;
        private final int depth;
        private EnumeratedSparseTreeNode<T> current;
        private Stack<SparseTreeNode<T>> nodeStack;
        private String[] tokenElements;
        private SparseTreeNode<T> currentNode;
        private int nextSparseTokenCount;
        private SparseTreeNode<T> prevChildNode;
        private StringBuilder sparseNodeBuffer;
        private State state;

        public EnumSubTreeEnumerator(SparseTree<T> sparseTree2, String token, EnumSubTreeOptions options, int depth) {
            this.sparseTree = sparseTree2;
            this.token = token;
            this.options = options;
            this.depth = depth;
            this.reset();
        }

        public boolean moveNext() {
            block0: while (true) {
                if (State.InitialNode == this.state) {
                    this.state = State.Normal;
                    return null != this.current;
                }
                if (State.SparseNodes == this.state) {
                    if (this.nextSparseTokenCount < this.currentNode.tokenElements.length - 1 && this.nextSparseTokenCount - this.tokenElements.length + 1 <= this.depth) {
                        this.sparseTree.addTokenPart(this.sparseNodeBuffer, this.nextSparseTokenCount, this.currentNode.tokenElements[this.nextSparseTokenCount]);
                        ++this.nextSparseTokenCount;
                        this.current = new EnumeratedSparseTreeNode<Object>(this.sparseNodeBuffer.toString(), null, false, null);
                        if (this.options.contains(EnumSubTreeOptions.INCLUDE_ADDITIONAL_DATA)) {
                            this.current.hasChildren = true;
                            this.current.noChildrenBelow = null;
                        }
                        return true;
                    }
                    this.prevChildNode = this.currentNode;
                    if (this.depth < this.currentNode.tokenElements.length - this.tokenElements.length) {
                        this.currentNode = null;
                    }
                    this.state = State.Normal;
                    continue;
                }
                while (null == this.currentNode && this.nodeStack.size() > 0) {
                    int poppedNodeDepth;
                    SparseTreeNode poppedNode = this.nodeStack.pop();
                    if (this.options.contains(EnumSubTreeOptions.ENUMERATE_SPARSE_NODES)) {
                        int commonTokenCount = Math.max(poppedNode.parent.tokenElements.length, this.tokenElements.length);
                        if (null != this.prevChildNode) {
                            commonTokenCount += this.sparseTree.getCommonTokenCount(this.prevChildNode.tokenElements, poppedNode.tokenElements, commonTokenCount);
                        }
                        if (commonTokenCount < poppedNode.tokenElements.length - 1) {
                            this.sparseNodeBuffer = this.sparseTree.getPartialTokenStringBuilder(this.sparseNodeBuffer, poppedNode.token, poppedNode.tokenElements, commonTokenCount);
                            this.nextSparseTokenCount = commonTokenCount;
                            this.currentNode = poppedNode;
                            this.state = State.SparseNodes;
                            continue block0;
                        }
                    }
                    if ((poppedNodeDepth = this.depth - (poppedNode.tokenElements.length - this.tokenElements.length)) < 0) continue;
                    this.currentNode = poppedNode;
                }
                break;
            }
            if (null != this.currentNode) {
                int currentNodeDepth;
                this.current = new EnumeratedSparseTreeNode(this.currentNode.token, this.currentNode.referencedObject, false, null);
                if (this.options.contains(EnumSubTreeOptions.INCLUDE_ADDITIONAL_DATA)) {
                    this.current.hasChildren = this.currentNode.getChildCount() > 0;
                    String string = this.current.noChildrenBelow = this.current.hasChildren ? null : this.currentNode.token;
                }
                if ((currentNodeDepth = this.depth - (this.currentNode.tokenElements.length - this.tokenElements.length)) > 0 && this.currentNode.getChildCount() > 0) {
                    this.pushChildren(this.currentNode, 0, this.currentNode.children.size());
                }
                this.currentNode = null;
                return true;
            }
            this.current = null;
            return false;
        }

        public void reset() {
            this.current = null;
            this.tokenElements = new String[0];
            this.nodeStack = new Stack();
            this.state = State.Normal;
            this.token = this.sparseTree.canonicalizeToken(this.token);
            boolean isSpecifiedNode = true;
            SparseTreeNode currentNode = this.sparseTree.rootNode;
            if (null != this.token) {
                this.tokenElements = this.sparseTree.splitToken(this.token);
                AtomicReference<SparseTreeNode> closestNode = new AtomicReference<SparseTreeNode>(currentNode);
                isSpecifiedNode = this.sparseTree.findClosestNode(this.token, this.tokenElements, this.sparseTree.rootNode, closestNode);
                currentNode = closestNode.get();
            }
            if (null == currentNode) {
                return;
            }
            if (isSpecifiedNode) {
                if (this.options.contains(EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT) && null != this.token) {
                    this.current = new EnumeratedSparseTreeNode(currentNode.token, currentNode.referencedObject, false, null);
                    if (this.options.contains(EnumSubTreeOptions.INCLUDE_ADDITIONAL_DATA)) {
                        this.current.hasChildren = currentNode.getChildCount() > 0;
                        this.current.noChildrenBelow = this.current.hasChildren ? null : currentNode.token;
                    }
                    this.state = State.InitialNode;
                }
                if (this.depth > 0 && currentNode.getChildCount() > 0) {
                    this.pushChildren(currentNode, 0, currentNode.children.size());
                }
            } else if (currentNode.getChildCount() > 0) {
                EnumSubTreeOptions enumSparseRoot = EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT.combine(EnumSubTreeOptions.ENUMERATE_SPARSE_NODES);
                SparseTreeRange range = this.sparseTree.findRange(this.tokenElements, this.tokenElements.length, 0, currentNode);
                if (range.getStart() >= 0) {
                    if (this.options.contains(enumSparseRoot)) {
                        this.current = new EnumeratedSparseTreeNode<Object>(this.token, null, false, null);
                        if (this.options.contains(EnumSubTreeOptions.INCLUDE_ADDITIONAL_DATA)) {
                            this.current.hasChildren = true;
                            this.current.noChildrenBelow = null;
                        }
                        this.state = State.InitialNode;
                    }
                    if (this.depth > 0) {
                        this.pushChildren(currentNode, range.getStart(), range.getEnd() - range.getStart() + 1);
                    }
                }
            }
        }

        private void pushChildren(SparseTreeNode<T> node, int startIndex, int length) {
            for (int i = startIndex + length - 1; i >= startIndex; --i) {
                this.nodeStack.push(node.children.get(i));
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current != null && this.state != State.InitialNode) {
                return true;
            }
            return this.moveNext();
        }

        @Override
        public EnumeratedSparseTreeNode<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EnumeratedSparseTreeNode toReturn = this.current;
            this.moveNext();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new NotYetImplementedException();
        }
    }

    private class EnumSubTreeEnumerable
    implements Iterable<EnumeratedSparseTreeNode<T>> {
        private final SparseTree<T> sparseTree;
        private final String token;
        private final EnumSubTreeOptions options;
        private final int depth;

        public EnumSubTreeEnumerable(SparseTree<T> sparseTree2, String token, EnumSubTreeOptions options, int depth) {
            this.sparseTree = sparseTree2;
            this.token = token;
            this.options = options;
            this.depth = depth;
        }

        @Override
        public Iterator<EnumeratedSparseTreeNode<T>> iterator() {
            return new EnumSubTreeEnumerator(this.sparseTree, this.token, this.options, this.depth);
        }
    }

    private class EnumParentsEnumerator
    implements Iterator<EnumeratedSparseTreeNode<T>> {
        private final SparseTree<T> sparseTree;
        private String token;
        private final EnumParentsOptions options;
        private EnumeratedSparseTreeNode<T> current;
        private String[] tokenElements;
        private SparseTreeNode<T> currentParent;
        private boolean isSpecifiedNode;
        private boolean hasChildren;
        private int enumTokenLength;
        private StringBuilder sparseNodeBuffer;

        public EnumParentsEnumerator(SparseTree<T> sparseTree2, String token, EnumParentsOptions options) {
            this.sparseTree = sparseTree2;
            this.token = token;
            this.options = options;
            this.reset();
        }

        private boolean moveNext() {
            if (null == this.currentParent) {
                this.current = null;
                return false;
            }
            if (this.options.contains(EnumParentsOptions.ENUMERATE_SPARSE_NODES) && this.currentParent.tokenElements.length < this.enumTokenLength) {
                this.sparseNodeBuffer = this.sparseTree.getPartialTokenStringBuilder(this.sparseNodeBuffer, this.token, this.tokenElements, this.enumTokenLength);
                String sparseToken = this.sparseNodeBuffer.toString();
                this.current = new EnumeratedSparseTreeNode<Object>(sparseToken, null, false, null);
                if (this.options.contains(EnumParentsOptions.INCLUDE_ADDITIONAL_DATA)) {
                    if (!this.hasChildren && this.currentParent.getChildCount() > 0) {
                        this.hasChildren = this.sparseTree.findRange(this.tokenElements, this.enumTokenLength, 0, this.currentParent).getStart() >= 0;
                    }
                    this.current.hasChildren = this.hasChildren;
                    this.current.noChildrenBelow = this.hasChildren ? null : sparseToken;
                }
                --this.enumTokenLength;
                return true;
            }
            if (null != this.currentParent.parent) {
                this.current = new EnumeratedSparseTreeNode(this.currentParent.token, this.currentParent.referencedObject, false, null);
                if (this.options.contains(EnumParentsOptions.INCLUDE_ADDITIONAL_DATA)) {
                    if (!this.hasChildren) {
                        boolean bl = this.hasChildren = this.currentParent.getChildCount() > 0;
                        if (this.hasChildren && !this.isSpecifiedNode) {
                            int noChildrenBelowTokenCount = this.currentParent.tokenElements.length;
                            SparseTreeRange range = new SparseTreeRange(0, this.currentParent.children.size());
                            while (range.getStart() >= 0) {
                                if (noChildrenBelowTokenCount >= this.tokenElements.length) {
                                    noChildrenBelowTokenCount = 0;
                                    break;
                                }
                                range = this.sparseTree.findRange(this.tokenElements, ++noChildrenBelowTokenCount, range.getStart(), this.currentParent);
                            }
                            if (noChildrenBelowTokenCount > 0) {
                                this.current.noChildrenBelow = this.sparseTree.getPartialTokenStringBuilder(null, this.token, this.tokenElements, noChildrenBelowTokenCount).toString();
                            }
                        }
                    }
                    this.current.hasChildren = this.hasChildren;
                    if (null == this.current.noChildrenBelow) {
                        this.current.noChildrenBelow = this.hasChildren ? null : this.currentParent.token;
                    }
                }
                --this.enumTokenLength;
                this.currentParent = this.currentParent.parent;
                return true;
            }
            this.current = null;
            return false;
        }

        public void reset() {
            this.current = null;
            this.token = this.sparseTree.canonicalizeToken(this.token);
            this.tokenElements = this.sparseTree.splitToken(this.token);
            this.enumTokenLength = this.tokenElements.length;
            AtomicReference closestNode = new AtomicReference();
            this.isSpecifiedNode = this.sparseTree.findClosestNode(this.token, this.tokenElements, this.sparseTree.rootNode, closestNode);
            this.currentParent = (SparseTreeNode)closestNode.get();
            this.hasChildren = false;
            this.sparseNodeBuffer = null;
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            return this.moveNext();
        }

        @Override
        public EnumeratedSparseTreeNode<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EnumeratedSparseTreeNode toReturn = this.current;
            this.moveNext();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new NotYetImplementedException();
        }
    }

    private class EnumParentsEnumerable
    implements Iterable<EnumeratedSparseTreeNode<T>> {
        private final SparseTree<T> sparseTree;
        private final String token;
        private final EnumParentsOptions options;

        public EnumParentsEnumerable(SparseTree<T> sparseTree2, String token, EnumParentsOptions options) {
            this.sparseTree = sparseTree2;
            this.token = token;
            this.options = options;
        }

        @Override
        public Iterator<EnumeratedSparseTreeNode<T>> iterator() {
            return new EnumParentsEnumerator(this.sparseTree, this.token, this.options);
        }
    }

    private static enum State {
        InitialNode,
        SparseNodes,
        Normal;

    }

    public static interface ModifyInPlaceCallback<T> {
        public T invoke(String var1, T var2, Object var3);
    }

    public static interface EnumNodeCallback<T> {
        public boolean invoke(String var1, T var2, SparseTreeAdditionalData var3, Object var4);
    }
}

