/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata;

import com.microsoft.tfs.core.clients.workitem.WorkItemServerVersion;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.ConstantHandler;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadataChangeListener;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadataUpdateHandler;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.MetadataDAOFactory;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.MetadataTableNames;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.MetadataUpdateResults;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.ActionsTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.ConstantSetsTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.ConstantsTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.FieldUsagesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.FieldsTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.HierarchyPropertiesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.HierarchyTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.RulesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemLinkTypesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeCategoriesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeCategoryMembersTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeUsagesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.impl.ConstantHandlerImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.DBRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParser;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.internal.db.ConnectionPool;
import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.internal.db.DBTask;
import com.microsoft.tfs.core.internal.db.ResultHandler;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementDeserializable;
import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.StaxAnyContentType;
import com.microsoft.tfs.util.Closable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap_GetMetadataEx2Response;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap_GetMetadataEx2Response;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap_GetMetadataEx2Response;
import ms.tfs.workitemtracking.clientservices._03._MetadataTableHaveEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Metadata
implements IMetadata,
IMetadataUpdateHandler {
    public static final String SCHEMA_VERSION = "4.0A";
    private static final String HOUSEKEEPING_TABLE_NAME = "WITHousekeeping";
    private static final String DBSTAMP_COLUMN_NAME = "DBStamp";
    private static final String SCHEMA_VERSION_COLUMN_NAME = "SchemaVersion";
    public static final String MAXCOUNT_TABLE_NAME = "WITMaxCount";
    public static final String TABLE_NAME_COLUMN_NAME = "TableName";
    public static final String ROW_VERSION_COLUMN_NAME = "RowVersion";
    private static final Log log = LogFactory.getLog(Metadata.class);
    private final ConnectionPool connectionPool;
    private final Set<IMetadataChangeListener> metadataUpdateListeners = new HashSet<IMetadataChangeListener>();
    private boolean verbose = false;
    private final MetadataDAOFactory daoFactory;
    private final _ClientService2Soap clientService2;
    private final _ClientService3Soap clientService3;
    private final _ClientService5Soap clientService5;
    private final WorkItemServerVersion serverVersion;
    private final ConstantHandlerImpl constantHandler;
    private Set<Integer> distinctConstantSetIds;
    private final boolean alwaysSendUpdateNotifications = Boolean.getBoolean("com.microsoft.tfs.core.workitem.metadata.alwaysnotifyonupdate");
    private int userDisplayMode;

    public Metadata(ConnectionPool connectionPool, WorkItemServerVersion serverVersion, _ClientService2Soap clientService2, _ClientService3Soap clientService3, _ClientService5Soap clientService5) {
        this.connectionPool = connectionPool;
        this.clientService2 = clientService2;
        this.clientService3 = clientService3;
        this.clientService5 = clientService5;
        this.serverVersion = serverVersion;
        this.constantHandler = new ConstantHandlerImpl(this);
        this.daoFactory = new MetadataDAOFactory(this, connectionPool);
        connectionPool.executeWithPooledConnection(new DBTask(){

            @Override
            public void performTask(DBConnection connection) {
                boolean reset = false;
                if (!connection.getDBSpecificOperations().tableExists(Metadata.HOUSEKEEPING_TABLE_NAME)) {
                    log.info((Object)"unable to find housekeeping table - will reset");
                    reset = true;
                } else {
                    String currentSchemaVersion = Metadata.this.getSchemaVersion(connection);
                    if (!Metadata.SCHEMA_VERSION.equals(currentSchemaVersion)) {
                        log.info((Object)MessageFormat.format("current schema [{0}] does not match [{1}] - will reset", currentSchemaVersion, Metadata.SCHEMA_VERSION));
                        Metadata.this.dropHousekeepingTable(connection);
                        reset = true;
                    }
                }
                if (reset) {
                    Metadata.this.dropMetadataTables(connection);
                    connection.createStatement("create table WITHousekeeping (DBStamp varchar(255), SchemaVersion varchar(255))").executeUpdate();
                    connection.createStatement("insert into WITHousekeeping (DBStamp, SchemaVersion) values (NULL, '4.0A')").executeUpdate();
                    Metadata.this.createMaxCountTable(connection);
                }
            }
        });
    }

    @Override
    public int getUserDisplayMode() {
        return this.userDisplayMode;
    }

    @Override
    public ConstantHandler getConstantHandler() {
        return this.constantHandler;
    }

    @Override
    public RulesTable getRulesTable() {
        return (RulesTable)this.daoFactory.getDAO(RulesTable.class);
    }

    @Override
    public FieldsTable getFieldsTable() {
        return (FieldsTable)this.daoFactory.getDAO(FieldsTable.class);
    }

    @Override
    public HierarchyTable getHierarchyTable() {
        return (HierarchyTable)this.daoFactory.getDAO(HierarchyTable.class);
    }

    @Override
    public ConstantsTable getConstantsTable() {
        return (ConstantsTable)this.daoFactory.getDAO(ConstantsTable.class);
    }

    @Override
    public ActionsTable getActionsTable() {
        return (ActionsTable)this.daoFactory.getDAO(ActionsTable.class);
    }

    @Override
    public WorkItemTypeTable getWorkItemTypeTable() {
        return (WorkItemTypeTable)this.daoFactory.getDAO(WorkItemTypeTable.class);
    }

    @Override
    public HierarchyPropertiesTable getHierarchyPropertiesTable() {
        return (HierarchyPropertiesTable)this.daoFactory.getDAO(HierarchyPropertiesTable.class);
    }

    public ConstantSetsTable getConstantSetsTable() {
        return (ConstantSetsTable)this.daoFactory.getDAO(ConstantSetsTable.class);
    }

    @Override
    public WorkItemTypeUsagesTable getWorkItemTypeUsagesTable() {
        return (WorkItemTypeUsagesTable)this.daoFactory.getDAO(WorkItemTypeUsagesTable.class);
    }

    @Override
    public FieldUsagesTable getFieldUsagesTable() {
        return (FieldUsagesTable)this.daoFactory.getDAO(FieldUsagesTable.class);
    }

    @Override
    public WorkItemLinkTypesTable getLinkTypesTable() {
        return (WorkItemLinkTypesTable)this.daoFactory.getDAO(WorkItemLinkTypesTable.class);
    }

    @Override
    public WorkItemTypeCategoriesTable getWorkItemTypeCategoriesTable() {
        return (WorkItemTypeCategoriesTable)this.daoFactory.getDAO(WorkItemTypeCategoriesTable.class);
    }

    @Override
    public WorkItemTypeCategoryMembersTable getWorkItemTypeCategoryMembersTable() {
        return (WorkItemTypeCategoryMembersTable)this.daoFactory.getDAO(WorkItemTypeCategoryMembersTable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetadataChangeListener(IMetadataChangeListener listener) {
        Set<IMetadataChangeListener> set = this.metadataUpdateListeners;
        synchronized (set) {
            this.metadataUpdateListeners.add(listener);
        }
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public _MetadataTableHaveEntry[] getHaveEntries() {
        final Object[] objectHolder = new Object[1];
        this.connectionPool.executeWithPooledConnection(new DBTask(){

            @Override
            public void performTask(DBConnection connection) {
                Set tables = Metadata.this.getAllTableNames();
                _MetadataTableHaveEntry[] entries = new _MetadataTableHaveEntry[tables.size()];
                int ix = 0;
                for (String tableName : tables) {
                    long rowVersion = Metadata.this.getCachestamp(tableName, connection);
                    entries[ix++] = new _MetadataTableHaveEntry(tableName, rowVersion);
                }
                objectHolder[0] = entries;
            }
        });
        return (_MetadataTableHaveEntry[])objectHolder[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateMetadata(final AnyContentType metadata, final String newDbStamp) {
        long startTime = System.currentTimeMillis();
        final boolean[] fullUpdateHolder = new boolean[]{false};
        final HashSet tableNames = new HashSet();
        this.connectionPool.executeWithPooledConnection(new DBTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performTask(DBConnection connection) {
                if (newDbStamp != null) {
                    String oldDbStamp = Metadata.this.getDBStamp(connection);
                    if (oldDbStamp == null || oldDbStamp.length() == 0) {
                        Metadata.this.setDBStamp(connection, newDbStamp);
                    } else if (!oldDbStamp.equals(newDbStamp)) {
                        log.info((Object)MessageFormat.format("current dbstamp [{0}] does not match [{1}] - invalidating cache", oldDbStamp, newDbStamp));
                        Metadata.this.dropMetadataTables(connection);
                        Metadata.this.createMaxCountTable(connection);
                        Metadata.this.setDBStamp(connection, "");
                        fullUpdateHolder[0] = true;
                        return;
                    }
                }
                Iterator i = metadata.getElementIterator();
                RowSetParser parser = new RowSetParser();
                while (i.hasNext()) {
                    DBRowSetHandler handler = new DBRowSetHandler(connection, Metadata.this.verbose);
                    if (metadata instanceof DOMAnyContentType) {
                        parser.parse((Element)i.next(), (RowSetParseHandler)handler);
                    } else {
                        if (metadata instanceof StaxAnyContentType) {
                            XMLStreamReader reader = (XMLStreamReader)i.next();
                            try {
                                parser.parse(reader, (RowSetParseHandler)handler);
                            }
                            finally {
                                try {
                                    reader.close();
                                }
                                catch (XMLStreamException e) {
                                    throw new TECoreException(e);
                                }
                            }
                        }
                        throw new WorkItemException(MessageFormat.format("Can''t update metadata from unknown AnyContentType implementation {0}", metadata.getClass().getName()));
                    }
                    if (!Metadata.this.alwaysSendUpdateNotifications && handler.getInsertCount() <= 0 && handler.getDeleteCount() <= 0) continue;
                    tableNames.add(handler.getTableName());
                }
                if (i instanceof Closable) {
                    ((Closable)((Object)i)).close();
                }
            }
        });
        if (fullUpdateHolder[0]) {
            this.update();
        } else if (tableNames.size() > 0) {
            Metadata metadata2 = this;
            synchronized (metadata2) {
                if (tableNames.contains("ConstantSets")) {
                    this.distinctConstantSetIds = null;
                }
            }
            Set<String> unmodifiableTableNameSet = Collections.unmodifiableSet(tableNames);
            Set<IMetadataChangeListener> set = this.metadataUpdateListeners;
            synchronized (set) {
                Iterator<IMetadataChangeListener> it = this.metadataUpdateListeners.iterator();
                while (it.hasNext()) {
                    it.next().metadataChanged(unmodifiableTableNameSet);
                }
            }
        }
        return System.currentTimeMillis() - startTime;
    }

    @Override
    public void update() {
        this.update(false);
    }

    @Override
    public MetadataUpdateResults update(boolean wantResults) {
        String dbStamp;
        AnyContentType metadata;
        ElementDeserializable response;
        _MetadataTableHaveEntry[] aomthe = this.getHaveEntries();
        long stTime = System.currentTimeMillis();
        if (this.serverVersion.getValue() >= 5) {
            response = this.clientService5.getMetadataEx2(aomthe, true, new StaxAnyContentType());
            metadata = ((_ClientService5Soap_GetMetadataEx2Response)response).getMetadata();
            dbStamp = ((_ClientService5Soap_GetMetadataEx2Response)response).getDbStamp();
            this.userDisplayMode = ((_ClientService5Soap_GetMetadataEx2Response)response).getMode();
        } else if (this.serverVersion.getValue() >= 3) {
            response = this.clientService3.getMetadataEx2(aomthe, true, new StaxAnyContentType());
            metadata = ((_ClientService3Soap_GetMetadataEx2Response)response).getMetadata();
            dbStamp = ((_ClientService3Soap_GetMetadataEx2Response)response).getDbStamp();
            this.userDisplayMode = ((_ClientService3Soap_GetMetadataEx2Response)response).getMode();
        } else {
            response = this.clientService2.getMetadataEx2(aomthe, true, new StaxAnyContentType());
            metadata = ((_ClientService2Soap_GetMetadataEx2Response)response).getMetadata();
            dbStamp = ((_ClientService2Soap_GetMetadataEx2Response)response).getDbStamp();
            this.userDisplayMode = ((_ClientService2Soap_GetMetadataEx2Response)response).getMode();
        }
        long proxyTime = System.currentTimeMillis() - stTime;
        long updateDbTime = this.updateMetadata(metadata, dbStamp);
        if (wantResults) {
            return new MetadataUpdateResults(proxyTime, updateDbTime, metadata, dbStamp);
        }
        metadata.dispose();
        return null;
    }

    private void createMaxCountTable(DBConnection connection) {
        connection.createStatement("create table WITMaxCount (TableName varchar(255), RowVersion bigint)").executeUpdate();
    }

    private long getCachestamp(String tableName, DBConnection connection) {
        if (connection.getDBSpecificOperations().tableExists(MAXCOUNT_TABLE_NAME)) {
            Long maxCacheStamp = connection.createStatement("select RowVersion from WITMaxCount where TableName = '" + tableName + "'").executeLongQuery();
            return maxCacheStamp != null ? maxCacheStamp : 0L;
        }
        return 0L;
    }

    private String getDBStamp(DBConnection connection) {
        return connection.createStatement("select DBStamp from WITHousekeeping").executeStringQuery();
    }

    private void setDBStamp(DBConnection connection, String dbStamp) {
        connection.createStatement("update WITHousekeeping set DBStamp = ?").executeUpdate(dbStamp);
    }

    private String getSchemaVersion(DBConnection connection) {
        return connection.createStatement("select SchemaVersion from WITHousekeeping").executeStringQuery();
    }

    private void dropHousekeepingTable(DBConnection connection) {
        connection.createStatement("drop table WITHousekeeping").executeUpdate();
    }

    private void dropMetadataTables(DBConnection connection) {
        for (String tableName : this.getAllTableNames()) {
            String stmt = "drop table " + tableName;
            try {
                connection.createStatement(stmt).executeUpdate();
            }
            catch (Throwable t) {
                log.warn((Object)MessageFormat.format("drop metadata tables: {0}", t.getMessage()));
            }
        }
        try {
            connection.createStatement("drop table WITMaxCount").executeUpdate();
        }
        catch (Throwable t) {
            log.warn((Object)MessageFormat.format("drop maxcount table: {0}", t.getMessage()));
        }
    }

    private Set<String> getAllTableNames() {
        if (this.serverVersion.getValue() >= 3) {
            return MetadataTableNames.allTableNamesVersion3;
        }
        return MetadataTableNames.allTableNamesVersion2;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public synchronized Set<Integer> getDistinctConstantSetIDs() {
        if (this.distinctConstantSetIds == null) {
            this.distinctConstantSetIds = new HashSet<Integer>();
            this.getConnectionPool().executeWithPooledConnection(new DBTask(){

                @Override
                public void performTask(DBConnection connection) {
                    connection.createStatement("select distinct ParentID from ConstantSets").executeQuery(new ResultHandler(){

                        @Override
                        public void handleRow(ResultSet rset) throws SQLException {
                            int constId = rset.getInt(1);
                            Metadata.this.distinctConstantSetIds.add(new Integer(constId));
                        }
                    });
                }
            });
            this.distinctConstantSetIds = Collections.unmodifiableSet(this.distinctConstantSetIds);
        }
        return this.distinctConstantSetIds;
    }
}

