/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Arithmetic;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.ArithmeticalOperators;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Priority;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;

public class NodeArithmetic
extends NodeList {
    private Arithmetic operator;

    public NodeArithmetic() {
        super(NodeType.ARITHMETIC, 2);
    }

    @Override
    public void appendTo(StringBuffer b) {
        super.appendChildren(b, " " + ArithmeticalOperators.getString(this.operator) + " ");
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.getLeft().bind(e, tableContext, fieldContext);
        this.getRight().bind(e, tableContext, fieldContext);
        Tools.ensureSyntax(this.getLeft().isConst(), SyntaxError.EXPECTING_CONST, this.getLeft());
        Tools.ensureSyntax(this.getRight().isConst(), SyntaxError.EXPECTING_CONST, this.getRight());
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public Node optimize(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        this.optimizeChildren(e, tableContext, fieldContext);
        return super.optimize(e, tableContext, fieldContext);
    }

    public Arithmetic getArithmetic() {
        return this.operator;
    }

    public void setArithmetic(Arithmetic operator) {
        this.operator = operator;
    }

    @Override
    public DataType getDataType() {
        return this.getLeft().getDataType();
    }

    public Node getLeft() {
        return this.getItem(0);
    }

    public void setLeft(Node left) {
        this.setItem(0, left);
    }

    @Override
    public Priority getPriority() {
        return Priority.ADD_OPERATOR;
    }

    public Node getRight() {
        return this.getItem(1);
    }

    public void setRight(Node right) {
        this.setItem(1, right);
    }
}

