/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.auth.AuthChallengeException;
import com.microsoft.tfs.core.httpclient.auth.AuthPolicy;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.AuthState;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;
import com.microsoft.tfs.core.httpclient.params.HttpParams;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AuthChallengeProcessor {
    private static final Log LOG = LogFactory.getLog(AuthChallengeProcessor.class);
    private HttpParams params = null;

    public AuthChallengeProcessor(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter collection may not be null");
        }
        this.params = params;
    }

    public AuthScheme selectAuthScheme(Map challenges) throws AuthChallengeException {
        return this.selectAuthScheme(challenges, null);
    }

    public AuthScheme selectAuthScheme(Map challenges, Credentials credentials) throws AuthChallengeException {
        if (challenges == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        Collection authPrefs = (Collection)this.params.getParameter("http.auth.scheme-priority");
        if (authPrefs == null || authPrefs.isEmpty()) {
            authPrefs = AuthPolicy.getDefaultAuthPrefs();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Supported authentication schemes in the order of preference: " + authPrefs));
        }
        AuthScheme authscheme = null;
        String challenge = null;
        for (String id : authPrefs) {
            challenge = (String)challenges.get(id.toLowerCase());
            if (challenge != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(id + " authentication scheme selected"));
                }
                try {
                    AuthScheme testScheme = AuthPolicy.getAuthScheme(id);
                    if (credentials != null && !testScheme.supportsCredentials(credentials)) continue;
                    authscheme = testScheme;
                    break;
                }
                catch (IllegalStateException e) {
                    throw new AuthChallengeException(e.getMessage());
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Challenge for " + id + " authentication scheme not available"));
        }
        if (authscheme == null) {
            throw new AuthChallengeException("Unable to respond to any of these challenges: " + challenges);
        }
        return authscheme;
    }

    public AuthScheme processChallenge(AuthState state, Map challenges) throws MalformedChallengeException, AuthenticationException {
        return this.processChallenge(state, challenges, null);
    }

    public AuthScheme processChallenge(AuthState state, Map challenges, Credentials credentials) throws MalformedChallengeException, AuthenticationException {
        String challenge;
        if (state == null) {
            throw new IllegalArgumentException("Authentication state may not be null");
        }
        if (challenges == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        if (state.isPreemptive() || state.getAuthScheme() == null) {
            state.setAuthScheme(this.selectAuthScheme(challenges, credentials));
        }
        AuthScheme authscheme = state.getAuthScheme();
        String id = authscheme.getSchemeName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using authentication scheme: " + id));
        }
        if ((challenge = (String)challenges.get(id.toLowerCase())) == null) {
            throw new AuthenticationException(id + " authorization challenge expected, but not found");
        }
        authscheme.processChallenge(challenge);
        LOG.debug((Object)"Authorization challenge processed");
        return authscheme;
    }
}

