/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.framework.location.AccessMapping;
import com.microsoft.tfs.core.clients.framework.location.ILocationService;
import com.microsoft.tfs.core.clients.framework.location.LocationService;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.URLEncode;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TSWAHyperlinkBuilder {
    private final boolean isCompatibleMode;
    private final boolean displayInEmbeddedBrowser;
    private final RegistrationClient registrationClient;
    private final ILocationService locationService;
    private final ILocationService collectionLocationService;
    private final GUID collectionId;
    private final TFSTeamProjectCollection collection;
    private static final Log log = LogFactory.getLog(TSWAHyperlinkBuilder.class);

    public TSWAHyperlinkBuilder(TFSTeamProjectCollection collection) {
        this(collection, false);
    }

    public TSWAHyperlinkBuilder(TFSTeamProjectCollection collection, boolean displayInEmbeddedBrowser) {
        Check.notNull(collection, "collection");
        TFSConfigurationServer configurationServer = collection.getConfigurationServer();
        this.registrationClient = collection.getRegistrationClient();
        this.collectionId = collection.getInstanceID();
        if (configurationServer == null) {
            this.isCompatibleMode = true;
            this.locationService = null;
        } else {
            this.isCompatibleMode = false;
            this.locationService = configurationServer.getLocationService();
        }
        this.collection = collection;
        this.collectionLocationService = collection.getCollectionLocationService();
        this.displayInEmbeddedBrowser = displayInEmbeddedBrowser;
    }

    public URI getHomeURL() {
        return this.getHomeURL("PublicAccessMapping");
    }

    public URI getHomeURL(String accessMappingMoniker) {
        if (this.isCompatibleMode) {
            String result = this.buildURL("WorkItemEditor", accessMappingMoniker).toString();
            int pos = result.lastIndexOf(47);
            if (pos > 0) {
                result = result.substring(0, pos);
            }
            try {
                return new URI(result);
            }
            catch (URISyntaxException e) {
                throw new TECoreException(MessageFormat.format("Unable to create URI from \"{0}\"", result), e);
            }
        }
        return this.buildURL("TSWAHome", accessMappingMoniker);
    }

    public URI getHomeURL(URI projectUri) {
        return this.getHomeUrl(projectUri, "PublicAccessMapping");
    }

    public URI getHomeUrl(URI projectUri, String accessMappingMoniker) {
        Check.notNull(projectUri, "projectUri");
        return this.getPageURL(accessMappingMoniker, "index.aspx", this.formatQueryString(projectUri.toString(), new String[0]));
    }

    public URI getShelvesetDetailsURL(String shelvesetName, String shelvesetOwner) {
        return this.getShelvesetDetailsURL(shelvesetName, shelvesetOwner, "PublicAccessMapping");
    }

    public URI getShelvesetDetailsURL(String shelvesetName, String shelvesetOwner, String accessMappingMoniker) {
        Check.notNullOrEmpty(shelvesetName, "shelvesetName");
        Check.notNullOrEmpty(shelvesetOwner, "shelvesetOwner");
        if (this.isCompatibleMode) {
            return this.getPageURL(accessMappingMoniker, "ss.aspx", this.formatQueryString("ss", shelvesetName + ";" + shelvesetOwner));
        }
        return this.buildURL("ViewShelvesetDetails", accessMappingMoniker, new String[]{"shelvesetName", shelvesetName, "shelvesetOwner", shelvesetOwner}, null);
    }

    public URI getNewWorkItemURL(String projectUri, String workItemType, int titleID) {
        return this.getNewWorkItemURL(projectUri, workItemType, titleID, "PublicAccessMapping");
    }

    public URI getNewWorkItemURL(String projectUri, String workItemType, int titleID, String accessMappingMoniker) {
        String[] replacementArgs = new String[]{"projectUri", projectUri, "workItemType", workItemType};
        ArrayList<String> additionalQueryParameters = new ArrayList<String>();
        if (titleID > 0) {
            additionalQueryParameters.add(MessageFormat.format("titleId={0}", titleID));
        }
        return this.buildURL("CreateWorkItem", accessMappingMoniker, replacementArgs, additionalQueryParameters);
    }

    public URI getWorkItemEditorURL(int workItemId) {
        return this.getWorkItemEditorURL(workItemId, "PublicAccessMapping");
    }

    public URI getWorkItemEditorURL(int workItemId, String accessMappingMoniker) {
        if (workItemId < 1) {
            throw new IndexOutOfBoundsException(MessageFormat.format("The value {0} is outside of the allowed range.", Integer.toString(workItemId)));
        }
        return this.buildURL("OpenWorkItem", accessMappingMoniker, "workItemId", Integer.toString(workItemId), null);
    }

    public URI getChangesetURL(int changesetId) {
        return this.getChangesetURL(changesetId, "PublicAccessMapping");
    }

    public URI getChangesetURL(int changesetId, String accessMappingMoniker) {
        if (changesetId < 1) {
            throw new IndexOutOfBoundsException(MessageFormat.format("The value {0} is outside of the allowed range.", Integer.toString(changesetId)));
        }
        return this.buildURL("ViewChangesetDetails", accessMappingMoniker, "changesetId", Integer.toString(changesetId), null);
    }

    public URI getWorkItemQueryResultsURL(String projectUri, String queryPath) {
        return this.getWorkItemQueryResultsURL(projectUri, queryPath, "PublicAccessMapping");
    }

    public URI getWorkItemQueryResultsURL(String projectUri, String queryPath, String accessMappingMoniker) {
        if (queryPath == null || queryPath.length() == 0) {
            throw new IllegalArgumentException("The queryPath cannot be null or empty.");
        }
        if (this.isCompatibleMode || projectUri == null) {
            String query = this.formatQueryString(projectUri, "path", queryPath);
            return this.getPageURL(accessMappingMoniker, "qr.aspx", query);
        }
        return this.buildURL("ViewServerQueryResults", accessMappingMoniker, new String[]{"projectUri", projectUri, "storedQueryPath", queryPath}, null);
    }

    public URI getWorkItemQueryEditorURL(String projectUri, String queryPath) {
        return this.getWorkItemQueryEditorURL(projectUri, queryPath, "PublicAccessMapping");
    }

    public URI getWorkItemQueryEditorURL(String projectUri, String queryPath, String accessMappingMoniker) {
        if (queryPath == null || queryPath.length() == 0) {
            throw new IllegalArgumentException("The queryPath cannot be null or empty.");
        }
        return this.getPageURL(accessMappingMoniker, "qe.aspx", this.formatQueryString(projectUri, "path", queryPath));
    }

    public URI getViewBuildDetailsURL(String buildUri) {
        return this.getViewBuildDetailsURI(buildUri, "PublicAccessMapping");
    }

    public URI getViewBuildDetailsURI(String buildUri, String accessMappingMoniker) {
        Check.notNullOrEmpty(buildUri, "buildUri");
        return this.buildURL("ViewBuildDetails", accessMappingMoniker, "buildUri", buildUri, null);
    }

    public URI getBuildDefinitionVNextURI(String projectName, String action) {
        return this.getBuildDefinitionVNextURI(projectName, action, 0);
    }

    public URI getBuildDefinitionVNextURI(String projectName, String action, int definitionId) {
        Check.notNullOrEmpty(projectName, "projectName");
        Check.notNullOrEmpty(action, "action");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("projectname=" + projectName);
        queryParameters.add("definitionid=" + definitionId);
        queryParameters.add("action=" + action);
        return this.buildURL("ViewBuildDetails", "PublicAccessMapping", null, queryParameters);
    }

    public URI getBuildDefinitionVNextURI(String projectName, String action, String definitionTemplateId) {
        Check.notNullOrEmpty(projectName, "projectName");
        Check.notNullOrEmpty(action, "action");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("projectname=" + projectName);
        queryParameters.add("definitionid=0");
        queryParameters.add("templateid=" + definitionTemplateId);
        queryParameters.add("action=" + action);
        return this.buildURL("ViewBuildDetails", "PublicAccessMapping", null, queryParameters);
    }

    private String formatQueryString(String parameterName, String parameterValue) {
        return this.formatQueryString(null, new String[]{parameterName, parameterValue});
    }

    private String formatQueryString(String projectUri, String parameterName, String parameterValue) {
        return this.formatQueryString(projectUri, new String[]{parameterName, parameterValue});
    }

    private String formatQueryString(String projectUri, String[] args) {
        StringBuffer result = new StringBuffer();
        if (projectUri != null) {
            if (this.isCompatibleMode) {
                result.append("puri=");
                result.append(URLEncode.encode(projectUri.toString()));
            } else {
                ArtifactID artifactID = new ArtifactID(projectUri);
                result.append("pguid=");
                result.append(URLEncode.encode(artifactID.getToolSpecificID()));
            }
        } else if (!this.isCompatibleMode) {
            result.append("pcguid=");
            result.append(URLEncode.encode(this.collectionId.toString()));
        }
        for (int i = 0; i < args.length - 1; i += 2) {
            String name = args[i];
            String value = args[i + 1];
            if (name != null) {
                if (result.length() > 0) {
                    result.append('&');
                }
                result.append(URLEncode.encode(name));
            }
            if (value == null) continue;
            if (name != null) {
                result.append('=');
            } else if (result.length() > 0) {
                result.append('&');
            }
            result.append(URLEncode.encode(value));
        }
        return result.toString();
    }

    private URI getPageURL(String accessMappingMoniker, String relativePath, String queryString) {
        String url = URIUtils.combinePaths(this.getHomeURL(accessMappingMoniker).toString(), relativePath);
        return URI.create(url + "?" + queryString);
    }

    private URI buildURL(String serviceType, String accessMappingMoniker) {
        return this.buildURL(serviceType, accessMappingMoniker, null, null);
    }

    private URI buildURL(String serviceType, String accessMappingMoniker, String replaceToken, String replaceWith, List<String> additionalQueryParameters) {
        return this.buildURL(serviceType, accessMappingMoniker, new String[]{replaceToken, replaceWith}, additionalQueryParameters);
    }

    private URI buildURL(String serviceType, String accessMappingMoniker, String[] replacementArgs, List<String> additionalQueryParams) {
        int idx;
        URI uri = null;
        String urlText = this.getURL(serviceType, accessMappingMoniker);
        if (urlText == null) {
            throw new NotSupportedException(MessageFormat.format("The Location Service Manager cannot find the service definition \"{0}\" among the TSWebAccess tool's services. Please verify that Web Access is configured correctly.", serviceType));
        }
        if (replacementArgs == null && (idx = urlText.indexOf(38)) > 0) {
            urlText = urlText.substring(0, idx);
        }
        uri = this.formatURL(urlText, replacementArgs, additionalQueryParams);
        return uri;
    }

    private URI formatURL(String urlText, String[] replacementArgs, List<String> additionalQueryParams) {
        int i;
        URI uri = null;
        if ((urlText = StringUtil.replace(urlText, "tfs={tfsUrl}&", "")).indexOf("{projectCollectionGuid}") > 0) {
            if (this.collectionId == GUID.EMPTY) {
                throw new TECoreException("Collection ID is not initialized");
            }
            urlText = StringUtil.replace(urlText, "{projectCollectionGuid}", URLEncode.encode(this.collectionId.getGUIDString()));
        }
        if (replacementArgs != null) {
            for (i = 0; i < replacementArgs.length - 1; i += 2) {
                urlText = StringUtil.replace(urlText, "{" + replacementArgs[i] + "}", URLEncode.encode(replacementArgs[i + 1]).replace("&", "%26"));
            }
        }
        if (additionalQueryParams != null) {
            for (i = 0; i < additionalQueryParams.size(); ++i) {
                urlText = urlText + (urlText.indexOf(63) == -1 ? "?" : "&");
                urlText = urlText + URLEncode.encode(additionalQueryParams.get(i));
            }
        }
        if (this.displayInEmbeddedBrowser) {
            urlText = urlText.indexOf(63) != -1 ? urlText + "&clienthost=tee" : urlText + "?clienthost=tee";
        }
        try {
            uri = new URI(urlText);
        }
        catch (URISyntaxException e) {
            throw new TECoreException(MessageFormat.format("Unable to create URI from \"{0}\"", urlText), e);
        }
        return uri;
    }

    private String getURL(String serviceType, String accessMappingMoniker) {
        return this.getURL(serviceType, accessMappingMoniker, this.locationService, "TSWebAccess");
    }

    private String getURL(String serviceType, String accessMappingMoniker, ILocationService locationService, String toolName) {
        Check.notNullOrEmpty(serviceType, "serviceType");
        String url = null;
        if (this.isCompatibleMode) {
            ServiceInterface serviceInterface = this.getServiceInterface(serviceType);
            if (serviceInterface != null) {
                url = serviceInterface.getURL();
            }
        } else {
            ServiceDefinition serviceDefinition = this.getServiceDefinition(serviceType, locationService, toolName);
            if (serviceDefinition != null) {
                AccessMapping accessMapping = null;
                if (accessMappingMoniker != null && accessMappingMoniker.length() > 0) {
                    accessMapping = locationService.getAccessMapping(accessMappingMoniker);
                }
                return locationService.locationForAccessMapping(serviceDefinition, accessMapping, false);
            }
        }
        return url;
    }

    private ServiceDefinition getServiceDefinition(String serviceType, ILocationService locationService, String toolName) {
        ServiceDefinition[] definitions = locationService.findServiceDefinitionsByToolType(toolName);
        if (definitions != null) {
            for (int i = 0; i < definitions.length; ++i) {
                if (!definitions[i].getServiceType().equalsIgnoreCase(serviceType)) continue;
                return definitions[i];
            }
        }
        return null;
    }

    private ServiceInterface getServiceInterface(String serviceType) {
        RegistrationEntry entry = this.registrationClient.getRegistrationEntry("TSWebAccess");
        if (entry != null) {
            ServiceInterface[] interfaces = entry.getServiceInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getName().equalsIgnoreCase(serviceType)) continue;
                return interfaces[i];
            }
        }
        return null;
    }

    public URI getGitCommitURL(String projectName, String repositoryID, String commitID) {
        Check.notNullOrEmpty(projectName, "projectName");
        Check.notNullOrEmpty(repositoryID, "repositoryID");
        Check.notNullOrEmpty(commitID, "commitID");
        URI uri = null;
        String urlText = this.getURL("CommitDetailsWeb", "PublicAccessMapping", this.collectionLocationService, "Git");
        if (urlText == null) {
            urlText = this.collection.getBaseURI() + "{projectName}/_git/repoId/commit/{commitId}?repoId={repositoryId}";
        }
        uri = this.formatURL(urlText, new String[]{"projectName", projectName, "commitId", commitID, "repositoryId", repositoryID}, null);
        return uri;
    }

    public URI getGitRepoURL(String projectName, String repoName, String branchName) {
        Check.notNullOrEmpty(projectName, "projectName");
        Check.notNullOrEmpty(projectName, "repoName");
        String urlText = this.getURL("GitRefDetailsWeb", "PublicAccessMapping", this.collectionLocationService, "Git");
        if (urlText == null) {
            urlText = this.collection.getBaseURI() + "{projectNameOrId}/_git/{repositoryId}#version={encodedRef}";
        }
        String encodedRef = StringUtil.isNullOrEmpty(branchName) ? "" : (branchName.startsWith("refs/heads/") ? "GB" + branchName.substring("refs/heads/".length()) : "GB" + branchName);
        URI uri = this.formatURL(urlText, new String[]{"projectNameOrId", projectName, "repositoryId", repoName, "encodedRef", encodedRef}, null);
        return uri;
    }

    public URI getSourceExplorerUrl(String projectName, String teamName, String serverItemPath) {
        String serverItem = serverItemPath;
        if (StringUtil.isNullOrEmpty(serverItem)) {
            serverItem = "$/";
        }
        URI uri = null;
        if (this.isCompatibleMode) {
            uri = this.getPageURL("PublicAccessMapping", "scc.aspx", this.formatQueryString("path", serverItem));
            return uri;
        }
        String urlText = this.getURL("SourceControlWeb", "PublicAccessMapping", this.locationService, "Framework");
        if (urlText == null) {
            urlText = this.getFallbackURL("_versionControl/?path={sourceControlPath}", projectName, teamName);
        }
        uri = this.formatURL(urlText, new String[]{"projectName", projectName, "teamName", teamName, "sourceControlPath", serverItem}, null);
        return uri;
    }

    public URI getSourceExplorerUrl(URI projectUri) {
        Check.notNull(projectUri, "projectUri");
        return this.getPageURL("PublicAccessMapping", "UI/Pages/Scc/Explorer.aspx?", this.formatQueryString(projectUri.toString(), new String[0]));
    }

    public URI getWorkItemPageUrl(String projectName, String teamName) {
        Check.notNullOrEmpty(projectName, "projectName");
        String urlText = this.getURL("WorkItemsWeb", "PublicAccessMapping", this.locationService, "Framework");
        if (urlText == null) {
            urlText = this.getFallbackURL("_workitems", projectName, teamName);
        }
        URI uri = this.formatURL(urlText, new String[]{"projectName", projectName, "teamName", teamName}, null);
        return uri;
    }

    public URI getWorkItemPageUrl(URI projectUri) {
        Check.notNull(projectUri, "projectUri");
        return this.getPageURL("PublicAccessMapping", "UI/Pages/WorkItems/QueryExplorer.aspx?", this.formatQueryString(projectUri.toString(), new String[0]));
    }

    public URI getBuildsPageUrl(String projectName, String teamName) {
        Check.notNullOrEmpty(projectName, "projectName");
        String urlText = this.getURL("BuildsWeb", "PublicAccessMapping", this.locationService, "Framework");
        if (urlText == null) {
            urlText = this.getFallbackURL("_build", projectName, teamName);
        }
        URI uri = this.formatURL(urlText, new String[]{"projectName", projectName, "teamName", teamName}, null);
        return uri;
    }

    public URI getBuildsPageUrl(URI projectUri) {
        Check.notNull(projectUri, "projectUri");
        return this.getPageURL("PublicAccessMapping", "UI/Pages/Build/Explorer.aspx", this.formatQueryString(projectUri.toString(), new String[0]));
    }

    public URI getSettingsPageUrl(String projectName, String teamName) {
        String urlText = this.getURL("AdministrationsWeb", "PublicAccessMapping", this.locationService, "Framework");
        if (urlText == null) {
            urlText = this.getFallbackURL("_admin", projectName, teamName);
        }
        URI uri = this.formatURL(urlText, new String[]{"projectName", projectName, "teamName", teamName}, null);
        return uri;
    }

    public URI getSettingsPageUrl(URI projectUri) {
        Check.notNull(projectUri, "projectUri");
        return this.getPageURL("PublicAccessMapping", "UI/Pages/Options.aspx", this.formatQueryString(projectUri.toString(), new String[0]));
    }

    public static URL getFileContainerURL(IBuildDetail build) {
        TFSTeamProjectCollection collection = build.getBuildServer().getConnection();
        ServerDataProvider provider = collection.getServerDataProvider();
        AccessMapping accessMapping = provider.getAccessMapping("PublicAccessMapping");
        LocationService locationService = new LocationService(collection);
        String containerServiceURI = locationService.locationForAccessMapping("FileContainersResource", ServiceInterfaceIdentifiers.FILE_CONTAINER_SERVICE, accessMapping);
        String dropLocation = build.getDropLocation();
        String[] containerParts = dropLocation.split("/");
        if (containerParts == null || containerParts.length != 3) {
            log.error((Object)MessageFormat.format(Messages.getString("BuildDropLocation.InvalidContainerPathFormat"), dropLocation));
            return null;
        }
        String containID = containerParts[1];
        String containerPath = containerParts[2];
        String url = MessageFormat.format("{0}/{1}?itemPath={2}", containerServiceURI, containID, containerPath);
        URL dropURL = null;
        try {
            dropURL = new URL(url);
        }
        catch (MalformedURLException e) {
            log.error((Object)MessageFormat.format(Messages.getString("BuildDropLocation.InvalidContainerPathFormat"), dropLocation), (Throwable)e);
            return null;
        }
        return dropURL;
    }

    private String getFallbackURL(String toolName, String projectName, String teamName) {
        if (StringUtil.isNullOrEmpty(projectName)) {
            return this.collection.getBaseURI() + toolName;
        }
        if (StringUtil.isNullOrEmpty(teamName)) {
            return this.collection.getBaseURI() + "{projectName}/" + toolName;
        }
        return this.collection.getBaseURI() + "{projectName}/{teamName}/" + toolName;
    }
}

