/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.ntlm;

import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.jni.NTLM;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.internal.ntlm.MD4Provider;
import com.microsoft.tfs.jni.internal.ntlm.NTLMException;
import com.microsoft.tfs.jni.internal.ntlm.NTLMVersionException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.HashUtils;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.text.MessageFormat;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JavaNTLM
implements NTLM {
    private static final Log LOG = LogFactory.getLog(JavaNTLM.class);
    private static boolean SUPPORT_NTLM = false;
    private static final SecureRandom prng = new SecureRandom();
    static final int FLAGS_NEGOTIATE_UNICODE = 1;
    static final int FLAGS_NEGOTIATE_OEM = 2;
    static final int FLAGS_REQUEST_TARGET = 4;
    static final int FLAGS_NEGOTIATE_NTLM = 512;
    static final int FLAGS_NEGOTIATE_DOMAIN = 4096;
    static final int FLAGS_NEGOTIATE_WORKSTATION = 8192;
    static final int FLAGS_NEGOTIATE_LOCAL_CALL = 16384;
    static final int FLAGS_NEGOTIATE_ALWAYS_SIGN = 32768;
    final int FLAGS_NEGOTIATE_TYPE_DOMAIN = 65536;
    static final int FLAGS_NEGOTIATE_NTLM2 = 524288;
    private static final Provider MD4_PROVIDER = new MD4Provider();

    public boolean isImplementationAvailable() {
        return true;
    }

    @Override
    public boolean supportsCredentialsDefault() {
        return false;
    }

    @Override
    public boolean supportsCredentialsSpecified() {
        return true;
    }

    @Override
    public String getCredentialsDefault() {
        return null;
    }

    @Override
    public NTLM.NTLMState initialize() {
        return new JavaNTLMState();
    }

    @Override
    public void setCredentialsDefault(NTLM.NTLMState state) throws NTLMException {
        throw new NTLMException(Messages.getString("JavaNTLM.DefaultCredentialsNotSupported"));
    }

    @Override
    public void setCredentialsSpecified(NTLM.NTLMState state, String username, String domain, String password) {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof JavaNTLMState, "state instanceof JavaNTLMState");
        ((JavaNTLMState)state).username = username;
        ((JavaNTLMState)state).domain = domain;
        ((JavaNTLMState)state).password = password;
    }

    @Override
    public void setTarget(NTLM.NTLMState state, String target) {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof JavaNTLMState, "state instanceof JavaNTLMState");
        ((JavaNTLMState)state).target = target;
    }

    @Override
    public void setLocalhost(NTLM.NTLMState state, String localhost) {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof JavaNTLMState, "state instanceof JavaNTLMState");
        ((JavaNTLMState)state).localhost = localhost;
    }

    @Override
    public byte[] getToken(NTLM.NTLMState state, byte[] inputToken) throws NTLMException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof JavaNTLMState, "state instanceof JavaNTLMState");
        if (inputToken == null || inputToken.length == 0 && ((JavaNTLMState)state).tokensComputed == 0) {
            ((JavaNTLMState)state).tokensComputed++;
            return JavaNTLM.getType1Message((JavaNTLMState)state);
        }
        if (inputToken != null && inputToken.length > 0 && ((JavaNTLMState)state).tokensComputed == 1) {
            ((JavaNTLMState)state).tokensComputed++;
            return JavaNTLM.getType3Message((JavaNTLMState)state, inputToken);
        }
        throw new NTLMException("Authentication routines called out of order");
    }

    @Override
    public boolean isComplete(NTLM.NTLMState state) {
        return ((JavaNTLMState)state).tokensComputed >= 2;
    }

    @Override
    public String getErrorMessage(NTLM.NTLMState state) {
        return null;
    }

    @Override
    public void dispose(NTLM.NTLMState state) {
    }

    private static byte[] getType1Message(JavaNTLMState state) throws NTLMException {
        byte[] hostBytes;
        int hostLen;
        String hostname = state.getTarget().toUpperCase();
        String domain = state.getDomain();
        if (hostname.indexOf(".") >= 0) {
            hostname = hostname.substring(0, hostname.indexOf("."));
        }
        int hostOffset = (hostLen = (hostBytes = JavaNTLM.getBytes(hostname.toUpperCase(), "US-ASCII")).length) > 0 ? 32 : 0;
        byte[] domainBytes = JavaNTLM.getBytes(domain.toUpperCase(), "US-ASCII");
        int domainLen = domainBytes.length;
        int domainOffset = domainLen > 0 ? 32 + hostLen : 0;
        int type1Length = 32 + hostBytes.length + domainBytes.length;
        byte[] type1 = new byte[type1Length];
        int flags = 0;
        flags |= 1;
        flags |= 2;
        flags |= 0x8000;
        flags |= 0x80000;
        if (SUPPORT_NTLM) {
            flags |= 0x200;
        }
        JavaNTLM.addBytes(type1, 0, JavaNTLM.getBytes("NTLMSSP", "US-ASCII"));
        JavaNTLM.addLong(type1, 8, 1);
        JavaNTLM.addLong(type1, 12, flags);
        JavaNTLM.addShort(type1, 16, domainLen);
        JavaNTLM.addShort(type1, 18, domainLen);
        JavaNTLM.addShort(type1, 20, domainOffset);
        JavaNTLM.addShort(type1, 22, 0);
        JavaNTLM.addShort(type1, 24, hostLen);
        JavaNTLM.addShort(type1, 26, hostLen);
        JavaNTLM.addShort(type1, 28, hostOffset);
        JavaNTLM.addShort(type1, 30, 0);
        JavaNTLM.addBytes(type1, 32, hostBytes);
        JavaNTLM.addBytes(type1, 32 + hostBytes.length, domainBytes);
        return type1;
    }

    private static byte[] getType3Message(JavaNTLMState state, byte[] challenge) throws NTLMException {
        byte[] ntlmResponse;
        byte[] lmResponse;
        NTLMType2Message type2;
        try {
            type2 = JavaNTLM.parseType2(challenge);
        }
        catch (Exception e) {
            throw new NTLMException(e.getMessage());
        }
        String username = state.getUsername();
        String password = state.getPassword();
        String domain = state.getDomain();
        String hostname = state.getLocalHost();
        String charset = (type2.flags & 1) == 1 ? "UTF-16LE" : "US-ASCII";
        byte[] domainBytes = JavaNTLM.getBytes(domain.toUpperCase(), charset);
        int domainLen = domainBytes.length;
        int domainOffset = domainLen > 0 ? 64 : 0;
        byte[] usernameBytes = JavaNTLM.getBytes(username.toUpperCase(), charset);
        int usernameLen = usernameBytes.length;
        int usernameOffset = usernameLen > 0 ? 64 + domainLen : 0;
        byte[] hostBytes = JavaNTLM.getBytes(hostname.toUpperCase(), charset);
        int hostnameLen = hostBytes.length;
        int hostnameOffset = hostnameLen > 0 ? 64 + domainLen + usernameLen : 0;
        int flags = 0;
        if ((type2.flags & 0x80000) == 524288) {
            lmResponse = JavaNTLM.createLm2Response(username, password, domain, type2);
            ntlmResponse = JavaNTLM.createNtlm2Response(username, password, domain, type2);
            flags |= 0x80000;
        } else {
            if (!SUPPORT_NTLM) {
                throw new NTLMVersionException(Messages.getString("JavaNTLM.NTLMVersion1NotSupportedContactAdministrator"));
            }
            lmResponse = JavaNTLM.createLmResponse(password, type2);
            try {
                ntlmResponse = JavaNTLM.createNtlmResponse(password, type2);
            }
            catch (NoSuchAlgorithmException e) {
                ntlmResponse = new byte[]{};
            }
            flags |= 0x200;
        }
        int lmResponseLen = lmResponse.length;
        int lmResponseOffset = 64 + domainLen + usernameLen + hostnameLen;
        int ntlmResponseLen = ntlmResponse.length;
        int ntlmResponseOffset = 64 + domainLen + usernameLen + hostnameLen + lmResponseLen;
        byte[] type3 = new byte[64 + domainLen + usernameLen + hostnameLen + lmResponseLen + ntlmResponseLen];
        flags = (type2.flags & 1) == 1 ? (flags |= 1) : (flags |= 2);
        JavaNTLM.addBytes(type3, 0, JavaNTLM.getBytes("NTLMSSP", "US-ASCII"));
        JavaNTLM.addLong(type3, 8, 3);
        JavaNTLM.addShort(type3, 12, lmResponseLen);
        JavaNTLM.addShort(type3, 14, lmResponseLen);
        JavaNTLM.addShort(type3, 16, lmResponseOffset);
        JavaNTLM.addShort(type3, 18, 0);
        JavaNTLM.addShort(type3, 20, ntlmResponseLen);
        JavaNTLM.addShort(type3, 22, ntlmResponseLen);
        JavaNTLM.addShort(type3, 24, ntlmResponseOffset);
        JavaNTLM.addShort(type3, 26, 0);
        JavaNTLM.addShort(type3, 28, domainLen);
        JavaNTLM.addShort(type3, 30, domainLen);
        JavaNTLM.addShort(type3, 32, domainOffset);
        JavaNTLM.addShort(type3, 34, 0);
        JavaNTLM.addShort(type3, 36, usernameLen);
        JavaNTLM.addShort(type3, 38, usernameLen);
        JavaNTLM.addShort(type3, 40, usernameOffset);
        JavaNTLM.addShort(type3, 42, 0);
        JavaNTLM.addShort(type3, 44, hostnameLen);
        JavaNTLM.addShort(type3, 46, hostnameLen);
        JavaNTLM.addShort(type3, 48, hostnameOffset);
        JavaNTLM.addShort(type3, 50, 0);
        JavaNTLM.addShort(type3, 52, 0);
        JavaNTLM.addShort(type3, 54, 0);
        JavaNTLM.addShort(type3, 56, 64 + ntlmResponseOffset + ntlmResponseLen);
        JavaNTLM.addShort(type3, 58, 0);
        JavaNTLM.addLong(type3, 60, flags);
        JavaNTLM.addBytes(type3, domainOffset, domainBytes);
        JavaNTLM.addBytes(type3, usernameOffset, usernameBytes);
        JavaNTLM.addBytes(type3, hostnameOffset, hostBytes);
        JavaNTLM.addBytes(type3, lmResponseOffset, lmResponse);
        JavaNTLM.addBytes(type3, ntlmResponseOffset, ntlmResponse);
        return type3;
    }

    private static byte[] createLmResponse(String password, NTLMType2Message type2) throws NTLMException {
        return JavaNTLM.lmNtlmResponse(JavaNTLM.lmHash(password), type2);
    }

    private static byte[] createNtlmResponse(String password, NTLMType2Message type2) throws NTLMException, NoSuchAlgorithmException {
        return JavaNTLM.lmNtlmResponse(JavaNTLM.ntlmHash(password), type2);
    }

    private static byte[] createLm2Response(String username, String password, String domain, NTLMType2Message type2) throws NTLMException {
        byte[] hashedChallenges;
        byte[] ntlm2Hash = JavaNTLM.ntlm2Hash(username, password, domain);
        byte[] clientNonce = JavaNTLM.createClientNonce();
        byte[] challenges = new byte[type2.challenge.length + clientNonce.length];
        JavaNTLM.addBytes(challenges, 0, type2.challenge);
        JavaNTLM.addBytes(challenges, type2.challenge.length, clientNonce);
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(new SecretKeySpec(ntlm2Hash, "HmacMD5"));
            hashedChallenges = mac.doFinal(challenges);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load HmacMD5 for NTLM", (Throwable)e);
            throw new NTLMException(e.getMessage());
        }
        byte[] lm2Response = new byte[hashedChallenges.length + clientNonce.length];
        JavaNTLM.addBytes(lm2Response, 0, hashedChallenges);
        JavaNTLM.addBytes(lm2Response, hashedChallenges.length, clientNonce);
        return lm2Response;
    }

    private static byte[] createNtlm2Response(String username, String password, String domain, NTLMType2Message type2) throws NTLMException {
        byte[] blobHash;
        byte[] ntlm2Hash = JavaNTLM.ntlm2Hash(username, password, domain);
        int targetInfoLen = type2.targetInfo != null ? type2.targetInfo.length : 0;
        byte[] ntlm2Blob = new byte[40 + targetInfoLen];
        JavaNTLM.addBytes(ntlm2Blob, 0, new byte[]{1, 1, 0, 0});
        JavaNTLM.addLong(ntlm2Blob, 4, 0);
        JavaNTLM.addBytes(ntlm2Blob, 8, JavaNTLM.createTimestamp());
        JavaNTLM.addBytes(ntlm2Blob, 16, JavaNTLM.createClientNonce());
        JavaNTLM.addBytes(ntlm2Blob, 24, new byte[]{-83, -34, 21, -19});
        if (targetInfoLen > 0) {
            JavaNTLM.addBytes(ntlm2Blob, 28, type2.targetInfo);
        }
        JavaNTLM.addBytes(ntlm2Blob, 28 + targetInfoLen, new byte[]{-83, -34, 21, -19});
        byte[] challengedBlob = new byte[type2.challenge.length + ntlm2Blob.length];
        JavaNTLM.addBytes(challengedBlob, 0, type2.challenge);
        JavaNTLM.addBytes(challengedBlob, type2.challenge.length, ntlm2Blob);
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(new SecretKeySpec(ntlm2Hash, "HmacMD5"));
            blobHash = mac.doFinal(challengedBlob);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load HmacMD5 for NTLM", (Throwable)e);
            throw new NTLMException(e.getMessage());
        }
        byte[] ntlm2Response = new byte[blobHash.length + ntlm2Blob.length];
        JavaNTLM.addBytes(ntlm2Response, 0, blobHash);
        JavaNTLM.addBytes(ntlm2Response, blobHash.length, ntlm2Blob);
        return ntlm2Response;
    }

    private static byte[] lmHash(String password) throws NTLMException {
        byte[] hashed2;
        byte[] hashed1;
        byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] passwordBytes = JavaNTLM.getBytes(password.toUpperCase(), "US-ASCII");
        byte[] password1 = new byte[7];
        byte[] password2 = new byte[7];
        for (int i = 0; i < 7; ++i) {
            password1[i] = passwordBytes.length > i ? passwordBytes[i] : (byte)0;
            password2[i] = passwordBytes.length > 7 + i ? passwordBytes[7 + i] : (byte)0;
        }
        try {
            Cipher desCipher = Cipher.getInstance("DES/ECB/NoPadding");
            desCipher.init(1, JavaNTLM.createDesKey(password1));
            hashed1 = desCipher.doFinal(magic);
            desCipher.init(1, JavaNTLM.createDesKey(password2));
            hashed2 = desCipher.doFinal(magic);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load DES for NTLM", (Throwable)e);
            throw new NTLMException(e.getMessage());
        }
        byte[] lmHash = new byte[16];
        for (int i = 0; i < 8; ++i) {
            lmHash[i] = hashed1.length > i ? hashed1[i] : (byte)0;
            lmHash[8 + i] = hashed2.length > i ? hashed2[i] : (byte)0;
        }
        return lmHash;
    }

    private static byte[] ntlmHash(String password) throws NTLMException {
        try {
            return HashUtils.hashString(password, "UTF-16LE", "MD4", MD4_PROVIDER);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load MD4 for NTLM", (Throwable)e);
            throw new NTLMException(e.getLocalizedMessage());
        }
    }

    private static byte[] ntlm2Hash(String username, String password, String domain) throws NTLMException {
        byte[] ntlm2Hash;
        byte[] ntlmHash = JavaNTLM.ntlmHash(password);
        byte[] usernameBytes = JavaNTLM.getBytes(username.toUpperCase(), "UTF-16LE");
        byte[] domainBytes = JavaNTLM.getBytes(domain.toUpperCase(), "UTF-16LE");
        byte[] usernameDomainBytes = new byte[usernameBytes.length + domainBytes.length];
        for (int i = 0; i < usernameBytes.length; ++i) {
            usernameDomainBytes[i] = usernameBytes[i];
        }
        for (int j = 0; j < domainBytes.length; ++j) {
            usernameDomainBytes[i + j] = domainBytes[j];
        }
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(new SecretKeySpec(ntlmHash, "HmacMD5"));
            ntlm2Hash = mac.doFinal(usernameDomainBytes);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load HmacMD5 for NTLM", (Throwable)e);
            throw new NTLMException(e.getMessage());
        }
        return ntlm2Hash;
    }

    private static byte[] lmNtlmResponse(byte[] hash, NTLMType2Message type2) throws NTLMException {
        byte[] crypt3;
        byte[] crypt2;
        byte[] crypt1;
        byte[] password1 = new byte[7];
        byte[] password2 = new byte[7];
        byte[] password3 = new byte[7];
        for (int i = 0; i < 7; ++i) {
            password1[i] = hash.length > i ? hash[i] : (byte)0;
            password2[i] = hash.length > 7 + i ? hash[7 + i] : (byte)0;
            password3[i] = hash.length > 14 + i ? hash[14 + i] : (byte)0;
        }
        try {
            Cipher desCipher = Cipher.getInstance("DES/ECB/NoPadding");
            desCipher.init(1, JavaNTLM.createDesKey(password1));
            crypt1 = desCipher.doFinal(type2.challenge);
            desCipher.init(1, JavaNTLM.createDesKey(password2));
            crypt2 = desCipher.doFinal(type2.challenge);
            desCipher.init(1, JavaNTLM.createDesKey(password3));
            crypt3 = desCipher.doFinal(type2.challenge);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load DES for NTLM", (Throwable)e);
            throw new NTLMException(e.getMessage());
        }
        byte[] lmResponse = new byte[24];
        for (int i = 0; i < 8; ++i) {
            lmResponse[i] = crypt1[i];
            lmResponse[8 + i] = crypt2[i];
            lmResponse[16 + i] = crypt3[i];
        }
        return lmResponse;
    }

    private static byte[] createTimestamp() {
        long timestamp = System.currentTimeMillis();
        timestamp += 11644473600000L;
        byte[] timeBytes = new byte[]{(byte)((timestamp *= 10000L) & 0xFFL), (byte)((timestamp & 0xFF00L) >> 8), (byte)((timestamp & 0xFF0000L) >> 16), (byte)((timestamp & 0xFF000000L) >> 24), (byte)((timestamp & 0xFF00000000L) >> 32), (byte)((timestamp & 0xFF0000000000L) >> 40), (byte)((timestamp & 0xFF000000000000L) >> 48), (byte)((timestamp & 0xFF00000000000000L) >> 56)};
        return timeBytes;
    }

    private static byte[] createClientNonce() {
        byte[] nonce = new byte[8];
        prng.nextBytes(nonce);
        return nonce;
    }

    private static Key createDesKey(byte[] ascii) {
        byte[] keyData = new byte[]{(byte)(ascii[0] >> 1 & 0xFF), (byte)(((ascii[0] & 1) << 6 | (ascii[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((ascii[1] & 3) << 5 | (ascii[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((ascii[2] & 7) << 4 | (ascii[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((ascii[3] & 0xF) << 3 | (ascii[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((ascii[4] & 0x1F) << 2 | (ascii[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((ascii[5] & 0x3F) << 1 | (ascii[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(ascii[6] & 0x7F)};
        for (int i = 0; i < keyData.length; ++i) {
            keyData[i] = (byte)(keyData[i] << 1);
        }
        return new SecretKeySpec(keyData, "DES");
    }

    private static NTLMType2Message parseType2(byte[] type2) throws Exception {
        NTLMType2Message message = new NTLMType2Message();
        if (type2.length < 32) {
            throw new Exception("Not an NTLMSSP Type 2 message, or truncated");
        }
        if (type2[0] != 78 || type2[1] != 84 || type2[2] != 76 || type2[3] != 77 || type2[4] != 83 || type2[5] != 83 || type2[6] != 80 || type2[7] != 0) {
            throw new Exception("Not an NTLMSSP message");
        }
        short s = JavaNTLM.readShort(type2, 8);
        message.indicator = s;
        if (s != 2) {
            throw new Exception("Not an NTLMSSP Type 2 message");
        }
        short targetNameLen = JavaNTLM.readShort(type2, 12);
        short targetNameSpace = JavaNTLM.readShort(type2, 14);
        short targetNameOffset = JavaNTLM.readShort(type2, 16);
        short targetNameZero = JavaNTLM.readShort(type2, 18);
        if (targetNameZero != 0 || type2.length < targetNameOffset + targetNameSpace) {
            throw new Exception("Corrupt NTLMSSP Type 2 message, truncated in targetname");
        }
        if (targetNameOffset > 0 && targetNameLen > 0) {
            message.targetName = JavaNTLM.readBytes(type2, targetNameOffset, targetNameLen);
        }
        message.flags = JavaNTLM.readLong(type2, 20);
        message.challenge = JavaNTLM.readBytes(type2, 24, 8);
        if (type2.length > 48 && targetNameOffset >= 48) {
            message.context = JavaNTLM.readBytes(type2, 32, 8);
            short targetInformationLen = JavaNTLM.readShort(type2, 40);
            short targetInformationSpace = JavaNTLM.readShort(type2, 42);
            short targetInformationOffset = JavaNTLM.readShort(type2, 44);
            short targetInformationZero = JavaNTLM.readShort(type2, 46);
            if (targetInformationZero != 0 || type2.length < targetInformationOffset + targetInformationSpace) {
                throw new Exception("Corrupt NTLMSSP Type 2 message, truncated in target information");
            }
            if (targetInformationOffset > 0 && targetInformationLen > 0) {
                message.targetInfo = JavaNTLM.readBytes(type2, targetInformationOffset, targetInformationLen);
            }
        } else {
            LOG.error((Object)"No target information in NTLMSSP Type 2 message, NTLM2 must fail");
        }
        return message;
    }

    private static void addByte(byte[] buf, int pos, byte b) {
        if (pos < 0 || buf.length < pos + 1) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to add one byte at position {0} to array of length {1}", pos, buf.length));
        }
        buf[pos++] = b;
    }

    private static void addBytes(byte[] buf, int pos, byte[] bytes) {
        if (pos < 0 || buf.length < pos + bytes.length) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to add {0} bytes at position {1} to array of length {2}", bytes.length, pos, buf.length));
        }
        for (int i = 0; i < bytes.length; ++i) {
            buf[pos++] = bytes[i];
        }
    }

    private static void addLong(byte[] buf, int pos, int longnum) {
        if (pos < 0 || buf.length < pos + 4) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to add long (4 bytes) at position {0} to array of length {1}", pos, buf.length));
        }
        JavaNTLM.addByte(buf, pos, (byte)(longnum & 0xFF));
        JavaNTLM.addByte(buf, pos + 1, (byte)((longnum & 0xFF00) >> 8));
        JavaNTLM.addByte(buf, pos + 2, (byte)((longnum & 0xFF0000) >> 16));
        JavaNTLM.addByte(buf, pos + 3, (byte)((longnum & 0xFF000000) >> 24));
    }

    private static void addShort(byte[] buf, int pos, int shortnum) {
        if (pos < 0 || buf.length < pos + 2) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to add short (2 bytes) at position {0} to array of length {1}", pos, buf.length));
        }
        JavaNTLM.addByte(buf, pos, (byte)(shortnum & 0xFF));
        JavaNTLM.addByte(buf, pos + 1, (byte)((shortnum & 0xFF00) >> 8));
    }

    private static int readLong(byte[] buf, int pos) {
        if (pos < 0 || pos + 4 > buf.length) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to read long (4 bytes) at position {0} from array of length {1}", pos, buf.length));
        }
        return (buf[pos + 3] & 0xFF) << 24 | (buf[pos + 2] & 0xFF) << 16 | (buf[pos + 1] & 0xFF) << 8 | buf[pos] & 0xFF;
    }

    private static short readShort(byte[] buf, int pos) {
        if (pos < 0 || pos + 2 > buf.length) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to read short (2 bytes) at position {0} from array of length {1}", pos, buf.length));
        }
        return (short)((buf[pos + 1] & 0xFF) << 8 | buf[pos] & 0xFF);
    }

    private static byte[] readBytes(byte[] buf, int pos, int len) {
        if (pos < 0 || pos + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException(MessageFormat.format("Attempt to read {0} bytes at position {1} from array of length {2}", len, pos, buf.length));
        }
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = buf[pos + i];
        }
        return result;
    }

    private static byte[] getBytes(String string, String encoding) throws NTLMException {
        try {
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new NTLMException(e.getMessage(), e);
        }
    }

    private class JavaNTLMState
    extends NTLM.NTLMState {
        private int tokensComputed = 0;
        private String username;
        private String domain;
        private String password;
        private String target;
        private String localhost;

        private JavaNTLMState() {
        }

        private String getUsername() {
            return this.username == null ? "" : this.username;
        }

        private String getDomain() {
            return this.domain == null ? "" : this.domain;
        }

        private String getPassword() {
            return this.password == null ? "" : this.password;
        }

        private String getTarget() {
            return this.target == null ? "" : this.target;
        }

        private String getLocalHost() {
            String host;
            String string = host = this.localhost == null ? PlatformMiscUtils.getInstance().getComputerName() : this.localhost;
            if (host.indexOf(".") >= 0) {
                host = host.substring(0, host.indexOf("."));
            }
            return host.toUpperCase();
        }
    }

    private static class NTLMType2Message {
        public int indicator = 0;
        public int flags = 0;
        public byte[] challenge = null;
        public byte[] context = null;
        public byte[] targetName = null;
        public byte[] targetInfo = null;

        private NTLMType2Message() {
        }
    }
}

